---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-_devMiddlewareManifest.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  1. 全項目が根拠付きのため、特に優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/shared/lib/constants.ts` 行106（DEV_CLIENT_MIDDLEWARE_MANIFEST定数）
- E-02: `packages/next/src/server/lib/router-utils/setup-dev-bundler.ts` 行1268-1269（パス定義・登録）
- E-03: `packages/next/src/server/lib/router-utils/setup-dev-bundler.ts` 行1271-1272（Turbopackパス登録）
- E-04: `packages/next/src/server/lib/router-utils/setup-dev-bundler.ts` 行1291-1299（requestHandler）
- E-05: `packages/next/src/client/page-loader.ts` 行128-151（getMiddleware開発モード）
- E-06: `packages/next/src/client/page-loader.ts` 行129-130（__DEV_MIDDLEWARE_MATCHERSチェック）
- E-07: `packages/next/src/client/page-loader.ts` 行136（fetchパス: buildId含む）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 定数名はDEV_CLIENT_MIDDLEWARE_MANIFEST | E-01 | ○ |
| C-02 | 値は_devMiddlewareManifest.json | E-01 | ○ |
| C-03 | devVirtualFsItemsに登録（仮想ファイル） | E-02 | ○ |
| C-04 | Turbopackパスも同時登録 | E-03 | ○ |
| C-05 | requestHandlerでHTTPレスポンスとして提供 | E-04 | ○ |
| C-06 | devMiddlewareManifestPathとdevTurbopackMiddlewareManifestPathの両方にマッチ | E-04（行1292-1294） | ○ |
| C-07 | serverFields.middleware.matchersを返却 | E-04（行1298） | ○ |
| C-08 | ミドルウェア未定義時は空配列 | E-04（行1298: `\|\| []`） | ○ |
| C-09 | __DEV_MIDDLEWARE_MATCHERSキャッシュ | E-06 | ○ |
| C-10 | fetchで取得しwindow.__DEV_MIDDLEWARE_MATCHERSに設定 | E-05（行140-141） | ○ |
| C-11 | credentials: 'same-origin' | E-05（行138） | ○ |
| C-12 | fetch失敗時にconsole.logでエラー表示 | E-05（行144-146） | ○ |
| C-13 | fetchパスにbuildIdを含む | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Turbopackパスとwebpackパスの両方で同じレスポンスが返されることを確認
- [ ] serverFields.middleware?.matchersの取得元が正確か確認
- [ ] 本番モードとの切り替え（webpack: process.env, Turbopack: _clientMiddlewareManifest.js）が正確か確認
