---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：5-routes-manifest.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **dataRoutesの更新タイミング**：初期値は空配列だが更新処理の確認が必要
  2. **RoutesManifest型定義の場所**：build/index.tsのimport先の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/generate-routes-manifest.ts` - generateRoutesManifest関数全体（1〜156行目）
- E-02: `packages/next/src/shared/lib/constants.ts` - ROUTES_MANIFEST定数（98行目）
- E-03: `packages/next/src/client/components/app-router-headers.ts` - RSCヘッダー定数群
- E-04: `packages/next/src/build/index.ts` - ビルドプロセスからの呼び出し

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | generateRoutesManifest関数により生成される | E-01 (52行目) | ○ |
| C-02 | 出力先は.next/routes-manifest.json | E-02 (98行目) | ○ |
| C-03 | version 3 が現在のバージョン | E-01 (96行目) | ○ |
| C-04 | pages404はtrue | E-01 (97行目) | ○ |
| C-05 | appTypeはoptions.appTypeから取得 | E-01 (98行目) | ○ |
| C-06 | caseSensitiveはconfig.experimental.caseSensitiveRoutesから取得 | E-01 (99行目) | ○ |
| C-07 | basePathはconfig.basePathから取得 | E-01 (100行目) | ○ |
| C-08 | sortPagesでルートがソートされる | E-01 (67行目) | ○ |
| C-09 | isDynamicRouteで動的/静的を判別 | E-01 (78行目) | ○ |
| C-10 | redirectsはbuildCustomRouteで変換 | E-01 (101〜103行目) | ○ |
| C-11 | headersはbuildCustomRouteで変換 | E-01 (104行目) | ○ |
| C-12 | rewritesはbeforeFiles/afterFiles/fallbackの3分類 | E-01 (105〜113行目) | ○ |
| C-13 | rsc.headerはRSC_HEADER | E-01 (119行目) | ○ |
| C-14 | rsc.varyHeaderは4つのヘッダーの結合 | E-01 (122行目) | ○ |
| C-15 | rsc.clientParamParsingはconfig.cacheComponentsに基づく | E-01 (130行目) | ○ |
| C-16 | ppr設定はisAppPPREnabled時のみ設定 | E-01 (140〜148行目) | ○ |
| C-17 | dataRoutesは空配列で初期化 | E-01 (116行目) | ○ |
| C-18 | dataRoutesはビルド後処理で更新される場合がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- dataRoutesの更新処理の場所と条件が未確認
  - 候補：build/index.tsの後処理 / adapter処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なフィールドはgenerateRoutesManifest関数で確認済み
- 1: 中リスク - dataRoutesの後処理に関する記述は推測を含む
- 0: 低リスク - RSC/PPR設定はソースコードで直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] RoutesManifest型定義の全フィールドが設計書に記載されているか確認
- [ ] dataRoutesの更新処理を確認
- [ ] deploymentId/skipProxyUrlNormalizeの設定条件を確認
