---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：6-prerender-manifest.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **PrerenderManifest型定義の完全性**：全フィールドの型定義場所の特定
  2. **i18nロケール別ルート追加の詳細処理**：条件分岐が複雑

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/index.ts` - prerenderManifest初期化（2874〜2880行目）
- E-02: `packages/next/src/build/index.ts` - routes構築処理（3357〜3373行目）
- E-03: `packages/next/src/build/index.ts` - dynamicRoutes構築処理（3545〜3570行目）
- E-04: `packages/next/src/build/index.ts` - writePrerenderManifest関数（548〜555行目）
- E-05: `packages/next/src/build/index.ts` - writeClientSsgManifest関数（557〜589行目）
- E-06: `packages/next/src/shared/lib/constants.ts` - PRERENDER_MANIFEST定数（97行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | writePrerenderManifest関数で出力される | E-04 (548行目) | ○ |
| C-02 | 出力先は.next/prerender-manifest.json | E-06 (97行目), E-04 (555行目) | ○ |
| C-03 | version 4 が現在のバージョン | E-01 (2875行目) | ○ |
| C-04 | routesはinitialRevalidateSecondsを含む | E-02 (3367行目) | ○ |
| C-05 | routesはinitialExpireSecondsを含む | E-02 (3368行目) | ○ |
| C-06 | routesはsrcRouteを含む | E-02 (3369行目) | ○ |
| C-07 | routesはdataRouteを含む | E-02 (3370行目) | ○ |
| C-08 | routesはrenderingModeを含む（PPR時PARTIALLY_STATIC） | E-02 (3360〜3364行目) | ○ |
| C-09 | dynamicRoutesはrouteRegexを含む | E-03 (3553〜3557行目) | ○ |
| C-10 | dynamicRoutesはfallbackを含む | E-03 (3559行目) | ○ |
| C-11 | notFoundRoutesが存在する | E-01 (2878行目) | ○ |
| C-12 | previewフィールドにpreviewModeId等が含まれる | E-01 (2879行目) | ○ |
| C-13 | 出力前にsortPagesObjectでソートされる | E-04 (553〜554行目) | ○ |
| C-14 | 出力後にwriteClientSsgManifestが呼ばれる | E-05 (557行目) | ○ |
| C-15 | initialRevalidateSeconds: falseはISR無効を意味する | E-02 (3367行目 `cacheControl.revalidate`) | ○ |
| C-16 | 404ルートのinitialStatusは404 | E-02 (3353〜3355行目) | ○ |
| C-17 | App RouteHandlerのdataRouteはnull | E-02 (3341〜3342行目) | ○ |
| C-18 | i18n設定時にロケール別ルートが追加される | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- i18nロケール別ルート追加の詳細処理は build/index.ts の別の箇所にあるが、具体的な行番号の確認が不完全
  - 候補：build/index.ts の 3870〜3895行目付近

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要フィールドはソースコードの行番号レベルで追跡可能
- 1: 中リスク - PrerenderManifest型定義の全フィールド網羅性
- 2: 高リスク - preview情報は秘密情報を含むため、セキュリティレビュー重要

## 6) レビュアーチェックリスト（最小）
- [ ] PrerenderManifest型の全フィールドが設計書に記載されているか確認
- [ ] previewフィールドの秘密情報がデプロイ時に適切に保護されているか確認
- [ ] i18nロケール別ルート追加処理を確認
- [ ] PPR関連フィールドのexperimental表記が最新かどうか確認
