---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：7-middleware-manifest.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **env（edgeEnvironments）の設定ソース**：opts.edgeEnvironmentsの由来

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack/plugins/middleware-plugin.ts` - MiddlewarePlugin全体（1〜350行目以上）
- E-02: `packages/next/src/shared/lib/constants.ts` - MIDDLEWARE_MANIFEST定数（102行目）
- E-03: `packages/next/src/build/index.ts` - ビルドプロセスでの読み込み（2870行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MiddlewarePluginにより生成される | E-01 (71行目 NAME定数, getCreateAssets関数) | ○ |
| C-02 | 出力先は.next/server/middleware-manifest.json | E-02 (102行目), E-01 (253行目) | ○ |
| C-03 | version 3 が現在のバージョン | E-01 (72行目 MANIFEST_VERSION, 164行目) | ○ |
| C-04 | MiddlewareManifest型はversion/sortedMiddleware/middleware/functionsを含む | E-01 (55〜60行目) | ○ |
| C-05 | EdgeFunctionDefinitionはfiles/name/page/matchers/wasm/assets/regionsを含む | E-01 (44〜53行目) | ○ |
| C-06 | Edge FunctionはisEdgeFunction判定でfunctionsに分類 | E-01 (242行目) | ○ |
| C-07 | ミドルウェアはmiddlewareフィールドに分類 | E-01 (245行目) | ○ |
| C-08 | sortedMiddlewareはgetSortedRoutesで生成 | E-01 (249〜251行目) | ○ |
| C-09 | getEntryFilesがEdge SSR時に追加ファイルを含める | E-01 (101〜154行目) | ○ |
| C-10 | SERVER_REFERENCE_MANIFEST.jsが含まれる（Edge SSR時） | E-01 (110行目) | ○ |
| C-11 | CLIENT_REFERENCE_MANIFESTが含まれる（Edge SSR時） | E-01 (114〜125行目) | ○ |
| C-12 | interception-route-rewrite-manifest.jsが同時出力される | E-01 (179〜186行目) | ○ |
| C-13 | instrumentationHook存在時にedge-instrumentation.jsが追加される | E-01 (143〜145行目) | ○ |
| C-14 | マッチャーはgetNamedMiddlewareRegexで生成 | E-01 (209〜211行目) | ○ |
| C-15 | Node.js APIの使用を検出して警告する | E-01 (340〜349行目) | ○ |
| C-16 | envフィールドはopts.edgeEnvironmentsから取得 | E-01 (238行目) | △ |

## 4) 不足情報（Unknown / Missing）
- edgeEnvironmentsの設定元（MiddlewarePlugin Optionsの構築箇所）が未確認
  - 候補：webpack-config.ts内のMiddlewarePluginインスタンス生成箇所

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型定義・マニフェスト構造はソースコードで完全に追跡可能
- 1: 中リスク - envフィールドに含まれる環境変数のセキュリティ影響
- 0: 低リスク - getEntryFiles関数の追加ファイルリストは明示的に列挙されている

## 6) レビュアーチェックリスト（最小）
- [ ] MiddlewareManifest型定義が最新のソースコードと一致しているか確認
- [ ] envフィールドに秘密情報が含まれないか確認
- [ ] Edge SSR時の追加ファイルリストの網羅性を確認
