---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-react-loadable-manifest.json

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - 全主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack/plugins/react-loadable-plugin.ts` - ReactLoadablePlugin全体（1〜252行目）
- E-02: `packages/next/src/shared/lib/constants.ts` - REACT_LOADABLE_MANIFEST定数（107行目）
- E-03: `packages/next/src/server/load-components.ts` - ReactLoadableManifest型定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReactLoadablePluginにより生成される | E-01 (168行目クラス定義) | ○ |
| C-02 | 出力先は.next/react-loadable-manifest.json | E-02 (107行目) | ○ |
| C-03 | import()依存のみが対象 | E-01 (88行目) | ○ |
| C-04 | キーは「originFile -> importRequest」形式 | E-01 (104行目) | ○ |
| C-05 | 開発時のIDはキー文字列、本番は数値ID | E-01 (148行目) | ○ |
| C-06 | ファイルは.jsと.cssでstatic/(chunks\|css)/にマッチするもの | E-01 (130〜131行目) | ○ |
| C-07 | projectSrcDirはpagesOrAppDirの親ディレクトリ | E-01 (190〜191行目) | ○ |
| C-08 | マニフェストはキーでソートされる | E-01 (157〜160行目) | ○ |
| C-09 | runtimeAsset指定時にmiddleware-react-loadable-manifest.jsが出力される | E-01 (207〜216行目) | ○ |
| C-10 | self.__REACT_LOADABLE_MANIFESTにセットされる | E-01 (211行目) | ○ |
| C-11 | shouldCreateDynamicCssManifestはPages+Prod+Webpack時にtrue | E-01 (193行目) | ○ |
| C-12 | dynamic-css-manifest.jsonが条件付きで生成される | E-01 (221〜236行目) | ○ |
| C-13 | projectSrcDir未定義時は空マニフェストが返る | E-01 (67〜71行目) | ○ |
| C-14 | 同一モジュールの複数チャンクグループ参照時にマージされる | E-01 (111〜120行目) | ○ |
| C-15 | handleBlock関数は再帰的にブロックを走査する | E-01 (85行目) | ○ |
| C-16 | PROCESS_ASSETS_STAGE_ADDITIONSステージで実行される | E-01 (244行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードの行番号レベルで裏付け可能
- 0: 低リスク - プラグインの処理フローは明確

## 6) レビュアーチェックリスト（最小）
- [ ] ReactLoadableManifest型定義（load-components.ts）が最新と一致しているか確認
- [ ] dynamic-css-manifest生成条件（Pages+Prod+Webpack）が正しいか確認
