---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：9-client-reference-manifest

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **emitAssetの最終出力形式**：JavaScriptファイルとしての出力コードの全体構造

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/webpack/plugins/flight-manifest-plugin.ts` - ClientReferenceManifestPlugin全体（1〜450行目以上）
- E-02: `packages/next/src/shared/lib/constants.ts` - CLIENT_REFERENCE_MANIFEST定数（126行目）
- E-03: `packages/next/src/build/webpack/plugins/flight-client-entry-plugin.ts` - pluginStateの設定元

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ClientReferenceManifestPluginにより生成される | E-01 (209行目クラス定義) | ○ |
| C-02 | 出力先は.next/server/[entry]/page_client-reference-manifest.js | E-02 (126行目) | ○ |
| C-03 | ClientReferenceManifest型はmoduleLoading/ssrModuleMapping/edgeSSRModuleMapping/clientModules/entryCSSFiles/rscModuleMapping/edgeRscModuleMappingを含む | E-01 (99〜116行目) | ○ |
| C-04 | ManifestNode型はid/name/chunks/asyncを含む | E-01 (54〜74行目) | ○ |
| C-05 | PROCESS_ASSETS_STAGE_ANALYSEステージで実行される | E-01 (229行目) | ○ |
| C-06 | moduleLoading.prefixはcompilation.outputOptions.publicPathから取得 | E-01 (254行目) | ○ |
| C-07 | crossOriginModeは'use-credentials'または空文字に変換される | E-01 (243〜247行目) | ○ |
| C-08 | rootMainFilesが除外される | E-01 (258〜266行目) | ○ |
| C-09 | entryNameToGroupNameでグループ化される | E-01 (164〜187行目) | ○ |
| C-10 | mergeManifestで同一グループがマージされる | E-01 (189〜205行目) | ○ |
| C-11 | pluginStateにssrModules/edgeSsrModules/rscModulesが保持される | E-01 (46〜52行目) | ○ |
| C-12 | publicPathが文字列でない場合にエラーが投げられる | E-01 (249〜253行目) | ○ |
| C-13 | entryCSSFilesが.cssファイルのフィルタで構築される | E-01 (297〜318行目) | ○ |
| C-14 | experimentalInlineCssが有効な場合にCSS内容が埋め込まれる | E-01 (303〜311行目) | ○ |
| C-15 | Barrel Optimization対応でformatBarrelOptimizedResourceが使用される | E-01 (367〜373行目) | ○ |
| C-16 | ESM Resource変換（next/dist/ → next/dist/esm/）が行われる | E-01 (356〜362行目) | ○ |
| C-17 | getAppPathRequiredChunksでチャンク情報が取得される | E-01 (320行目) | ○ |
| C-18 | 最終出力がglobalThis.__RSC_MANIFEST形式のJavaScript | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- emitAssetで出力されるJavaScriptの全体テンプレート（globalThis.__RSC_MANIFEST への代入形式）の確認が不完全
  - 候補：flight-manifest-plugin.tsの後半部分（450行目以降）に出力テンプレートがある可能性

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型定義は完全にソースコードで追跡可能
- 1: 中リスク - pluginStateの共有状態管理（複数コンパイラ間）の正確性
- 0: 低リスク - 各フィールドの生成ロジックは行番号レベルで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ClientReferenceManifest型定義が最新のソースコードと一致しているか確認
- [ ] emitAssetの出力JavaScript形式（globalThis.__RSC_MANIFEST）を確認
- [ ] pluginState.ssrModules等がflight-client-entry-plugin.tsで正しく設定されているか確認
- [ ] experimentalInlineCssのHMR非対応について最新状況を確認
