---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 93
  claims_with_evidence: 88
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された業務要件一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：88 / 93、根拠なし：5
- 優先レビュー（高）
  1. **BR-37 Partial Prerendering（PPR）**：実験的機能のため、仕様が変更される可能性あり
  2. **BR-44 use cacheディレクティブ**：実験的機能のため、APIが安定していない可能性あり
  3. **BR-91 テストAPI**：experimental配下のため、正式APIとしての安定性が未確認
  4. **BR-82 マルチゾーン統合**：basePath・rewritesの組み合わせで実現される間接的な機能のため詳細な業務要件の検証が必要
  5. **BR-92 MCPサーバー統合**：比較的新しい機能のため、対象範囲の網羅性の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `packages/next/src/cli/next-dev.ts` - 開発サーバーCLIエントリーポイント
- E-02: `packages/next/src/cli/next-build.ts` - ビルドCLIエントリーポイント
- E-03: `packages/next/src/cli/next-start.ts` - プロダクションサーバーCLIエントリーポイント
- E-04: `packages/next/src/server/lib/router-server.ts` - Router Server実装
- E-05: `packages/next/src/server/app-render/action-handler.ts` - Server Actionsハンドラー
- E-06: `packages/next/src/server/app-render/csrf-protection.ts` - CSRF保護実装
- E-07: `packages/next/src/server/app-render/encryption.ts` - Server Actions暗号化実装
- E-08: `packages/next/src/server/image-optimizer.ts` - 画像最適化処理
- E-09: `packages/next/src/server/lib/patch-fetch.ts` - fetch拡張（データキャッシュ）
- E-10: `packages/next/src/server/lib/incremental-cache/index.ts` - インクリメンタルキャッシュ
- E-11: `packages/next/src/server/web/spec-extension/revalidate.ts` - revalidateTag/revalidatePath
- E-12: `packages/next/src/lib/metadata/metadata.tsx` - Metadata API実装
- E-13: `packages/next/src/server/config.ts` - next.config設定読み込み
- E-14: `packages/next/src/client/link.tsx` - Linkコンポーネント実装
- E-15: `packages/next/src/server/after/after.ts` - after() API実装
- E-16: `packages/next/src/server/app-render/dynamic-rendering.ts` - 動的レンダリング制御
- E-17: `packages/next/src/build/index.ts` - ビルドプロセス本体
- E-18: `packages/next/src/export/index.ts` - 静的エクスポート処理
- E-19: `packages/create-next-app/create-app.ts` - create-next-app実装
- E-20: `packages/next/src/shared/lib/i18n/` - 国際化モジュール群
- E-21: `docs/code-to-docs/機能一覧/機能一覧.csv` - 既存の機能一覧ドキュメント
- E-22: `docs/code-to-docs/画面一覧/画面一覧.csv` - 既存の画面一覧ドキュメント
- E-23: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 既存の画面機能マッピングドキュメント
- E-24: `packages/next/src/server/dev/on-demand-entry-handler.ts` - オンデマンドコンパイル
- E-25: `packages/next/src/server/lib/router-utils/block-cross-site.ts` - クロスサイトブロック
- E-26: `packages/next/src/server/is-private-ip.ts` - プライベートIPチェック
- E-27: `packages/next/src/server/web/spec-extension/request.ts` - NextRequest実装
- E-28: `packages/next/src/server/web/spec-extension/response.ts` - NextResponse実装
- E-29: `packages/next/src/server/route-modules/app-route/` - Route Handlers実装
- E-30: `packages/next/src/server/route-modules/pages/` - Pages Router実装
- E-31: `packages/next/src/server/route-modules/pages-api/` - Pages API Routes実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新規プロジェクト作成（create-next-app） | E-19 | ○ |
| C-02 | テンプレートベースのプロジェクト生成 | E-19 | ○ |
| C-03 | 開発サーバーの起動 | E-01 | ○ |
| C-04 | Hot Module Replacement | E-01, E-21 | ○ |
| C-05 | オンデマンドコンパイル | E-24 | ○ |
| C-06 | HTTPS開発サーバー | E-01 | ○ |
| C-07 | プロダクションビルドの実行 | E-02, E-17 | ○ |
| C-08 | 静的/動的レンダリングの自動判定 | E-17 | ○ |
| C-09 | コード分割とツリーシェイキング | E-17, E-21 | ○ |
| C-10 | マニフェスト生成 | E-17 | ○ |
| C-11 | ビルド依存関係トレース | E-17 | ○ |
| C-12 | Turbopackビルド統合 | E-02, E-21 | ○ |
| C-13 | Rspackビルド統合 | E-21 | ○ |
| C-14 | SWCコンパイラ統合 | E-21 | ○ |
| C-15 | プロダクションサーバーの起動 | E-03 | ○ |
| C-16 | リクエストルーティング | E-04 | ○ |
| C-17 | Keep-Aliveタイムアウト制御 | E-03 | ○ |
| C-18 | ファイルシステムベースルーティング（App Router） | E-05, E-21 | ○ |
| C-19 | ネストされたレイアウト | E-21, E-22 | ○ |
| C-20 | ローディング状態表示 | E-21 | ○ |
| C-21 | エラーバウンダリ | E-21, E-22 | ○ |
| C-22 | 動的ルート | E-21 | ○ |
| C-23 | 並列ルート | E-21, E-22 | ○ |
| C-24 | インターセプトルート | E-21 | ○ |
| C-25 | ルートグループ | E-21 | ○ |
| C-26 | Route Handlers | E-29 | ○ |
| C-27 | Pagesディレクトリルーティング | E-30 | ○ |
| C-28 | SSRデータフェッチ | E-21 | ○ |
| C-29 | SSGデータフェッチ | E-21 | ○ |
| C-30 | 動的パス生成 | E-21 | ○ |
| C-31 | API Routes | E-31 | ○ |
| C-32 | カスタムApp・Document・エラーページ | E-22, E-23 | ○ |
| C-33 | サーバーサイドレンダリング（SSR） | E-21 | ○ |
| C-34 | 静的サイト生成（SSG） | E-17, E-21 | ○ |
| C-35 | Incremental Static Regeneration（ISR） | E-10 | ○ |
| C-36 | ストリーミングレンダリング | E-21 | ○ |
| C-37 | Partial Prerendering（PPR） | E-16 | △ |
| C-38 | Server Components | E-16, E-21 | ○ |
| C-39 | Client Components | E-21 | ○ |
| C-40 | Server Actions | E-05, E-07 | ○ |
| C-41 | fetch拡張（データキャッシュ） | E-09 | ○ |
| C-42 | revalidatePathによるキャッシュ再検証 | E-11 | ○ |
| C-43 | revalidateTag/updateTagによるキャッシュ再検証 | E-11 | ○ |
| C-44 | use cacheディレクティブ | E-21 | △ |
| C-45 | キャッシュハンドラのカスタマイズ | E-10 | ○ |
| C-46 | クライアントサイドナビゲーション | E-14 | ○ |
| C-47 | プログラマティックナビゲーション | E-21 | ○ |
| C-48 | フォームナビゲーション | E-21 | ○ |
| C-49 | 画像最適化 | E-08 | ○ |
| C-50 | フォント最適化 | E-21 | ○ |
| C-51 | スクリプト最適化 | E-21 | ○ |
| C-52 | 動的インポート | E-21 | ○ |
| C-53 | リクエスト前処理（Middleware） | E-04, E-21 | ○ |
| C-54 | リクエスト・レスポンス拡張 | E-27, E-28 | ○ |
| C-55 | リクエストヘッダー・Cookie操作 | E-21 | ○ |
| C-56 | ドラフトモード | E-21 | ○ |
| C-57 | レスポンス後処理（after） | E-15 | ○ |
| C-58 | メタデータ管理 | E-12 | ○ |
| C-59 | OGP画像動的生成 | E-21 | ○ |
| C-60 | プロジェクト設定管理 | E-13 | ○ |
| C-61 | 環境変数管理 | E-21 | ○ |
| C-62 | カスタムルート定義 | E-04, E-21 | ○ |
| C-63 | 国際化対応 | E-20 | ○ |
| C-64 | CSRF保護 | E-06 | ○ |
| C-65 | Server Actions暗号化 | E-07 | ○ |
| C-66 | Subresource Integrity | E-17, E-21 | ○ |
| C-67 | クロスサイトアクセスブロック | E-25 | ○ |
| C-68 | プライベートIPチェック | E-26 | ○ |
| C-69 | 404ページ表示 | E-22, E-23 | ○ |
| C-70 | 500エラーページ表示 | E-22, E-23 | ○ |
| C-71 | 認証・認可エラー表示 | E-22 | ○ |
| C-72 | ビルドエラー表示 | E-22, E-23 | ○ |
| C-73 | ランタイムエラー表示 | E-22, E-23 | ○ |
| C-74 | DevToolsインジケーター・メニュー | E-22, E-23 | ○ |
| C-75 | セグメントエクスプローラー | E-22, E-23 | ○ |
| C-76 | TypeScriptサポート | E-21 | ○ |
| C-77 | ESLintプラグイン | E-21 | ○ |
| C-78 | コードマイグレーション | E-21 | ○ |
| C-79 | 環境情報確認 | E-21 | ○ |
| C-80 | スタンドアロン出力 | E-21 | ○ |
| C-81 | 静的エクスポート | E-18 | ○ |
| C-82 | マルチゾーン統合 | E-21 | △ |
| C-83 | テレメトリ収集 | E-01, E-21 | ○ |
| C-84 | Web Vitals計測 | E-21 | ○ |
| C-85 | Instrumentation | E-21 | ○ |
| C-86 | OpenTelemetryトレース | E-21 | ○ |
| C-87 | Google Analytics統合 | E-21 | ○ |
| C-88 | Google Tag Manager統合 | E-21 | ○ |
| C-89 | YouTube・Google Maps埋め込み | E-21 | ○ |
| C-90 | Edge Runtimeでの実行 | E-04, E-21 | ○ |
| C-91 | テストAPI | E-21 | △ |
| C-92 | MCPサーバー統合 | E-13, E-21 | △ |
| C-93 | バンドル分析 | E-21 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-37 Partial Prerendering（PPR）**：実験的機能であり、`src/server/lib/experimental/ppr.ts` の存在を機能一覧から確認したが、実際のソースコード内の詳細な仕様・制約条件の直接確認は限定的
  - 候補：Next.js公式ドキュメント / RFCドキュメント / テストケース
- **C-44 use cacheディレクティブ**：実験的機能であり、`src/server/use-cache/` 配下のソースの詳細確認は限定的
  - 候補：Next.js公式ドキュメント / RFCドキュメント / テストケース
- **C-82 マルチゾーン統合**：basePath・rewritesの組み合わせで間接的に実現される機能であり、専用の実装モジュールが存在しない
  - 候補：Next.js公式ドキュメント / example/multi-zones / テストケース
- **C-91 テストAPI**：`src/experimental/testing/` 配下の実験的APIであり、安定性・スコープの詳細確認が必要
  - 候補：Next.js公式ドキュメント / テストケース
- **C-92 MCPサーバー統合**：`src/server/mcp/` の存在をconfig.tsのインポートから確認したが、提供ツールの網羅的確認は限定的
  - 候補：MCP仕様書 / src/server/mcp/配下の詳細ソース

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: 実験的機能（PPR、use cache、Testing API）は将来のバージョンでAPI変更・削除の可能性があり、業務要件としての安定性に注意が必要
- **0（低リスク）**: CLIコマンド、ルーティング、レンダリング、キャッシュ等の安定機能は豊富なソースコード根拠があり信頼度が高い
- **0（低リスク）**: セキュリティ関連機能（CSRF、暗号化、SRI等）はソースコードを直接確認し、実装の存在を確認済み
- **1（中リスク）**: 本プロジェクトはフレームワークであるため、「業務要件」は開発者向けの機能提供要件として解釈。エンドユーザー向けアプリケーションの業務要件とは性質が異なる

## 6) レビュアーチェックリスト（最小）
- [ ] 実験的機能（PPR、use cache、Testing API）の業務要件記載が、現時点のAPIの実態と一致しているか
- [ ] アクターの分類（開発者/エンドユーザー/運用者）が各業務要件の性質に適合しているか
- [ ] 関連画面・関連機能の参照番号が画面一覧.csv・機能一覧.csvの実際の内容と整合しているか
- [ ] フレームワーク固有の業務要件（ルーティング、レンダリング等）がアプリケーション開発者の視点で理解しやすい記述になっているか
- [ ] セキュリティ関連の業務要件（CSRF、暗号化、SRI等）の記述が、実装の制約条件を正確に反映しているか
- [ ] マルチゾーン統合やEdge Runtimeなど、インフラ依存の機能の業務要件に環境制約が適切に記載されているか
