---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 112
  claims_without_evidence: 8
confidence_derived: 0.93
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：112 / 120、根拠なし：8
- 優先レビュー（高）
  1. **C-63 コード分割**：自動的に行われる機能のため、単独のソースファイルで根拠を示しにくい
  2. **C-64 ツリーシェイキング**：バンドラ依存の機能であり、Next.js固有の実装ファイルが存在しない
  3. **C-76 draftMode()**：APIとしての存在は確認できるが、専用の実装ファイルの特定が困難
  4. **C-105 Subresource Integrity**：ビルドプラグインとして実装されるが、詳細な実装箇所の確認が不完全
  5. **C-116 スタンドアロン出力**：next.config.jsの設定項目であり、専用モジュールの特定が困難
  6. **C-118 マルチゾーン**：設定ベースの機能であり、専用の実装コードが分散している

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/cli/next-dev.ts` - CLIエントリポイント（dev）
- E-02: `packages/next/src/cli/next-build.ts` - CLIエントリポイント（build）
- E-03: `packages/next/src/cli/next-start.ts` - CLIエントリポイント（start）
- E-04: `packages/next/src/cli/next-export.ts` - CLIエントリポイント（export）
- E-05: `packages/next/src/cli/next-info.ts` - CLIエントリポイント（info）
- E-06: `packages/next/src/cli/next-telemetry.ts` - CLIエントリポイント（telemetry）
- E-07: `packages/next/src/cli/next-test.ts` - CLIエントリポイント（test）
- E-08: `packages/next/src/cli/next-typegen.ts` - CLIエントリポイント（typegen）
- E-09: `packages/next/src/cli/next-upgrade.ts` - CLIエントリポイント（upgrade）
- E-10: `packages/next/src/cli/next-analyze.ts` - CLIエントリポイント（analyze）
- E-11: `packages/create-next-app/` - create-next-appパッケージ
- E-12: `packages/next/src/server/app-render/` - App Renderモジュール
- E-13: `packages/next/src/server/app-render/action-handler.ts` - Server Actionsハンドラ
- E-14: `packages/next/src/server/route-modules/app-route/` - App Route モジュール
- E-15: `packages/next/src/server/route-modules/app-page/` - App Page モジュール
- E-16: `packages/next/src/server/route-modules/pages/` - Pages Routerモジュール
- E-17: `packages/next/src/server/route-modules/pages-api/` - Pages API Routerモジュール
- E-18: `packages/next/src/lib/metadata/` - Metadata API実装
- E-19: `packages/next/src/lib/generate-interception-routes-rewrites.ts` - インターセプトルート
- E-20: `packages/next/src/server/render.tsx` - SSRレンダリング
- E-21: `packages/next/src/build/static-paths/` - 静的パス生成（SSG）
- E-22: `packages/next/src/server/lib/incremental-cache/` - ISR用インクリメンタルキャッシュ
- E-23: `packages/next/src/server/stream-utils/` - ストリーミングレンダリング
- E-24: `packages/next/src/server/lib/experimental/ppr.ts` - PPR実装
- E-25: `packages/next/src/server/app-render/staged-rendering.ts` - Staged Rendering
- E-26: `packages/next/src/server/resume-data-cache/` - Resume Data Cache
- E-27: `packages/next/src/server/lib/patch-fetch.ts` - fetch拡張
- E-28: `packages/next/src/server/web/spec-extension/unstable-cache.ts` - unstable_cache
- E-29: `packages/next/src/server/web/spec-extension/unstable-no-store.ts` - unstable_noStore
- E-30: `packages/next/src/server/use-cache/` - use cacheディレクティブ
- E-31: `packages/next/src/server/use-cache/cache-life.ts` - cacheLife API
- E-32: `packages/next/src/server/use-cache/cache-tag.ts` - cacheTag API
- E-33: `packages/next/src/server/response-cache/` - レスポンスキャッシュ
- E-34: `packages/next/src/server/web/spec-extension/revalidate.ts` - revalidatePath/revalidateTag
- E-35: `packages/next/src/server/lib/cache-handlers/` - キャッシュハンドラ
- E-36: `packages/next/src/client/link.tsx` - Linkコンポーネント
- E-37: `packages/next/src/api/navigation.ts` - ナビゲーションAPI
- E-38: `packages/next/src/api/router.ts` - Routerフック
- E-39: `packages/next/src/client/form.tsx` - Formコンポーネント
- E-40: `packages/next/src/shared/lib/segment-cache/` - セグメントキャッシュ
- E-41: `packages/next/src/client/image-component.tsx` - Imageコンポーネント
- E-42: `packages/next/src/server/image-optimizer.ts` - 画像最適化（1214行）
- E-43: `packages/font/src/` - フォント最適化パッケージ
- E-44: `packages/next/src/client/script.tsx` - Scriptコンポーネント
- E-45: `packages/next/src/shared/lib/lazy-dynamic/` - dynamic import
- E-46: `packages/next-bundle-analyzer/` - Bundle Analyzer
- E-47: `packages/next/src/server/next-server.ts` - プロダクションサーバー
- E-48: `packages/next/src/server/dev/next-dev-server.ts` - 開発サーバー
- E-49: `packages/next/src/server/lib/router-server.ts` - Router Server
- E-50: `packages/next/src/server/web/` - Edge Runtime
- E-51: `packages/next/src/server/dev/hot-reloader-turbopack.ts` - Turbopack HMR
- E-52: `packages/next/src/server/dev/hot-reloader-webpack.ts` - Webpack HMR
- E-53: `packages/next/src/server/dev/hot-reloader-rspack.ts` - Rspack HMR
- E-54: `packages/next/src/server/dev/on-demand-entry-handler.ts` - On-Demand Entry
- E-55: `packages/next/src/server/web/spec-extension/request.ts` - NextRequest
- E-56: `packages/next/src/server/web/spec-extension/response.ts` - NextResponse
- E-57: `packages/next/src/api/headers.ts` - headers() API
- E-58: `packages/next/src/server/web/spec-extension/cookies.ts` - cookies() API
- E-59: `packages/next/src/server/after/` - after() API
- E-60: `packages/next/src/server/web/spec-extension/user-agent.ts` - userAgent()
- E-61: `packages/next/src/server/web/next-url.ts` - NextURL
- E-62: `packages/next/src/server/web/spec-extension/url-pattern.ts` - URLPattern
- E-63: `packages/next/src/server/config.ts` - 設定読み込み
- E-64: `packages/next/src/server/config-shared.ts` - 設定型定義
- E-65: `packages/next/src/build/next-config-ts/` - TypeScript設定サポート
- E-66: `packages/next/src/lib/static-env.ts` - 環境変数
- E-67: `packages/next/src/lib/load-custom-routes.ts` - カスタムルート
- E-68: `packages/next/src/shared/lib/i18n/` - i18nモジュール
- E-69: `packages/next/src/build/webpack-config.ts` - Webpack設定
- E-70: `turbopack/` - Turbopackバンドラ
- E-71: `packages/next-rspack/` - Rspack統合
- E-72: `packages/next-swc/` - SWCバインディング
- E-73: `packages/next/src/build/swc/` - SWCビルドモジュール
- E-74: `packages/next/src/build/analysis/` - ビルド解析
- E-75: `packages/next/src/build/segment-config/` - セグメント設定
- E-76: `packages/next/src/build/collect-build-traces.ts` - ビルドトレース
- E-77: `packages/next/src/build/manifests/` - マニフェスト生成
- E-78: `packages/next/src/next-devtools/` - DevTools
- E-79: `packages/next/src/next-devtools/dev-overlay/` - エラーオーバーレイ
- E-80: `packages/next/src/lib/typescript/` - TypeScriptサポート
- E-81: `packages/eslint-plugin-next/` - ESLintプラグイン
- E-82: `packages/next/src/build/jest/` - Jest統合
- E-83: `packages/next-codemod/` - Codemods
- E-84: `packages/next/src/server/mcp/` - MCPサーバー
- E-85: `packages/next/src/server/dev/log-requests.ts` - リクエストログ
- E-86: `packages/next/src/server/og/image-response.ts` - OG画像生成
- E-87: `packages/next/src/server/app-render/csrf-protection.ts` - CSRF保護
- E-88: `packages/next/src/server/app-render/encryption.ts` - Server Actions暗号化
- E-89: `packages/next/src/server/lib/router-utils/block-cross-site.ts` - クロスサイトブロック
- E-90: `packages/next/src/server/is-private-ip.ts` - プライベートIPチェック
- E-91: `packages/next/src/telemetry/` - テレメトリ
- E-92: `packages/next/src/client/web-vitals.ts` - Web Vitals
- E-93: `packages/next/src/server/instrumentation/` - Instrumentation
- E-94: `packages/next/src/trace/` - トレーシング
- E-95: `packages/third-parties/` - サードパーティ統合
- E-96: `packages/next/src/export/` - 静的エクスポート
- E-97: `packages/next/src/experimental/testing/` - Testing API
- E-98: `packages/next/src/experimental/testmode/` - Test Mode
- E-99: `packages/next/src/pages/_app.tsx` - カスタムApp
- E-100: `packages/next/src/pages/_document.tsx` - カスタムDocument
- E-101: `packages/next/src/pages/_error.tsx` - カスタムエラーページ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | next dev - 開発サーバー起動コマンド | E-01 | ○ |
| C-02 | next build - プロダクション用ビルド実行コマンド | E-02 | ○ |
| C-03 | next start - プロダクションサーバー起動コマンド | E-03 | ○ |
| C-04 | next export - 静的HTMLエクスポートコマンド | E-04 | ○ |
| C-05 | next info - 環境情報表示コマンド | E-05 | ○ |
| C-06 | next lint - ESLintによるコード品質チェック | E-81 | ○ |
| C-07 | next telemetry - テレメトリ有効/無効切替 | E-06 | ○ |
| C-08 | next test - テスト実行コマンド | E-07 | ○ |
| C-09 | next typegen - TypeScript型定義自動生成 | E-08 | ○ |
| C-10 | next upgrade - バージョンアップグレード | E-09 | ○ |
| C-11 | next analyze - バンドル分析コマンド | E-10 | ○ |
| C-12 | create-next-app - プロジェクトスキャフォールディング | E-11 | ○ |
| C-13 | App Router - ファイルシステムベースルーティング | E-12, E-15 | ○ |
| C-14 | レイアウト（Layouts） | E-12 | ○ |
| C-15 | ローディングUI | E-12 | ○ |
| C-16 | エラーハンドリング | E-12 | ○ |
| C-17 | Server Components | E-12 | ○ |
| C-18 | Client Components | E-12 | ○ |
| C-19 | Server Actions | E-13 | ○ |
| C-20 | 並列ルート（Parallel Routes） | E-12 | ○ |
| C-21 | インターセプトルート（Intercepting Routes） | E-19 | ○ |
| C-22 | Route Groups | E-12 | ○ |
| C-23 | Route Handlers | E-14 | ○ |
| C-24 | Dynamic Routes | E-12 | ○ |
| C-25 | Metadata API | E-18 | ○ |
| C-26 | Pages Router | E-16 | ○ |
| C-27 | getServerSideProps | E-16, E-20 | ○ |
| C-28 | getStaticProps | E-16, E-21 | ○ |
| C-29 | getStaticPaths | E-21 | ○ |
| C-30 | API Routes（pages/api） | E-17 | ○ |
| C-31 | カスタムApp | E-99 | ○ |
| C-32 | カスタムDocument | E-100 | ○ |
| C-33 | カスタムエラーページ | E-101 | ○ |
| C-34 | SSR | E-20 | ○ |
| C-35 | SSG | E-21 | ○ |
| C-36 | ISR | E-22 | ○ |
| C-37 | ストリーミングレンダリング | E-23 | ○ |
| C-38 | Partial Prerendering（PPR） | E-24 | ○ |
| C-39 | Staged Rendering | E-25 | ○ |
| C-40 | Resume Data Cache | E-26 | ○ |
| C-41 | fetch拡張（データキャッシュ） | E-27 | ○ |
| C-42 | unstable_cache | E-28 | ○ |
| C-43 | unstable_noStore | E-29 | ○ |
| C-44 | use cache | E-30 | ○ |
| C-45 | cacheLife | E-31 | ○ |
| C-46 | cacheTag | E-32 | ○ |
| C-47 | レスポンスキャッシュ | E-33 | ○ |
| C-48 | revalidatePath | E-34 | ○ |
| C-49 | revalidateTag | E-34 | ○ |
| C-50 | キャッシュハンドラ | E-35 | ○ |
| C-51 | next/link（Link） | E-36 | ○ |
| C-52 | next/navigation | E-37 | ○ |
| C-53 | next/router | E-38 | ○ |
| C-54 | next/form（Form） | E-39 | ○ |
| C-55 | redirect / permanentRedirect | E-12 | ○ |
| C-56 | Segment Cache | E-40 | ○ |
| C-57 | next/image（Image） | E-41 | ○ |
| C-58 | Image Optimizer | E-42 | ○ |
| C-59 | next/font | E-43 | ○ |
| C-60 | next/script（Script） | E-44 | ○ |
| C-61 | next/dynamic | E-45 | ○ |
| C-62 | Bundle Analyzer | E-46 | ○ |
| C-63 | コード分割 | **根拠なし** | △ |
| C-64 | ツリーシェイキング | **根拠なし** | △ |
| C-65 | Node.jsサーバー | E-47 | ○ |
| C-66 | 開発サーバー | E-48 | ○ |
| C-67 | Router Server | E-49 | ○ |
| C-68 | Edge Runtime | E-50 | ○ |
| C-69 | Hot Module Replacement | E-51, E-52, E-53 | ○ |
| C-70 | On-Demand Entry Handler | E-54 | ○ |
| C-71 | Middleware | E-50, E-55, E-56 | ○ |
| C-72 | NextRequest | E-55 | ○ |
| C-73 | NextResponse | E-56 | ○ |
| C-74 | headers() | E-57 | ○ |
| C-75 | cookies() | E-58 | ○ |
| C-76 | draftMode() | **根拠なし** | △ |
| C-77 | after() | E-59 | ○ |
| C-78 | userAgent() | E-60 | ○ |
| C-79 | NextURL | E-61 | ○ |
| C-80 | URLPattern | E-62 | ○ |
| C-81 | next.config.js / next.config.ts | E-63, E-64 | ○ |
| C-82 | TypeScript設定 | E-65 | ○ |
| C-83 | 環境変数 | E-66 | ○ |
| C-84 | カスタムルート（Rewrites/Redirects/Headers） | E-67 | ○ |
| C-85 | 国際化（i18n） | E-68 | ○ |
| C-86 | Webpack統合 | E-69 | ○ |
| C-87 | Turbopack統合 | E-70 | ○ |
| C-88 | Rspack統合 | E-71 | ○ |
| C-89 | SWC（コンパイラ） | E-72, E-73 | ○ |
| C-90 | 静的解析 | E-74 | ○ |
| C-91 | Segment Config | E-75 | ○ |
| C-92 | ビルドトレース | E-76 | ○ |
| C-93 | マニフェスト生成 | E-77 | ○ |
| C-94 | DevTools（開発者ツール） | E-78 | ○ |
| C-95 | エラーオーバーレイ | E-79 | ○ |
| C-96 | TypeScriptサポート | E-80 | ○ |
| C-97 | ESLintプラグイン | E-81 | ○ |
| C-98 | Jest統合 | E-82 | ○ |
| C-99 | Codemods | E-83 | ○ |
| C-100 | MCP（Model Context Protocol）サーバー | E-84 | ○ |
| C-101 | デバッグ・ログ | E-85 | ○ |
| C-102 | next/og（ImageResponse） | E-86 | ○ |
| C-103 | CSRF保護 | E-87 | ○ |
| C-104 | Server Actions暗号化 | E-88 | ○ |
| C-105 | Subresource Integrity | **根拠なし** | △ |
| C-106 | クロスサイトアクセスブロック | E-89 | ○ |
| C-107 | プライベートIPチェック | E-90 | ○ |
| C-108 | テレメトリ | E-91 | ○ |
| C-109 | Web Vitals | E-92 | ○ |
| C-110 | Instrumentation | E-93 | ○ |
| C-111 | OpenTelemetryトレース | E-94 | ○ |
| C-112 | Google Analytics | E-95 | ○ |
| C-113 | Google Tag Manager | E-95 | ○ |
| C-114 | Google Maps | E-95 | ○ |
| C-115 | YouTube Embed | E-95 | ○ |
| C-116 | スタンドアロン出力 | **根拠なし** | △ |
| C-117 | 静的エクスポート | E-96 | ○ |
| C-118 | マルチゾーン | **根拠なし** | △ |
| C-119 | Testing API | E-97 | ○ |
| C-120 | Test Mode | E-98 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-63 コード分割**: Webpack/Turbopack/Rspackのバンドラが自動的に行う機能であり、Next.js側に専用の実装ファイルが存在しない。バンドラ設定（webpack-config.ts等）に含まれる設定として間接的に存在する。
  - 候補：`src/build/webpack-config.ts` / Turbopack内部実装 / Rspack設定
- **C-64 ツリーシェイキング**: バンドラのネイティブ機能であり、Next.js固有の実装ファイルは存在しない。
  - 候補：Webpack設定 / Turbopack設定 / Rspack設定
- **C-76 draftMode()**: Draft Modeの実装は複数ファイルに分散しており、単独の専用ファイルの特定が困難。
  - 候補：`src/server/api-utils/` / `src/client/components/` / 各レンダリングモジュール
- **C-105 Subresource Integrity**: SRIはWebpackプラグインとして実装されるが、プラグインディレクトリの詳細探索が不完全。
  - 候補：`src/build/webpack/plugins/subresource-integrity-plugin.ts`（型インポートで参照確認済み）
- **C-116 スタンドアロン出力**: `output: 'standalone'`はnext.config.jsの設定項目であり、ビルド出力ロジックに分散して実装されている。
  - 候補：`src/build/output/` / `src/build/index.ts` / サーバー設定
- **C-118 マルチゾーン**: 複数Next.jsアプリの統合はbasePath・rewritesの組み合わせで実現されるドキュメントレベルの機能であり、専用の実装コードは存在しない。
  - 候補：`src/lib/load-custom-routes.ts` / `next.config.js`のbasePath設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: CLI機能（C-01〜C-12） - ソースファイルが明確に存在し、1対1で対応
- **0（低リスク）**: ルーティング機能（C-13〜C-33） - ディレクトリ構造・モジュール構成から確認可能
- **0（低リスク）**: データ取得・キャッシュ機能（C-41〜C-50） - 専用ファイルが明確に存在
- **0（低リスク）**: コンポーネントAPI（C-51〜C-62） - 各コンポーネントファイルが直接確認可能
- **1（中リスク）**: コード分割・ツリーシェイキング（C-63, C-64） - バンドラ依存機能のため直接的な根拠が薄い
- **1（中リスク）**: セキュリティ機能（C-103〜C-107） - 一部根拠が間接的
- **1（中リスク）**: サードパーティ統合（C-112〜C-115） - packages/third-partiesの存在は確認したが個別ファイルの詳細確認は不完全
- **1（中リスク）**: デプロイ・出力（C-116〜C-118） - 設定ベースの機能のため実装が分散

## 6) レビュアーチェックリスト（最小）
- [ ] CLI機能一覧（C-01〜C-12）がsrc/cli/配下のファイルと一致しているか確認
- [ ] App Router機能（C-13〜C-25）の説明が実際のApp Router仕様と整合しているか確認
- [ ] Pages Router機能（C-26〜C-33）が現行サポート状況と一致しているか確認
- [ ] レンダリング機能（C-34〜C-40）の実験的機能（PPR等）のステータスが正しいか確認
- [ ] キャッシュ関連API（C-41〜C-50）のstable/unstable区分が正しいか確認
- [ ] 根拠なし項目（C-63, C-64, C-76, C-105, C-116, C-118）について、機能の存在自体は妥当か確認
- [ ] サードパーティ統合（C-112〜C-115）が実際のpackages/third-partiesの内容と一致しているか確認
- [ ] 実験的機能（PPR、use cache、Staged Rendering等）にその旨の注記があるか確認
