# 機能設計書 11-next analyze

## 概要

本ドキュメントは、Next.jsのバンドル分析コマンド `next analyze` の機能設計を記述する。本コマンドはTurbopackを用いてプロダクションビルドのバンドル分析を実行し、ルート情報の収集とインタラクティブな可視化UIを提供する。

### 本機能の処理概要

`next analyze` コマンドは、Next.jsアプリケーションのバンドルサイズとルート構成を分析し、開発者がパフォーマンス最適化の判断材料を得られるようにする機能である。

**業務上の目的・背景**：フロントエンドアプリケーションのパフォーマンス最適化において、バンドルサイズの把握は重要な課題である。本機能は、ビルド成果物を分析してルートごとのバンドル情報を可視化し、不要な依存関係の特定やコード分割の最適化を支援する。

**機能の利用シーン**：開発者がアプリケーションのバンドルサイズを最適化したいとき、リリース前のパフォーマンスレビュー時、CI/CDパイプラインでのバンドルサイズ監視時に利用される。

**主要な処理内容**：
1. Next.js設定ファイルの読み込みとAnalyzeフェーズの初期化
2. Turbopackによるバンドル分析の実行
3. App RouterおよびPages Routerのルート情報収集
4. 分析結果のファイル出力またはインタラクティブなHTTPサーバーでの可視化
5. テレメトリデータの記録

**関連システム・外部連携**：Turbopackバンドラとの連携、テレメトリシステムへのイベント送信。

**権限による制御**：特になし。プロジェクトディレクトリへのファイルシステムアクセス権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | バンドル分析ビューア | 結果表示画面 | HTTPサーバーで提供されるインタラクティブなバンドル分析UI |

## 機能種別

データ連携 / 分析処理 / 可視化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| experimentalAnalyze | boolean | No | 実験的分析機能の有効化 | - |
| profile | boolean | No | Reactプロダクションプロファイリングの有効化 | - |
| mangling | boolean | Yes | 変数名マングリングの有効/無効 | デフォルトtrue |
| port | number | Yes | 分析結果表示サーバーのポート番号 | デフォルト4000 |
| output | boolean | Yes | ファイル出力モード（サーバー起動しない） | - |
| experimentalAppOnly | boolean | No | App Routerのみを分析対象にする | - |
| directory | string | No | プロジェクトディレクトリパス | 存在するディレクトリであること |

### 入力データソース

- コマンドライン引数
- `next.config.js` / `next.config.ts` 設定ファイル
- プロジェクトのファイルシステム（app/、pages/ディレクトリ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| routes.json | JSON | 収集されたルート情報の一覧 |
| analyzeディレクトリ | ディレクトリ | バンドル分析UIファイルと結果データ |
| テレメトリイベント | オブジェクト | 分析完了イベント（成功/失敗、所要時間、ページ数） |

### 出力先

- `.next/diagnostics/analyze/` ディレクトリへのファイル出力
- HTTPサーバー（デフォルトポート4000）での可視化UI提供
- テレメトリシステムへのイベント送信

## 処理フロー

### 処理シーケンス

```
1. CLIエントリーポイント（next-analyze.ts）
   └─ シグナルハンドラ（SIGTERM/SIGINT）の登録、オプション検証
2. プロジェクトディレクトリの検証
   └─ 存在しない場合はエラー終了
3. analyze関数の呼び出し（build/analyze/index.ts）
   └─ Next.js設定のロード（PHASE_ANALYZE）
4. Turbopackによるバンドル分析
   └─ turbopackAnalyze()の実行と結果取得
5. ルート情報の収集
   └─ collectRoutesForAnalyze()でapp/pages両方のルートを収集
6. 分析結果の書き出し
   └─ bundle-analyzerUIファイルのコピーとroutes.jsonの生成
7. 結果の提供
   └─ outputモード: ファイル出力のみ / 通常: HTTPサーバー起動
```

### フローチャート

```mermaid
flowchart TD
    A[next analyze コマンド実行] --> B[シグナルハンドラ登録]
    B --> C{プロジェクトディレクトリ存在?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[Next.js設定ロード]
    E --> F[Turbopack分析実行]
    F --> G[ルート情報収集]
    G --> H[分析結果ファイル出力]
    H --> I{outputモード?}
    I -->|Yes| J[ファイル出力完了]
    I -->|No| K[HTTPサーバー起動]
    K --> L[ブラウザで可視化UI表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | マングリング警告 | マングリング無効時にパフォーマンス影響の警告を出力 | mangling=false |
| BR-02 | プロファイリング警告 | プロファイリング有効時にパフォーマンス影響の警告を出力 | profile=true |
| BR-03 | ディレクトリ検証 | プロジェクトディレクトリが存在しない場合はエラー終了 | 常時 |
| BR-04 | appDirOnlyフィルタ | App Routerのルートのみを分析対象にする | experimentalAppOnly=true |

### 計算ロジック

分析所要時間はミリ秒単位で計測され、durationToString関数で人間が読みやすい文字列に変換される。

## データベース操作仕様

### 操作別データベース影響一覧

該当なし。本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ディレクトリ不存在 | 指定ディレクトリが存在しない | エラーメッセージを表示して終了 |
| - | 設定読み込み失敗 | next.config.jsの読み込みエラー | スタックトレースを出力 |
| - | Turbopack分析失敗 | バンドル分析処理中のエラー | テレメトリにfailure記録、例外を再throw |
| - | サーバー起動失敗 | ポート使用中等 | サーバーエラーをreject |

### リトライ仕様

リトライは実装されていない。エラー時はプロセスを終了する。

## トランザクション仕様

該当なし。

## パフォーマンス要件

分析処理はプロジェクト規模に依存する。テレメトリには分析所要時間（秒単位）が記録される。

## セキュリティ考慮事項

- 分析結果のHTTPサーバーはlocalhostのみでリッスンする（外部アクセス不可）
- CPUプロファイルはシグナル受信時に保存される

## 備考

- `PHASE_ANALYZE` は分析専用のフェーズ定数として定義されている
- バンドル分析UIは `packages/next/src/bundle-analyzer` からコピーされる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、分析オプションとルート情報のデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | next-analyze.ts | `packages/next/src/cli/next-analyze.ts` | NextAnalyzeOptions型定義（12-19行目）で分析オプションの構造を確認 |
| 1-2 | index.ts | `packages/next/src/build/analyze/index.ts` | AnalyzeOptions型定義（33-40行目）で内部分析オプションを確認 |

**読解のコツ**: CLIオプション名と内部関数パラメータ名の対応関係に注意。`mangling` は内部では `noMangling` に反転される。

#### Step 2: エントリーポイントを理解する

CLIコマンドの起点となるファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | next-analyze.ts | `packages/next/src/cli/next-analyze.ts` | nextAnalyze関数（21-59行目）がCLIエントリーポイント |

**主要処理フロー**:
1. **22-29行目**: SIGTERM/SIGINTシグナルハンドラの登録とCPUプロファイル保存
2. **33-37行目**: マングリング無効時の警告出力
3. **45-49行目**: プロジェクトディレクトリの存在確認
4. **51-58行目**: analyze関数の呼び出し（オプション変換を含む）

#### Step 3: 分析処理の中核を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.ts | `packages/next/src/build/analyze/index.ts` | analyze関数（42-122行目）で分析処理全体の流れを把握 |

**主要処理フロー**:
- **51-55行目**: Next.js設定のロードとPHASE_ANALYZEの設定
- **74-75行目**: turbopackAnalyzeの呼び出しによるバンドル分析実行
- **82行目**: collectRoutesForAnalyzeによるルート情報収集
- **84-91行目**: 分析UIファイルのコピーとroutes.jsonの生成
- **107-109行目**: outputモードでない場合のHTTPサーバー起動

#### Step 4: ルート収集処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | index.ts | `packages/next/src/build/analyze/index.ts` | collectRoutesForAnalyze関数（128-208行目） |

**主要処理フロー**:
- **133行目**: findPagesDirでpages/appディレクトリを検出
- **148-152行目**: collectAppFiles/collectPagesFilesでファイル一覧収集
- **154-174行目**: createPagesMappingでルートマッピング生成
- **194-203行目**: generateRoutesManifestでルートマニフェスト生成
- **205-207行目**: 動的ルートと静的ルートのページパスを結合して返却

### プログラム呼び出し階層図

```
nextAnalyze (cli/next-analyze.ts)
    |
    +-- getProjectDir (lib/get-project-dir.ts)
    |
    +-- analyze (build/analyze/index.ts)
           |
           +-- loadConfig (server/config.ts)
           |
           +-- turbopackAnalyze (build/turbopack-analyze.ts)
           |
           +-- collectRoutesForAnalyze
           |      |
           |      +-- findPagesDir (lib/find-pages-dir.ts)
           |      +-- collectAppFiles (build/entries.ts)
           |      +-- collectPagesFiles (build/entries.ts)
           |      +-- createPagesMapping (build/entries.ts)
           |      +-- loadCustomRoutes (lib/load-custom-routes.ts)
           |      +-- generateRoutesManifest (build/generate-routes-manifest.ts)
           |
           +-- startServer (HTTPサーバー起動)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CLIオプション ---------> nextAnalyze -------+
                                            |
next.config.js --------> loadConfig --------+
                                            |
app/ ディレクトリ -----> collectAppFiles ----+---> turbopackAnalyze --> .next/diagnostics/analyze/
                                            |                              |
pages/ ディレクトリ ---> collectPagesFiles --+                              +-> routes.json
                                                                           |
                                                                           +-> HTTPサーバー (localhost:4000)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| next-analyze.ts | `packages/next/src/cli/next-analyze.ts` | ソース | CLIエントリーポイント |
| index.ts | `packages/next/src/build/analyze/index.ts` | ソース | 分析処理の中核 |
| turbopack-analyze.ts | `packages/next/src/build/turbopack-analyze.ts` | ソース | Turbopackバンドル分析 |
| entries.ts | `packages/next/src/build/entries.ts` | ソース | ルートファイル収集 |
| generate-routes-manifest.ts | `packages/next/src/build/generate-routes-manifest.ts` | ソース | ルートマニフェスト生成 |
| config.ts | `packages/next/src/server/config.ts` | ソース | Next.js設定読み込み |
| find-pages-dir.ts | `packages/next/src/lib/find-pages-dir.ts` | ソース | pages/appディレクトリ検出 |
| cpu-profile.ts | `packages/next/src/server/lib/cpu-profile.ts` | ソース | CPUプロファイル保存 |
| bundle-analyzer | `packages/next/src/bundle-analyzer/` | 静的ファイル | 分析結果可視化UI |
