# 機能設計書 114-Google Maps

## 概要

本ドキュメントは、Next.jsの`@next/third-parties`パッケージが提供するGoogle Maps Embedの最適化された統合コンポーネントの設計を記載する。GoogleMapsEmbedコンポーネントにより、Google Maps Embed APIのiframe生成を`third-party-capital`ライブラリとThirdPartyScriptEmbedを通じて最適化する。

### 本機能の処理概要

**業務上の目的・背景**：Google Mapsの埋め込みは店舗・施設案内、物件情報、イベント会場表示など多くのビジネスシーンで利用される。Next.jsアプリケーションに地図を最適に埋め込むため、パフォーマンスを考慮したコンポーネントが必要である。本機能は`third-party-capital`ライブラリを活用し、Google Maps Embed APIのHTML生成を標準化する。

**機能の利用シーン**：Webサイトに場所・地図情報を表示する場面、ストリートビューを埋め込む場面、地図上でルート検索結果を表示する場面で利用される。

**主要な処理内容**：
1. propsからGoogle Maps Embed APIのパラメータを構築（apiKeyの変換）
2. `third-party-capital`のGoogleMapsEmbed関数でHTML生成
3. ThirdPartyScriptEmbedコンポーネントでiframeを最適にDOM挿入
4. Chrome Auroraチームへの機能利用シグナル送信

**関連システム・外部連携**：Google Maps Embed API（`https://www.google.com/maps/embed/v1/`）と連携する。

**権限による制御**：Google Maps APIキー（apiKey）が必須。APIキーの権限設定はGoogle Cloud Console側で管理される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 任意のページ | 主機能 | GoogleMapsEmbedコンポーネントの配置による地図表示 |

## 機能種別

外部サービス統合・UI表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| apiKey | string | Yes | Google Maps APIキー | 空文字でないこと |
| mode | 'place' \| 'view' \| 'directions' \| 'streetview' \| 'search' | Yes | 地図表示モード | 指定値のいずれか |
| height | number \| string | No | iframe高さ | - |
| width | number \| string | No | iframe幅 | - |
| style | string | No | CSSスタイル | - |
| allowfullscreen | boolean | No | フルスクリーン許可 | - |
| loading | 'eager' \| 'lazy' | No | 読み込み戦略 | - |
| q | string | No | 検索クエリ（place/search mode） | - |
| id | string | No | 場所ID | - |
| center | string | No | 地図の中心座標 | - |
| zoom | string | No | ズームレベル | - |
| maptype | string | No | 地図種類 | - |
| language | string | No | 表示言語 | - |
| region | string | No | 地域コード | - |

### 入力データソース

- コンポーネントのprops（JSX属性として指定）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| html | string | Google Maps Embed APIのiframe HTML |

### 出力先

- DOM（ブラウザ上のdiv要素内にdangerouslySetInnerHTMLで挿入）

## 処理フロー

### 処理シーケンス

```
1. propsの変換
   └─ apiKeyをkeyプロパティに変換、残りのpropsをそのまま渡す
2. HTML生成
   └─ third-party-capitalのGoogleMapsEmbed関数でiframe HTML生成
3. DOM挿入
   └─ ThirdPartyScriptEmbedでheight/width指定のdivにHTML挿入
4. 機能利用シグナル送信
   └─ ThirdPartyScriptEmbed内のuseEffectでperformance.mark
```

### フローチャート

```mermaid
flowchart TD
    A[GoogleMapsEmbed マウント] --> B[apiKey -> key変換]
    B --> C[TPCGoogleMapEmbed関数呼び出し]
    C --> D[HTML文字列生成]
    D --> E[ThirdPartyScriptEmbed]
    E --> F[div要素にiframe挿入]
    E --> G[performance.mark送信]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | APIキー変換 | propsのapiKeyはthird-party-capitalに渡す際にkeyプロパティに変換される | 常時 |
| BR-02 | デフォルトサイズ | height/widthが未指定の場合、nullが渡されThirdPartyScriptEmbedでauto設定 | サイズ未指定時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | APIキー無効 | 無効なAPIキーでGoogle Maps API呼び出し | iframe内にGoogleエラーメッセージ表示 |

### リトライ仕様

リトライ機能は実装されていない。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- ThirdPartyScriptEmbedによる最適化されたiframe挿入
- loading='lazy'オプションによる遅延読み込みサポート

## セキュリティ考慮事項

- APIキーはiframeのsrc URLに含まれるため、クライアントサイドで公開される
- dangerouslySetInnerHTMLを使用（third-party-capitalが生成したHTMLのみ）
- APIキーの使用制限はGoogle Cloud Console側で設定推奨

## 備考

- Server Componentとして動作可能（'use client'ディレクティブなし）
- third-party-capitalライブラリがHTMLの標準的な生成を担当
- data-ntpc="GoogleMapsEmbed"属性がパフォーマンス計測に使用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | google.ts | `packages/third-parties/src/types/google.ts` | GoogleMapsEmbed型の定義（mode, apiKey, 地図パラメータ） |

**読解のコツ**: GoogleMapsEmbed型の`mode`フィールドがUnion型リテラルで5つの表示モードを定義している。

#### Step 2: メインコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | google-maps-embed.tsx | `packages/third-parties/src/google/google-maps-embed.tsx` | GoogleMapsEmbedコンポーネントの実装 |

**主要処理フロー**:
- **1行目**: third-party-capitalからTPCGoogleMapEmbedをインポート
- **6-19行目**: GoogleMapsEmbedコンポーネント全体
- **7行目**: apiKeyをkeyに変換（destructuring + rename）
- **9行目**: TPCGoogleMapEmbed関数でHTML生成
- **12-18行目**: ThirdPartyScriptEmbedでDOM挿入

#### Step 3: 共通埋め込みコンポーネントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ThirdPartyScriptEmbed.tsx | `packages/third-parties/src/ThirdPartyScriptEmbed.tsx` | 共通の埋め込みコンポーネント（div + dangerouslySetInnerHTML） |

**主要処理フロー**:
- **1行目**: `'use client'`ディレクティブ
- **13-50行目**: ThirdPartyScriptEmbedコンポーネント（height/width計算、HTML挿入、performance.mark）
- **20-31行目**: useEffectでperformance.mark（dataNtpcに基づく機能利用シグナル）

### プログラム呼び出し階層図

```
GoogleMapsEmbed (React Component)
    |
    +-- TPCGoogleMapEmbed (third-party-capital)
    |       +-- iframeのHTML文字列を生成
    |
    +-- ThirdPartyScriptEmbed
            +-- div (dangerouslySetInnerHTML)
            +-- useEffect -> performance.mark
```

### データフロー図

```
[入力]                        [処理]                           [出力]

apiKey + mode + params ----> TPCGoogleMapEmbed() -----> HTML文字列
                                                            |
height / width -----------> ThirdPartyScriptEmbed --> div要素 (iframe埋め込み)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| google-maps-embed.tsx | `packages/third-parties/src/google/google-maps-embed.tsx` | ソース | GoogleMapsEmbedコンポーネント |
| ThirdPartyScriptEmbed.tsx | `packages/third-parties/src/ThirdPartyScriptEmbed.tsx` | ソース | 共通のサードパーティ埋め込みコンポーネント |
| google.ts | `packages/third-parties/src/types/google.ts` | ソース | GoogleMapsEmbed型定義 |
| index.tsx | `packages/third-parties/src/google/index.tsx` | ソース | パッケージエクスポート |
