# 機能設計書 116-スタンドアロン出力

## 概要

本ドキュメントは、Next.jsの`output: 'standalone'`設定による最小限のNode.jsサーバー出力機能の設計を記載する。プロダクションビルド時に、アプリケーション実行に必要な最小限のファイルのみを`standalone`ディレクトリに出力し、コンテナデプロイに最適化された自己完結型のサーバーを生成する。

### 本機能の処理概要

**業務上の目的・背景**：Docker等のコンテナ環境にNext.jsアプリケーションをデプロイする場合、node_modules全体をコピーするとイメージサイズが肥大化する。本機能は`@vercel/nft`（Node File Trace）を使用して依存関係を解析し、実行に必要なファイルのみを出力することで、デプロイサイズを大幅に削減する。これにより、コンテナイメージの軽量化とデプロイ速度の向上を実現する。

**機能の利用シーン**：Dockerコンテナへのデプロイ時、Kubernetes環境へのデプロイ時、サーバーレス環境でのデプロイサイズ最適化時に利用される。

**主要な処理内容**：
1. `next.config.js`で`output: 'standalone'`を設定
2. ビルド時に`@vercel/nft`でファイル依存関係をトレース
3. トレース結果に基づき必要なファイルを`standalone`ディレクトリにコピー
4. 自己完結型の`server.js`エントリーポイントを生成
5. node_modulesの必要部分のみをコピー

**関連システム・外部連携**：`@vercel/nft`（Node File Trace）ライブラリ、Node.jsランタイムと連携する。

**権限による制御**：特に権限制御はない。next.config.jsの設定で有効化される。

## 関連画面

本機能はビルド時の出力設定であり、直接関連する画面は存在しない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | `next build`実行時にスタンドアロン出力を生成 |

## 機能種別

ビルド出力・デプロイ最適化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| output | 'standalone' | Yes | next.config.jsのoutput設定 | 'standalone'文字列 |
| outputFileTracingRoot | string | No | ファイルトレースのルートディレクトリ | 有効なパス |
| outputFileTracingIncludes | Record<string, string[]> | No | トレースに追加するファイルパターン | - |
| outputFileTracingExcludes | Record<string, string[]> | No | トレースから除外するファイルパターン | - |

### 入力データソース

- next.config.js / next.config.ts（設定ファイル）
- ビルド成果物（`.next`ディレクトリ）
- プロジェクトのソースコードとnode_modules

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| standalone/ | ディレクトリ | 自己完結型サーバー出力 |
| standalone/server.js | ファイル | サーバーエントリーポイント |
| standalone/.next/ | ディレクトリ | ビルド成果物（必要分のみ） |
| standalone/node_modules/ | ディレクトリ | 必要な依存パッケージのみ |
| standalone/package.json | ファイル | パッケージ情報 |

### 出力先

- `{distDir}/../standalone/`ディレクトリ

## 処理フロー

### 処理シーケンス

```
1. next.config.jsの読み込み
   └─ output: 'standalone'の確認
2. ビルドプロセスの実行
   └─ 通常のnext buildプロセスを完了
3. ビルドトレースの収集
   └─ @vercel/nftによるファイル依存関係の解析
4. スタンドアロンディレクトリの生成
   └─ writeStandaloneDirectory関数の実行
5. トレースファイルのコピー
   └─ copyTracedFiles関数で必要なファイルのみを出力先にコピー
6. server.jsの生成
   └─ 最小限のNode.jsサーバーエントリーポイントを出力
```

### フローチャート

```mermaid
flowchart TD
    A[next build開始] --> B{output === 'standalone'?}
    B -->|No| C[通常ビルド完了]
    B -->|Yes| D[通常ビルド実行]
    D --> E[ビルドトレース収集]
    E --> F["@vercel/nft ファイル依存解析"]
    F --> G[writeStandaloneDirectory]
    G --> H[copyTracedFiles]
    H --> I[server.js生成]
    I --> J[standaloneディレクトリ完成]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ビルド完了後実行 | スタンドアロン出力はアダプタ処理の後、ビルドの最終段階で実行される | output === 'standalone'時 |
| BR-02 | 静的ファイル除外 | public/や.next/static/は手動でコピーする必要がある | standalone出力時 |
| BR-03 | トレース除外パターン | TRACE_IGNORESで定義されたパターンに一致するファイルはトレースから除外 | ファイルトレース時 |
| BR-04 | モノレポ対応 | outputFileTracingRootでモノレポのルートを指定可能 | モノレポ環境 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベースを使用しない。

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | トレース失敗 | @vercel/nftの依存解析に失敗 | ビルドエラーとして報告 |
| - | ファイルコピー失敗 | ディスク容量不足やパーミッションエラー | ビルドエラーとして報告 |

### リトライ仕様

リトライ機能は実装されていない。ビルドの再実行が必要。

## トランザクション仕様

ファイルシステム操作のため、トランザクション管理は不要。ビルド失敗時は出力ディレクトリが不完全な状態となる可能性がある。

## パフォーマンス要件

- @vercel/nftによる効率的なファイル依存解析
- トレースイベント`output-standalone`によるパフォーマンス計測
- 出力サイズの最小化（不要なnode_modulesの除外）

## セキュリティ考慮事項

- `.env`ファイル等の機密情報がトレースに含まれないよう注意が必要
- standalone出力にはサーバーサイドの全コードが含まれるため、アクセス制御が重要

## 備考

- standalone出力後、staticファイル（public/、.next/static/）は手動でコピーする必要がある
- `node server.js`コマンドで直接サーバーを起動可能
- Dockerfileでの利用例が公式ドキュメントに記載されている
- アダプタ（`experimental.adapterPath`）との併用時の動作順序に注意

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 設定の理解

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config-shared.ts | `packages/next/src/server/config-shared.ts` | output設定の型定義と'standalone'オプション |

**読解のコツ**: NextConfig型のoutputフィールドが'standalone' | 'export' | undefinedの型を持つ。

#### Step 2: ビルドプロセスでの呼び出しを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.ts | `packages/next/src/build/index.ts` | ビルドプロセスの最終段階でのstandalone出力呼び出し |

**主要処理フロー**:
- **687行目**: `STANDALONE_DIRECTORY`定数の定義（'standalone'）
- **688行目**: `writeStandaloneDirectory`関数の定義
- **4259行目**: `config.output === 'standalone'`の条件チェック
- **4261行目**: `output-standalone`トレーススパンの開始
- **4263行目**: `writeStandaloneDirectory`の呼び出し

#### Step 3: ビルドトレースの収集を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | collect-build-traces.ts | `packages/next/src/build/collect-build-traces.ts` | @vercel/nftによるファイル依存解析とトレース収集 |

**主要処理フロー**:
- **1-3行目**: Spanインポートとプロファイリング
- **19行目**: nodeFileTrace関数のインポート
- **28-42行目**: makeIgnoreFn関数（トレース除外パターン）
- **44-50行目**: shouldIgnore関数（ファイルごとの除外判定）

### プログラム呼び出し階層図

```
next build (build/index.ts)
    |
    +-- 通常ビルドプロセス
    |
    +-- collect-build-traces
    |       +-- nodeFileTrace (@vercel/nft)
    |       +-- makeIgnoreFn (除外パターン)
    |       +-- shouldIgnore (ファイル判定)
    |
    +-- writeStandaloneDirectory (config.output === 'standalone'の場合)
            +-- copyTracedFiles
                    +-- トレース結果に基づくファイルコピー
                    +-- server.js生成
```

### データフロー図

```
[入力]                         [処理]                          [出力]

next.config.js -----------> ビルドプロセス -------> .next/ (ビルド成果物)
  output: 'standalone'          |
                                v
ソースコード + -----------> @vercel/nft ---------> トレース結果
node_modules                    |                  (依存ファイル一覧)
                                v
                          writeStandaloneDirectory
                                |
                                v
                          copyTracedFiles -------> standalone/
                                                     +-- server.js
                                                     +-- .next/
                                                     +-- node_modules/ (最小)
                                                     +-- package.json
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.ts | `packages/next/src/build/index.ts` | ソース | ビルドメイン処理・standalone出力呼び出し |
| collect-build-traces.ts | `packages/next/src/build/collect-build-traces.ts` | ソース | @vercel/nftによるファイル依存トレース |
| config-shared.ts | `packages/next/src/server/config-shared.ts` | ソース | output設定の型定義 |
| config.ts | `packages/next/src/server/config.ts` | ソース | 設定の読み込みとバリデーション |
| utils.ts | `packages/next/src/build/utils.ts` | ソース | ビルドユーティリティ |
