# 機能設計書 12-create-next-app

## 概要

本ドキュメントは、Next.jsプロジェクトのスキャフォールディングツール `create-next-app` の機能設計を記述する。テンプレートベースで新規プロジェクトを作成し、TypeScript、Tailwind CSS、ESLint/Biome、App Router等の初期設定を対話的に構成できるCLIツールである。

### 本機能の処理概要

`create-next-app` は、Next.jsアプリケーションの新規プロジェクトを迅速にセットアップするためのCLIツールである。

**業務上の目的・背景**：Next.jsプロジェクトの初期セットアップには多くの設定ファイルやディレクトリ構造が必要であり、手動での構築は非効率かつエラーが発生しやすい。本ツールは、ベストプラクティスに基づいたプロジェクトテンプレートを提供し、開発者が即座に開発を開始できるようにする。

**機能の利用シーン**：新規Next.jsプロジェクトの開始時、チーム全体で統一されたプロジェクト構造を確立したいとき、GitHub上のサンプルプロジェクトをベースに開発を始めたいときに利用される。

**主要な処理内容**：
1. 対話的プロンプトによるプロジェクト設定の収集（TypeScript/JavaScript、リンター、Tailwind CSS、src/ディレクトリ、App/Pages Router、インポートエイリアス等）
2. テンプレートファイルの生成またはGitHubリポジトリからのサンプルダウンロード
3. パッケージマネージャ（npm/pnpm/yarn/bun）による依存関係のインストール
4. Gitリポジトリの初期化
5. ユーザー設定の保存と再利用

**関連システム・外部連携**：GitHubリポジトリからのサンプルダウンロード、npmレジストリでのバージョン確認。

**権限による制御**：特になし。ファイルシステムへの書き込み権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ターミナルプロンプト | 主画面 | 対話的な設定入力UI |

## 機能種別

プロジェクト生成 / スキャフォールディング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| directory | string | No | プロジェクトディレクトリ名 | npm命名規則に準拠 |
| --typescript / --ts | boolean | No | TypeScriptプロジェクトとして初期化 | デフォルトtrue |
| --javascript / --js | boolean | No | JavaScriptプロジェクトとして初期化 | - |
| --tailwind | boolean | No | Tailwind CSS設定を含める | デフォルトtrue |
| --react-compiler | boolean | No | React Compilerを有効化 | - |
| --eslint | boolean | No | ESLint設定を含める | - |
| --biome | boolean | No | Biome設定を含める | - |
| --app | boolean | No | App Routerプロジェクトとして初期化 | デフォルトtrue |
| --src-dir | boolean | No | src/ディレクトリ内にコードを配置 | - |
| --turbopack | boolean | No | Turbopackをバンドラとして有効化 | - |
| --webpack | boolean | No | Webpackをバンドラとして有効化 | - |
| --rspack | boolean | No | Rspackをバンドラとして有効化 | - |
| --import-alias | string | No | インポートエイリアスのプレフィックス | パターン `<prefix>/*` に一致 |
| --api | boolean | No | ヘッドレスAPIプロジェクト | - |
| --empty | boolean | No | 空プロジェクトを生成 | - |
| --use-npm/pnpm/yarn/bun | boolean | No | パッケージマネージャの指定 | - |
| --example | string | No | サンプルプロジェクト名またはGitHub URL | - |
| --skip-install | boolean | No | パッケージインストールをスキップ | - |
| --disable-git | boolean | No | Git初期化をスキップ | - |
| --yes | boolean | No | デフォルト値または保存設定を使用 | - |
| --reset-preferences | boolean | No | 保存済み設定をリセット | - |

### 入力データソース

- コマンドライン引数
- 対話的プロンプト（prompts）
- 保存済みユーザー設定（Confライブラリ）
- CI環境検出（ci-info）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| プロジェクトディレクトリ | ディレクトリ | テンプレートに基づく新規Next.jsプロジェクト |
| package.json | JSON | プロジェクト依存関係と設定 |
| next.config.ts/js | ファイル | Next.js設定ファイル |
| tsconfig.json | JSON | TypeScript設定（TypeScript選択時） |
| .gitignore | ファイル | Git無視設定 |
| 保存設定 | Confストア | ユーザーの選択した設定（次回利用のため保存） |

### 出力先

- 指定されたプロジェクトディレクトリへのファイル出力
- Confライブラリによるユーザー設定の永続化

## 処理フロー

### 処理シーケンス

```
1. CLIオプション解析（Commander）
   └─ バージョン情報・ヘルプ・各種オプションの定義
2. パッケージマネージャ検出
   └─ CLI指定 > 環境検出の優先順で決定
3. プロジェクトパス決定
   └─ CLI引数 > 対話プロンプトで取得
4. プロジェクト名バリデーション
   └─ npm命名規則の検証
5. ディレクトリの空チェック
   └─ 既存ディレクトリの場合は空であることを確認
6. プロジェクト設定の決定
   └─ 推奨デフォルト / 保存設定の再利用 / カスタマイズの3択
7. 各設定項目のプロンプト
   └─ TypeScript, リンター, React Compiler, Tailwind CSS, src/dir, App Router, インポートエイリアス
8. createApp関数の呼び出し
   └─ テンプレート生成 or GitHub exampleダウンロード
9. 設定の保存
   └─ confに現在の選択を保存
10. アップデート通知
    └─ create-next-appの新バージョンがある場合に通知
```

### フローチャート

```mermaid
flowchart TD
    A[create-next-app 実行] --> B[CLIオプション解析]
    B --> C{--reset-preferences?}
    C -->|Yes| D[設定リセット・終了]
    C -->|No| E{プロジェクト名指定?}
    E -->|No| F[対話プロンプトで入力]
    E -->|Yes| G[バリデーション]
    F --> G
    G --> H{ディレクトリは空?}
    H -->|No| I[エラー終了]
    H -->|Yes| J{example指定?}
    J -->|Yes| K[GitHubからダウンロード]
    J -->|No| L{推奨デフォルト使用?}
    L -->|Yes| M[デフォルト設定適用]
    L -->|No| N[各項目プロンプト]
    M --> O[createApp実行]
    N --> O
    K --> O
    O --> P[設定保存]
    P --> Q[アップデート通知]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 命名規則検証 | プロジェクト名はnpm命名規則に準拠する必要がある | 常時 |
| BR-02 | 空ディレクトリ必須 | 既存ディレクトリが空でない場合はエラー | ディレクトリが存在する場合 |
| BR-03 | CI環境検出 | CI環境ではプロンプトをスキップしデフォルト値を使用 | ciInfo.isCI=true |
| BR-04 | 設定再利用 | 前回保存した設定を再利用可能 | 保存設定が存在する場合 |
| BR-05 | バンドラデフォルト | バンドラ未指定時はTurbopackをデフォルトとする | バンドラオプション未指定時 |
| BR-06 | API専用モード | --api指定時はリンター・Tailwind・App Router選択をスキップ | --api=true |

### 計算ロジック

該当なし。

## データベース操作仕様

### 操作別データベース影響一覧

該当なし。本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 命名規則違反 | プロジェクト名がnpm命名規則に違反 | エラーメッセージ表示して終了 |
| - | ディレクトリ非空 | 対象ディレクトリが空でない | エラーメッセージ表示して終了 |
| - | ダウンロードエラー | GitHubからのexampleダウンロード失敗 | デフォルトテンプレート使用を提案 |
| - | プロンプト中断 | ユーザーがCtrl+C/Ctrl+Dで中断 | プロセス終了 |

### リトライ仕様

GitHubからのダウンロードには `async-retry` ライブラリによるリトライが実装されている。

## トランザクション仕様

該当なし。ファイル生成は非トランザクション的に行われる。

## パフォーマンス要件

特になし。ネットワーク経由のダウンロードはGitHubの応答速度に依存する。

## セキュリティ考慮事項

- GitHubからのダウンロードはHTTPS経由で実行される
- ユーザー設定はConfライブラリでローカルに永続化（機密情報は含まない）

## 備考

- prerelease版（canary等）のバージョンチェックは、対応するdist-tagで行われる（getDistTag関数）
- `--yes` フラグまたはCI環境では対話プロンプトがすべてスキップされる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | templates/index.ts | `packages/create-next-app/templates/index.ts` | Bundler列挙型、TemplateMode、TemplateType型でテンプレート構造を理解 |
| 1-2 | get-pkg-manager.ts | `packages/create-next-app/helpers/get-pkg-manager.ts` | PackageManager型の定義 |

**読解のコツ**: Commander.jsのオプション定義パターンに慣れておくとindex.tsが読みやすい。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.ts | `packages/create-next-app/index.ts` | program定義（41-121行目）でCLIオプション全体像を把握 |
| 2-2 | index.ts | `packages/create-next-app/index.ts` | run関数（136-657行目）がメイン処理フロー |

**主要処理フロー**:
1. **41-121行目**: Commanderによるオプション定義とパース
2. **126-134行目**: パッケージマネージャの検出
3. **136-154行目**: 設定リセット処理
4. **160-190行目**: プロジェクト名の取得とバリデーション
5. **233-347行目**: 推奨デフォルト / 設定再利用 / カスタマイズの分岐
6. **365-590行目**: 各設定項目の対話プロンプト
7. **601-655行目**: createApp呼び出しとエラーハンドリング
8. **656行目**: 設定の保存

#### Step 3: プロジェクト生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create-app.ts | `packages/create-next-app/create-app.ts` | createApp関数でテンプレート生成とexampleダウンロードの分岐を理解 |

**主要処理フロー**:
- **27-63行目**: createApp関数のパラメータ定義
- **66行目**: テンプレート名の決定（app/default + tailwind + empty の組み合わせ）
- **68-80行目**: example指定時のGitHub URLパース

### プログラム呼び出し階層図

```
index.ts (エントリーポイント)
    |
    +-- program.parse() (CLIオプション解析)
    |
    +-- run()
    |      |
    |      +-- prompts() (各種対話プロンプト)
    |      |
    |      +-- createApp() (create-app.ts)
    |             |
    |             +-- downloadAndExtractExample() (example指定時)
    |             |   OR
    |             +-- installTemplate() (テンプレート生成時)
    |             |
    |             +-- install() (パッケージインストール)
    |             |
    |             +-- tryGitInit() (Git初期化)
    |             |
    |             +-- runTypegen() (型定義生成)
    |
    +-- notifyUpdate() (バージョン更新通知)
```

### データフロー図

```
[入力]                       [処理]                    [出力]

CLIオプション ---------> program.parse() ----+
                                             |
対話プロンプト --------> prompts() ----------+---> createApp() ---> プロジェクトディレクトリ
                                             |                          |
保存設定 (Conf) -------> getPrefOrDefault() -+                          +-> package.json
                                                                        +-> next.config.ts
GitHub example URL ----> downloadAndExtractRepo() -------->             +-> tsconfig.json
                                                                        +-> .gitignore
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.ts | `packages/create-next-app/index.ts` | ソース | CLIエントリーポイント・メイン処理 |
| create-app.ts | `packages/create-next-app/create-app.ts` | ソース | プロジェクト生成処理 |
| templates/index.ts | `packages/create-next-app/templates/index.ts` | ソース | テンプレート定義・インストール |
| helpers/get-pkg-manager.ts | `packages/create-next-app/helpers/get-pkg-manager.ts` | ソース | パッケージマネージャ検出 |
| helpers/examples.ts | `packages/create-next-app/helpers/examples.ts` | ソース | GitHubサンプルダウンロード |
| helpers/git.ts | `packages/create-next-app/helpers/git.ts` | ソース | Git初期化 |
| helpers/install.ts | `packages/create-next-app/helpers/install.ts` | ソース | パッケージインストール |
| helpers/is-folder-empty.ts | `packages/create-next-app/helpers/is-folder-empty.ts` | ソース | ディレクトリ空チェック |
| helpers/validate-pkg.ts | `packages/create-next-app/helpers/validate-pkg.ts` | ソース | npm命名規則バリデーション |
| helpers/is-online.ts | `packages/create-next-app/helpers/is-online.ts` | ソース | ネットワーク接続確認 |
| helpers/typegen.ts | `packages/create-next-app/helpers/typegen.ts` | ソース | TypeScript型定義生成 |
