# 機能設計書 53-next/router

## 概要

本ドキュメントは、Next.jsの`next/router`モジュールの機能設計を記述する。Pages Router用のルーターフック（useRouter）およびシングルトンルーターを提供し、プログラマティックナビゲーション、ルーターイベント監視、現在のルート情報の取得を可能にする。

### 本機能の処理概要

**業務上の目的・背景**：Pages Routerベースのアプリケーションでは、`<Link>`コンポーネントによる宣言的なナビゲーションに加え、JavaScriptコードからプログラマティックにナビゲーションを制御する必要がある。例えばフォーム送信後のリダイレクト、認証状態に応じたページ遷移、URLパラメータの動的な更新などが該当する。`next/router`はこれらのユースケースに対応するRouterインスタンスとフックを提供する。

**機能の利用シーン**：フォーム送信後のプログラマティックナビゲーション（router.push）、認証ガードでの条件分岐リダイレクト、検索パラメータの動的更新、ルーター変更イベントの監視（routeChangeStart等）、現在のパス名やクエリパラメータの取得。

**主要な処理内容**：
1. useRouterフックによるRouterインスタンスの取得
2. シングルトンRouterパターンによるグローバルルーターアクセス
3. ルーターイベント（routeChangeStart, routeChangeComplete, routeChangeError等）のサブスクリプション
4. プログラマティックナビゲーション（push, replace, back, reload, prefetch）
5. 現在のルート情報（pathname, route, query, asPath, locale等）の取得
6. beforePopStateフックによるブラウザバック制御

**関連システム・外部連携**：Pages Routerの内部ルーター実装（`shared/lib/router/router.ts`）と連携。RouterContext経由でReactコンポーネントツリーにルーター状態を伝播する。

**権限による制御**：特にロールや権限による制御は行われない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 該当なし | - | Pages Router全画面で利用可能な汎用ルーターAPI |

## 機能種別

ナビゲーション / React Hooks API / シングルトンパターン

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| url (push/replace) | string \| UrlObject | Yes | ナビゲーション先URL | - |
| as (push/replace) | string \| UrlObject | No | ブラウザ表示URL | - |
| options (push/replace) | TransitionOptions | No | shallow, locale, scroll等のオプション | - |

### 入力データソース

- RouterContext（React Context）からのRouterインスタンス
- ブラウザのwindow.historyとの連携

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| router (useRouter) | NextRouter | pathname, route, query, asPath, locale, push, replace等を持つルーターオブジェクト |
| pathname | string | 現在のルートパス |
| route | string | 現在のルートパターン |
| query | ParsedUrlQuery | クエリパラメータオブジェクト |
| asPath | string | ブラウザに表示されるパス |
| locale | string \| undefined | 現在のロケール |
| isReady | boolean | ルーター準備完了フラグ |

### 出力先

- Reactコンポーネントへの戻り値

## 処理フロー

### 処理シーケンス

```
1. アプリケーション初期化
   └─ singletonRouterにRouterインスタンスを設定
2. useRouter() 呼び出し
   └─ RouterContextからNextRouterインスタンスを取得
3. ナビゲーション実行
   ├─ router.push(url, as, options): History.pushState + ページ遷移
   ├─ router.replace(url, as, options): History.replaceState + ページ遷移
   ├─ router.back(): History.back()
   └─ router.prefetch(url): バックグラウンドページプリフェッチ
4. イベント監視
   ├─ router.events.on('routeChangeStart', handler)
   ├─ router.events.on('routeChangeComplete', handler)
   └─ router.events.on('routeChangeError', handler)
```

### フローチャート

```mermaid
flowchart TD
    A[コンポーネント] --> B{アクセス方法}
    B -->|useRouter hook| C[RouterContext から取得]
    B -->|import Router| D[Singleton Router]
    C --> E[NextRouter インスタンス]
    D --> E
    E --> F{操作}
    F -->|push| G[History.pushState + ページ遷移]
    F -->|replace| H[History.replaceState + ページ遷移]
    F -->|back| I[History.back]
    F -->|prefetch| J[バックグラウンドフェッチ]
    F -->|events| K[イベントリスナー管理]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-53-01 | シングルトンパターン | Routerインスタンスはアプリケーション全体で1つ | 常時 |
| BR-53-02 | readyCallbacks | ルーター初期化前のコールバックはキューに保存され、初期化後に実行 | サーバーサイドレンダリング後 |
| BR-53-03 | URLプロパティ委譲 | pathname, route, query等はRouterインスタンスのプロパティに委譲 | 常時 |
| BR-53-04 | shallow遷移 | shallow: trueの場合、データフェッチなしでURLのみ更新 | push/replaceのオプション |

### 計算ロジック

特になし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | routeChangeError | ナビゲーション中のエラー | router.events.on('routeChangeError')でハンドリング |
| - | No Router | RouterContextがない場合 | エラーメッセージ表示 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- prefetchメソッドによるバックグラウンドページプリフェッチでナビゲーション高速化

## セキュリティ考慮事項

- 外部URLへのプログラマティックナビゲーションは通常のブラウザ遷移として処理される

## 備考

- App Routerでは`next/navigation`の`useRouter`を使用する必要がある
- `next/router`のuseRouterとnext/navigationのuseRouterは別の型とAPIを持つ
- シングルトンRouterはサーバーサイドではnullとなる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | router.ts (shared) | `packages/next/src/shared/lib/router/router.ts` | NextRouter型定義 - pathname, route, query, asPath, locale等のプロパティ |
| 1-2 | router.ts (api) | `packages/next/src/api/router.ts` | エントリーポイント - `export { default } from '../client/router'` |

**読解のコツ**: Pages Routerの`NextRouter`型はApp Routerの`AppRouterInstance`型と異なるAPI体系を持つ。push/replaceのシグネチャ（as引数あり、TransitionOptions）が主な違い。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | router.ts | `packages/next/src/client/router.ts` | **8-18行目**: SingletonRouterBase型 - router, readyCallbacks, ready |
| 2-2 | router.ts | `packages/next/src/client/router.ts` | **20-29行目**: singletonRouter定義 - グローバルなRouterインスタンス管理 |

**主要処理フロー**:
1. **20-29行目**: singletonRouterの初期化（router: null, readyCallbacksキュー）
2. **32-47行目**: urlPropertyFieldsの定義（pathname, route, query, asPath等）
3. **48-50行目**: routerEvents配列（routeChangeStart, beforeHistoryChange等）

#### Step 3: ルーターイベントシステムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | router.ts | `packages/next/src/client/router.ts` | **48行目以降**: routerEventsの定義とイベント委譲の仕組み |

### プログラム呼び出し階層図

```
next/router (api/router.ts)
    |
    +-- client/router.ts
         |
         +-- singletonRouter (グローバルインスタンス)
         |       +-- router: Router | null
         |       +-- readyCallbacks: Array
         |       +-- ready(cb)
         |
         +-- URL Property Fields (委譲)
         |       +-- pathname, route, query, asPath
         |       +-- basePath, locale, locales
         |       +-- isReady, isPreview, isFallback
         |
         +-- Router Events (委譲)
         |       +-- routeChangeStart
         |       +-- routeChangeComplete
         |       +-- routeChangeError
         |       +-- beforeHistoryChange
         |       +-- hashChangeStart
         |       +-- hashChangeComplete
         |
         +-- shared/lib/router/router.ts (Router 本体)
```

### データフロー図

```
[入力]                          [処理]                     [出力]

コンポーネント呼び出し -------> useRouter() ------------> NextRouter
                                |
URL指定 ----------------------> router.push/replace -----> History更新 + ページ遷移
                                |
イベントリスナー登録 ----------> router.events.on -------> コールバック実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| router.ts (api) | `packages/next/src/api/router.ts` | ソース | エントリーポイント（2行） |
| router.ts (client) | `packages/next/src/client/router.ts` | ソース | シングルトンRouter実装 |
| router.ts (shared) | `packages/next/src/shared/lib/router/router.ts` | ソース | Router本体（大規模） |
| router-context.shared-runtime.ts | `packages/next/src/shared/lib/router-context.shared-runtime.ts` | ソース | RouterContext定義 |
