# 機能設計書 62-Bundle Analyzer

## 概要

本ドキュメントは、Next.jsのBundle Analyzer機能の設計について記述する。`@next/bundle-analyzer`パッケージは、Webpackのバンドルサイズを可視化・分析するツールであり、webpack-bundle-analyzerプラグインをNext.jsの設定に統合する。

### 本機能の処理概要

Bundle Analyzerは、Next.jsアプリケーションのWebpackビルドで生成されるバンドルのサイズを可視化し、パフォーマンスボトルネックの特定を支援する機能である。

**業務上の目的・背景**：Webアプリケーションのバンドルサイズは直接パフォーマンスに影響する。開発者が不要な依存関係や大きなモジュールを特定し、バンドルサイズを最適化するためのツールが必要である。Bundle Analyzerはビルド時にバンドル構成をツリーマップとして可視化し、最適化の判断材料を提供する。

**機能の利用シーン**：本番デプロイ前のバンドルサイズ監査、パフォーマンスチューニング、不要な依存関係の特定、コード分割戦略の検討時に利用される。

**主要な処理内容**：
1. Next.js設定ファイル（next.config.js）のwebpack設定をラップし、BundleAnalyzerPluginを注入する
2. クライアント・サーバー・エッジの各コンパイラごとに分析レポートを生成する
3. 静的HTML形式またはJSON形式でレポートを出力する

**関連システム・外部連携**：webpack-bundle-analyzerパッケージに依存する。Turbopackビルドとは互換性がなく、Turbopack使用時は`next experimental-analyze`の使用が推奨される。

**権限による制御**：特になし。

## 関連画面

本機能は画面を持たないビルドツールである。出力されるHTMLレポートはブラウザで閲覧する。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 分析レポート（HTML/JSON） | 結果表示 | バンドルサイズのツリーマップ可視化 |

## 機能種別

バンドル分析 / 可視化ツール

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| enabled | boolean | No | アナライザーの有効/無効（デフォルト: true） | - |
| openAnalyzer | boolean | No | レポート生成後にブラウザで自動的に開くかどうか | - |
| analyzerMode | 'json' \| 'static' | No | 出力形式（デフォルト: 'static'） | 'json'または'static' |
| logLevel | 'info' \| 'warn' \| 'error' \| 'silent' | No | ログレベル（デフォルト: 'info'） | - |

### 入力データソース

next.config.jsで`withBundleAnalyzer`関数を使用してNext.js設定をラップする。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| client分析レポート | HTML/JSON | クライアントサイドバンドルの分析結果。`.next/analyze/client.html`に出力 |
| server(nodejs)分析レポート | HTML/JSON | Node.jsサーバーバンドルの分析結果。`.next/analyze/nodejs.html`に出力 |
| edge分析レポート | HTML/JSON | エッジランタイムバンドルの分析結果。`.next/analyze/edge-server.html`に出力 |

### 出力先

`.next/analyze/`ディレクトリ配下にHTML（またはJSON）ファイルとして出力される。

## 処理フロー

### 処理シーケンス

```
1. withBundleAnalyzer()の呼び出し（next.config.js設定時）
   └─ オプションの受け取りとバリデーション
2. next buildの実行
   └─ Next.js設定のwebpack関数が呼び出される
3. BundleAnalyzerPluginの注入
   └─ options.nextRuntimeに応じたレポートファイル名の決定
4. Webpackビルドの実行
   └─ 各コンパイラ（client/server/edge）でプラグインが実行される
5. 分析レポートの生成
   └─ .next/analyze/配下にHTML/JSONファイルを出力
```

### フローチャート

```mermaid
flowchart TD
    A[withBundleAnalyzer設定] --> B{enabled?}
    B -->|No| C[nextConfigをそのまま返却]
    B -->|Yes| D{TURBOPACK?}
    D -->|Yes| E[警告メッセージを表示し設定をそのまま返却]
    D -->|No| F[webpack関数をラップ]
    F --> G[BundleAnalyzerPlugin注入]
    G --> H{nextRuntime}
    H -->|なし: client| I[./analyze/client.html]
    H -->|nodejs| J[../analyze/nodejs.html]
    H -->|edge| K[../analyze/edge.html]
    I --> L[レポート生成完了]
    J --> L
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-62-01 | Turbopack非互換 | Turbopackビルド時は警告を表示し、分析レポートを生成しない | process.env.TURBOPACKがtrueの場合 |
| BR-62-02 | レポートパス決定 | nextRuntimeに応じて出力ファイルのパスを動的に決定する | Webpackビルド実行時 |
| BR-62-03 | 既存webpack設定の継承 | nextConfig.webpackが定義されている場合、プラグイン注入後に元のwebpack関数を呼び出す | nextConfig.webpackが関数の場合 |

### 計算ロジック

レポートファイルパスの決定ロジック:
- clientコンパイラ（nextRuntime未設定）: `./analyze/client{extension}`
- nodejsコンパイラ: `../../analyze/nodejs{extension}`
- edgeコンパイラ: `../analyze/edge{extension}`

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | console.warn | Turbopackビルド時にBundle Analyzerが有効化された場合 | 警告メッセージを表示し、`next experimental-analyze`の使用を推奨 |

### リトライ仕様

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- Bundle Analyzerの実行はビルド時間に追加のオーバーヘッドを発生させる
- 本番ビルドで常時有効化することは推奨されない

## セキュリティ考慮事項

- 分析レポートにはバンドル構成情報が含まれるため、本番環境に公開しないよう注意が必要

## 備考

- Turbopack使用時は`next experimental-analyze`コマンドの使用が推奨される
- `@next/bundle-analyzer`はnpmパッケージとして公開されており、devDependenciesとして導入する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 型定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.d.ts | `packages/next-bundle-analyzer/index.d.ts` | NextBundleAnalyzer関数の型定義。enabled, openAnalyzer, analyzerMode, logLevelの各オプション |

**読解のコツ**: 型定義ファイルがAPIの公開インターフェースを定義している。戻り値が`(config?: NextConfig) => NextConfig`というHigher-Order Function（HOF）パターンであることに注目。

#### Step 2: メイン実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.js | `packages/next-bundle-analyzer/index.js` | メイン実装。カリー化された関数として、オプション受取→NextConfig変換の2段階 |

**主要処理フロー**:
1. **1-3行目**: オプション受取とNextConfig受取のカリー化
2. **4-6行目**: enabled=falseの場合のアーリーリターン
3. **7-15行目**: Turbopackビルド時の警告と非対応処理
4. **17行目**: analyzerModeに基づく出力ファイル拡張子の決定
5. **19-40行目**: webpack関数のラップとBundleAnalyzerPlugin注入
6. **27-31行目**: nextRuntimeに応じたレポートファイルパスの計算

### プログラム呼び出し階層図

```
withBundleAnalyzer(options)(nextConfig)  [index.js]
    │
    ├─ enabled判定
    │
    ├─ TURBOPACK判定
    │
    └─ webpack(config, options)ラップ
           │
           ├─ new BundleAnalyzerPlugin(...)  [webpack-bundle-analyzer]
           │      └─ analyzerMode, logLevel, openAnalyzer, reportFilename設定
           │
           └─ nextConfig.webpack(config, options)  ※既存設定の呼び出し
```

### データフロー図

```
[入力]                        [処理]                              [出力]

withBundleAnalyzer({     ┌─ オプション判定                  ┌─ ./analyze/client.html
  enabled: true,         │    enabled / TURBOPACK            │
  analyzerMode: 'static' │                                  ├─ ./analyze/nodejs.html
}) ──────────────────────▶│  webpack設定ラップ                │
                         │    BundleAnalyzerPlugin注入       └─ ./analyze/edge.html
nextConfig ─────────────▶│
                         └─ Webpackビルド実行 ──────────────▶ 分析レポートファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.js | `packages/next-bundle-analyzer/index.js` | ソース | メイン実装。webpack設定のラップとBundleAnalyzerPlugin注入 |
| index.d.ts | `packages/next-bundle-analyzer/index.d.ts` | 型定義 | TypeScript型定義 |
| package.json | `packages/next-bundle-analyzer/package.json` | 設定 | パッケージメタデータと依存関係定義 |
| readme.md | `packages/next-bundle-analyzer/readme.md` | ドキュメント | 使用方法の説明 |
