# 機能設計書 65-Node.jsサーバー

## 概要

本ドキュメントは、Next.jsのNode.jsサーバー（NextNodeServer）の設計について記述する。NextNodeServerはプロダクション環境でNext.jsアプリケーションを配信するNode.jsベースのHTTPサーバーであり、リクエスト処理・ルーティング・レンダリング・キャッシュを統合的に管理する。

### 本機能の処理概要

NextNodeServerは、BaseServerを継承したNode.js固有のサーバー実装であり、`next start`コマンドで起動されるプロダクションサーバーの中核である。

**業務上の目的・背景**：Next.jsアプリケーションを本番環境でホスティングするためには、ルーティング・SSR・SSG・ISR・API Routes・ミドルウェアなどの全機能を統合的に処理するHTTPサーバーが必要である。NextNodeServerはこれらの機能を単一のNode.jsプロセスで提供する。

**機能の利用シーン**：プロダクション環境でのアプリケーション配信、`next start`コマンドによるサーバー起動、カスタムサーバー統合時の内部サーバーインスタンスとして利用される。

**主要な処理内容**：
1. HTTPリクエストの受信とルーティング（ページルート・APIルート・静的ファイル）
2. ページのサーバーサイドレンダリング（SSR）とHTML生成
3. 静的ファイル・プリレンダリング済みページの配信
4. Incremental Static Regeneration（ISR）によるページの再生成
5. ミドルウェアの実行とリクエスト/レスポンス変換
6. レスポンスキャッシュの管理
7. 画像最適化リクエストの処理

**関連システム・外部連携**：Router Server（リクエストルーティング）、IncrementalCache（ISRキャッシュ）、ResponseCache（レスポンスキャッシュ）、Image Optimizer（画像最適化）。

**権限による制御**：特になし。全てのHTTPリクエストを処理する。

## 関連画面

NextNodeServerは全画面のバックエンドとして機能する。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 全ページ | サーバー | HTTPリクエスト処理・SSR・静的配信 |

## 機能種別

サーバー / リクエスト処理 / レンダリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| options.dir | string | Yes | プロジェクトのルートディレクトリ | 有効なディレクトリパス |
| options.dev | boolean | No | 開発モードかどうか（デフォルト: false） | - |
| options.conf | NextConfigComplete | Yes | Next.js設定オブジェクト | - |
| options.hostname | string | No | サーバーのホスト名 | - |
| options.port | number | No | サーバーのポート番号 | - |
| options.minimalMode | boolean | No | 最小モード（サーバーレス環境向け） | - |

### 入力データソース

- HTTPリクエスト（IncomingMessage/ServerResponse）
- ビルド成果物（.nextディレクトリ配下のマニフェスト・チャンク）
- 設定ファイル（next.config.js）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTTPレスポンス | ServerResponse | レンダリング済みHTML、JSON、静的ファイル等のHTTPレスポンス |
| キャッシュデータ | CacheEntry | ISR/レスポンスキャッシュに保存されるキャッシュエントリ |

### 出力先

HTTPレスポンスとしてクライアントに送信。ISRキャッシュはファイルシステムまたはカスタムキャッシュハンドラに保存。

## 処理フロー

### 処理シーケンス

```
1. サーバー初期化（constructor）
   └─ マニフェスト読み込み・キャッシュ初期化・ルート設定
2. リクエスト受信
   └─ NodeNextRequest/NodeNextResponseへのラップ
3. ルートマッチング
   └─ ページマニフェスト・App Pathsマニフェストからルートを検索
4. ミドルウェア実行（該当する場合）
   └─ Edge Runtimeでミドルウェアを実行
5. コンポーネントのロード
   └─ loadComponents()でページモジュールをロード
6. レンダリング実行
   └─ SSR/SSG/ISRに応じたレンダリング処理
7. レスポンス送信
   └─ sendRenderResult()でHTTPレスポンスを送信
8. キャッシュ更新（ISR時）
   └─ IncrementalCacheにキャッシュエントリを保存
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B[NodeNextRequest/Responseラップ]
    B --> C[ルートマッチング]
    C --> D{ルート種別}
    D -->|静的ファイル| E[serveStatic]
    D -->|APIルート| F[API Route処理]
    D -->|ページルート| G{キャッシュ確認}
    G -->|キャッシュヒット| H[キャッシュレスポンス返却]
    G -->|キャッシュミス| I[SSR/SSGレンダリング]
    I --> J[レスポンス送信]
    J --> K{ISR有効?}
    K -->|Yes| L[キャッシュ更新]
    K -->|No| M[完了]
    H --> M
    E --> M
    F --> M
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-65-01 | BaseServer継承 | NextNodeServerはBaseServerを継承し、Node.js固有の処理を実装する | 常時 |
| BR-65-02 | マニフェストベースルーティング | ビルド時に生成されたマニフェスト（PAGES_MANIFEST、APP_PATHS_MANIFEST等）に基づいてルーティングする | プロダクションモード |
| BR-65-03 | 動的ルート | ビルド時に生成されたルート正規表現に基づいて動的ルートをマッチングする | 動的ルート（[param]等） |
| BR-65-04 | エントリーのプリロード | experimental.preloadEntriesOnStartが有効な場合、サーバー起動時に全エントリーをプリロードする | 実験的機能有効時 |
| BR-65-05 | MiddlewareMatcherキャッシュ | ミドルウェアマッチャーをWeakMapでキャッシュし、重複計算を回避する | ミドルウェアが定義されている場合 |

### 計算ロジック

動的ルートマッチングはgetRouteRegexで生成された正規表現を使用し、getRouteMatcherで実行される。

## データベース操作仕様

本機能は直接的なデータベース操作を行わない。IncrementalCacheを介したファイルシステムI/Oが存在する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| PageNotFoundError | 404 | リクエストされたページが存在しない場合 | 404ページを返却 |
| DecodeError | 400 | URLのデコードに失敗した場合 | 400レスポンスを返却 |
| MiddlewareNotFoundError | 500 | ミドルウェアファイルが見つからない場合 | 500エラーを返却 |
| BubbledError | 500 | トレーシング中のエラー伝播 | エラーハンドリングチェーンで処理 |

### リトライ仕様

ISRの再生成処理ではstale-while-revalidateパターンが使用される。再生成に失敗した場合は既存のキャッシュが維持される。

## トランザクション仕様

該当なし。HTTPリクエスト/レスポンスはステートレスに処理される。

## パフォーマンス要件

- リクエスト処理はストリーミング対応でメモリ効率を確保する
- ResponseCacheにより頻繁にアクセスされるページのレスポンスをメモリキャッシュする
- 画像最適化レスポンスは専用のimageResponseCacheでキャッシュする

## セキュリティ考慮事項

- SRI（Subresource Integrity）が有効な場合、スクリプトタグにintegrityハッシュを付与する
- テストプロキシ環境ではinternal headersのフィルタリングを行う
- experimental.removeUncaughtErrorAndRejectionListeners設定によるプロセスエラーハンドリング制御

## 備考

- NextNodeServerは`packages/next/src/server/next-server.ts`に定義される
- BaseServerは`packages/next/src/server/base-server.ts`に定義される
- カスタムサーバー利用時は`next()`関数でNextNodeServerのインスタンスが生成される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | base-server.ts | `packages/next/src/server/base-server.ts` | Options型、FindComponentsResult、LoadedRenderOpts等の基底サーバー型定義 |
| 1-2 | request-meta.ts | `packages/next/src/server/request-meta.ts` | NextParsedUrlQuery、RequestMeta型定義。リクエストメタデータの構造 |

**読解のコツ**: BaseServerは抽象クラスであり、Node.js固有の実装はNextNodeServerで行われる。型定義を先に理解することで、後続のコード読解が容易になる。

#### Step 2: エントリーポイント（コンストラクタ）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | next-server.ts | `packages/next/src/server/next-server.ts` | NextNodeServerクラスのconstructor（198-284行目）。初期化処理の全体像を把握 |

**主要処理フロー**:
1. **198-200行目**: super(options)でBaseServerを初期化
2. **202行目**: installGlobalBehaviors()でグローバル動作設定
3. **220-222行目**: imageResponseCacheの初期化
4. **224-230行目**: preloadEntriesOnStart有効時のエントリープリロード
5. **232-245行目**: 動的ルートの正規表現構築
6. **259-262行目**: ミドルウェアマニフェストパスの設定
7. **268-272行目**: prepare()の非同期開始

#### Step 3: ルーティングとリクエスト処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | next-server.ts | `packages/next/src/server/next-server.ts` | handleRequest、findPageComponents、renderToHTML等のリクエスト処理メソッド群 |
| 3-2 | base-server.ts | `packages/next/src/server/base-server.ts` | run()メソッド。リクエスト処理のメインループ |

#### Step 4: コンポーネントロードを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | load-components.ts | `packages/next/src/server/load-components.ts` | loadComponents()関数。ページモジュール・マニフェストのロード |

### プログラム呼び出し階層図

```
NextNodeServer [next-server.ts]
    │ extends
    ├─ BaseServer [base-server.ts]
    │      ├─ handleRequest()
    │      │      ├─ resolveRoutes()
    │      │      ├─ runMiddleware()
    │      │      └─ run()
    │      │             ├─ findPageComponents()
    │      │             ├─ renderToResponseWithComponents()
    │      │             └─ sendRenderResult()
    │      │
    │      └─ prepare()
    │             └─ マニフェスト読み込み
    │
    ├─ loadComponents() [load-components.ts]
    │      └─ ページモジュール・マニフェストのロード
    │
    ├─ ResponseCache [response-cache/]
    │      └─ キャッシュ検索・保存
    │
    └─ IncrementalCache [lib/incremental-cache/]
           └─ ISRキャッシュ管理
```

### データフロー図

```
[入力]                         [処理]                            [出力]

HTTPリクエスト            ──▶  NextNodeServer
  IncomingMessage                │
  ServerResponse                 ├─ ルートマッチング
                                 ├─ ミドルウェア実行
                                 ├─ コンポーネントロード
                                 ├─ SSR/SSGレンダリング
                                 └─ レスポンス送信      ──▶  HTTPレスポンス

マニフェスト             ──▶  ルート解決                ──▶  ページコンポーネント
  PAGES_MANIFEST
  APP_PATHS_MANIFEST
  MIDDLEWARE_MANIFEST
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| next-server.ts | `packages/next/src/server/next-server.ts` | ソース | NextNodeServerクラス（プロダクションサーバー本体） |
| base-server.ts | `packages/next/src/server/base-server.ts` | ソース | BaseServerクラス（サーバー基底クラス） |
| load-components.ts | `packages/next/src/server/load-components.ts` | ソース | ページコンポーネントのロード |
| request-meta.ts | `packages/next/src/server/request-meta.ts` | ソース | リクエストメタデータ管理 |
| send-payload.ts | `packages/next/src/server/send-payload.ts` | ソース | レスポンス送信 |
| response-cache/ | `packages/next/src/server/response-cache/` | ソース | レスポンスキャッシュ |
| lib/incremental-cache/ | `packages/next/src/server/lib/incremental-cache/` | ソース | ISRキャッシュ |
| render.tsx | `packages/next/src/server/render.tsx` | ソース | ページレンダリング |
