# 機能設計書 67-Router Server

## 概要

本ドキュメントは、Next.jsのRouter Serverの設計について記述する。Router Serverはリクエストルーティングの中核であり、ミドルウェア実行・リライト・リダイレクト・i18nロケール処理・ファイルシステムチェック・レンダーサーバーへのプロキシを統合的に処理する。

### 本機能の処理概要

Router Serverは、Next.jsサーバーのフロントドアとして機能し、受信したHTTPリクエストを適切なハンドラにルーティングする。開発・本番の両環境で動作する。

**業務上の目的・背景**：Next.jsアプリケーションへのHTTPリクエストは、ページルート・APIルート・静的ファイル・ミドルウェア・リライト・リダイレクトなど多様な処理経路を持つ。Router Serverはこれらの処理を統一的に管理し、正しいハンドラにリクエストをディスパッチする。

**機能の利用シーン**：`next start`および`next dev`の両方で使用される。全てのHTTPリクエストの最初の受け口として機能する。

**主要な処理内容**：
1. サーバー初期化（設定ロード、ファイルシステムチェック、圧縮設定）
2. 開発モードでのDevBundler設定
3. i18nロケール検出とリダイレクト
4. ルート解決（resolveRoutes）によるリクエストのディスパッチ
5. ミドルウェア実行とリクエスト変換
6. 静的ファイル配信
7. レンダーサーバーへのプロキシ転送
8. Cross-Site Access Blocking

**関連システム・外部連携**：RenderServer（レンダリング実行）、DevBundlerService（開発時バンドラー）、setupFsCheck（ファイルシステムチェック）、resolveRoutes（ルート解決）。

**権限による制御**：blockCrossSiteによるクロスサイトアクセスのブロック。

## 関連画面

Router Serverは全画面のリクエスト処理基盤として機能する。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 全ページ | ルーティング | 全HTTPリクエストのルート解決とディスパッチ |

## 機能種別

サーバー / ルーティング / リクエストディスパッチ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| opts.dir | string | Yes | プロジェクトのルートディレクトリ | 有効なディレクトリパス |
| opts.port | number | Yes | サーバーポート番号 | 正の整数 |
| opts.dev | boolean | Yes | 開発モードかどうか | - |
| opts.server | http.Server | No | 既存のHTTPサーバーインスタンス | - |
| opts.minimalMode | boolean | No | 最小モード（サーバーレス環境向け） | - |
| opts.hostname | string | No | サーバーのホスト名 | - |
| opts.customServer | boolean | No | カスタムサーバー使用フラグ | - |
| opts.quiet | boolean | No | ログ出力抑制フラグ | - |

### 入力データソース

- HTTPリクエスト（IncomingMessage）
- Next.js設定ファイル（next.config.js）
- ファイルシステム（ページファイル、静的ファイル）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ServerInitResult | object | サーバー初期化結果（リクエストハンドラ、アップグレードハンドラ等） |
| HTTPレスポンス | ServerResponse | ルーティング後のHTTPレスポンス |

### 出力先

HTTPレスポンスとしてクライアントに送信。開発モードではHMRアップグレードハンドラも提供。

## 処理フロー

### 処理シーケンス

```
1. initialize()関数の呼び出し
   └─ 設定ロード（loadConfig）
   └─ 圧縮ミドルウェア設定（setupCompression）
   └─ ファイルシステムチェック初期化（setupFsCheck）
2. 開発モード時の追加処理
   └─ テレメトリ初期化
   └─ setupDevBundler()でバンドラー設定
   └─ DevBundlerService初期化
3. RenderServer初期化
   └─ require('./render-server')
4. リクエストハンドラの構築
   └─ i18nロケール検出・リダイレクト
   └─ resolveRoutes()でルート解決
   └─ ミドルウェア実行
   └─ レンダーサーバーへの転送
5. クリーンアップ処理
   └─ サーバー停止時のリソース解放
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B[内部ヘッダーフィルタリング]
    B --> C{i18n有効?}
    C -->|Yes| D[ロケール検出・リダイレクト判定]
    C -->|No| E[ルート解決]
    D --> E
    E --> F{Cross-Site Access?}
    F -->|Yes| G[403ブロック]
    F -->|No| H{静的ファイル?}
    H -->|Yes| I[serveStatic]
    H -->|No| J{ミドルウェア対象?}
    J -->|Yes| K[ミドルウェア実行]
    J -->|No| L[レンダーサーバーへ転送]
    K --> M{リダイレクト?}
    M -->|Yes| N[リダイレクトレスポンス]
    M -->|No| L
    I --> O[レスポンス完了]
    G --> O
    N --> O
    L --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-67-01 | 設定ロード | 開発/本番モードに応じてPHASE_DEVELOPMENT_SERVER/PHASE_PRODUCTION_SERVERで設定をロードする | サーバー初期化時 |
| BR-67-02 | 圧縮ミドルウェア | config.compress !== falseの場合に圧縮ミドルウェアを有効化する | サーバー初期化時 |
| BR-67-03 | 内部ヘッダーフィルタリング | テスト環境以外では内部ヘッダーをフィルタリングする | リクエスト処理時 |
| BR-67-04 | ロケールリダイレクト | i18n設定が有効な場合、ロケールに基づくリダイレクトを実行する | i18n.localeDetection !== false |
| BR-67-05 | Cross-Siteブロック | 異なるサイトからの不正アクセスをブロックする | blockCrossSite関数が呼び出された場合 |
| BR-67-06 | DevBundler初期化 | 開発モード時にsetupDevBundlerでバンドラーを初期化する | opts.dev === true |
| BR-67-07 | Next Fontパス判定 | /media/配下のフォントファイル（woff/woff2/eot/ttf/otf）を特別に処理する | isNextFont関数 |

### 計算ロジック

ロケールリダイレクトはgetLocaleRedirect()関数で判定される。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| DecodeError | 400 | URLのデコードに失敗した場合 | 400レスポンスを返却 |
| NoFallbackError | 404 | フォールバックページが存在しない場合 | 404レスポンスを返却 |
| AbortError | - | リクエスト処理が中断された場合 | 処理を中断 |

### リトライ仕様

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- ファイルシステムチェックはsetupFsCheckで事前に構築され、リクエスト時のファイルI/Oを最小化する
- 圧縮ミドルウェアによりレスポンスサイズを削減する
- requestHandlersのキャッシュによりハンドラ検索を高速化する

## セキュリティ考慮事項

- blockCrossSiteによるクロスサイトアクセスブロック
- 内部ヘッダーのフィルタリング（テスト環境以外）
- Chrome DevTools Workspaceリクエストの特別処理

## 備考

- Router Serverは`packages/next/src/server/lib/router-server.ts`に定義される
- initialize()関数がメインのエントリーポイント
- 開発モードではsetupDevBundlerが呼ばれ、HMR・ファイル監視等の開発機能が初期化される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | router-server.ts | `packages/next/src/server/lib/router-server.ts` | RenderServer型、LazyRenderServerInstance型、initialize関数の引数型を確認 |

**読解のコツ**: `LazyRenderServerInstance`は`instance?: RenderServer`という遅延初期化パターンを使用している。RenderServer自体は`render-server.ts`モジュールのexport群を示す型エイリアス。

#### Step 2: initialize関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | router-server.ts | `packages/next/src/server/lib/router-server.ts` | initialize()関数（82-198行目）。設定ロード→ファイルシステムチェック→開発バンドラー→RenderServer初期化の流れ |

**主要処理フロー**:
1. **96-99行目**: NODE_ENV設定
2. **102-113行目**: loadConfig()で設定ロード
3. **115-119行目**: 圧縮ミドルウェア設定
4. **121-126行目**: setupFsCheck()でファイルシステムチェック初期化
5. **140-197行目**: 開発モード時のsetupDevBundler呼び出しとDevBundlerService初期化
6. **200-201行目**: RenderServerのrequire

#### Step 3: リクエストハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | router-server.ts | `packages/next/src/server/lib/router-server.ts` | requestHandlerImpl関数（203行目以降）。i18nロケール処理→resolveRoutes→レスポンス返却の流れ |

#### Step 4: ルート解決の詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | resolve-routes.ts | `packages/next/src/server/lib/router-utils/resolve-routes.ts` | getResolveRoutes()関数。ミドルウェア・リライト・リダイレクトの統合的なルート解決 |
| 4-2 | filesystem.ts | `packages/next/src/server/lib/router-utils/filesystem.ts` | setupFsCheck()。ファイルシステムベースのルート検証 |

### プログラム呼び出し階層図

```
initialize() [router-server.ts]
    │
    ├─ loadConfig() [config.ts]
    │      └─ Next.js設定の読み込み
    │
    ├─ setupFsCheck() [router-utils/filesystem.ts]
    │      └─ ファイルシステムルート検証の初期化
    │
    ├─ setupDevBundler() [router-utils/setup-dev-bundler.ts] ※開発モード
    │      └─ HotReloader・ファイル監視等の初期化
    │
    ├─ RenderServer [render-server.ts]
    │      └─ initialize() / propagateServerField()
    │
    └─ requestHandlerImpl()
           ├─ filterInternalHeaders()
           ├─ getLocaleRedirect() ※i18n有効時
           ├─ blockCrossSite()
           ├─ getResolveRoutes() [resolve-routes.ts]
           │      ├─ ミドルウェアマッチング
           │      ├─ リライト処理
           │      └─ リダイレクト処理
           ├─ serveStatic() ※静的ファイル
           └─ proxyRequest() → RenderServer
```

### データフロー図

```
[入力]                       [処理]                            [出力]

HTTPリクエスト          ──▶  Router Server
  req: IncomingMessage         │
  res: ServerResponse          ├─ 設定ロード
                               ├─ ファイルシステムチェック
                               ├─ i18nロケール検出
                               ├─ ルート解決
                               │    ├─ ミドルウェア実行
                               │    ├─ リライト/リダイレクト
                               │    └─ ページルーティング
                               └─ レンダーサーバーへ転送  ──▶  HTTPレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| router-server.ts | `packages/next/src/server/lib/router-server.ts` | ソース | Router Server本体。initialize()関数とリクエストハンドラ |
| resolve-routes.ts | `packages/next/src/server/lib/router-utils/resolve-routes.ts` | ソース | ルート解決ロジック |
| filesystem.ts | `packages/next/src/server/lib/router-utils/filesystem.ts` | ソース | ファイルシステムチェック |
| setup-dev-bundler.ts | `packages/next/src/server/lib/router-utils/setup-dev-bundler.ts` | ソース | 開発バンドラー設定 |
| render-server.ts | `packages/next/src/server/lib/render-server.ts` | ソース | レンダーサーバー |
| proxy-request.ts | `packages/next/src/server/lib/router-utils/proxy-request.ts` | ソース | プロキシリクエスト転送 |
| block-cross-site.ts | `packages/next/src/server/lib/router-utils/block-cross-site.ts` | ソース | クロスサイトアクセスブロック |
| dev-bundler-service.ts | `packages/next/src/server/lib/dev-bundler-service.ts` | ソース | 開発バンドラーサービス |
