# 機能設計書 82-TypeScript設定

## 概要

本ドキュメントは、Next.jsにおけるTypeScript設定サポート機能の設計書である。`next.config.ts` によるTypeScriptでの設定ファイル記述、tsconfig.jsonの自動設定、型チェック、型定義自動生成を含む包括的なTypeScriptサポートを提供する。

### 本機能の処理概要

**業務上の目的・背景**：TypeScriptはフロントエンド開発における標準的な型安全言語として広く採用されている。Next.jsはTypeScriptのファーストクラスサポートを提供し、設定ファイル自体もTypeScriptで記述可能にすることで、型安全な設定管理と開発者体験の向上を実現する。

**機能の利用シーン**：プロジェクト初期セットアップ時のtsconfig.json自動生成、`next build`時の型チェック実行、`next.config.ts`の読み込み時のSWCトランスパイル、開発時の型定義ファイル自動生成など、開発ライフサイクル全体で利用される。

**主要な処理内容**：
1. TypeScriptインテントの検出（tsconfig.jsonの存在チェック、.ts/.tsxファイルの検出）
2. tsconfig.jsonのデフォルト設定書き込みと必須設定の強制
3. `next.config.ts`のSWCによるトランスパイルとCommonJSモジュールとしての評価
4. ビルド時の型チェック実行（`runTypeCheck`）
5. 型定義ファイル（`.next/types`）の自動生成

**関連システム・外部連携**：SWCコンパイラ（トランスパイル）、TypeScript compiler API（型チェック）、tsconfig.json

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たない内部処理機構である |

## 機能種別

設定管理 / コンパイル処理 / バリデーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| baseDir | string | Yes | プロジェクトルートディレクトリ | 存在するディレクトリであること |
| tsconfigPath | string | No | カスタムtsconfig.jsonのパス（next.config.jsのtypescript.tsconfigPathで指定） | 有効なファイルパス |
| nextConfigPath | string | No | next.config.tsのパス | .ts拡張子であること |

### 入力データソース

- `tsconfig.json`（プロジェクトルート）
- `next.config.ts`（TypeScript設定ファイル）
- ソースファイル（.ts/.tsx）
- TypeScriptコンパイラ（`typescript`パッケージ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| tsconfig.json | file | 自動更新されたTypeScript設定ファイル |
| TypeCheckResult | object | 型チェック結果（warnings, inputFilesCount, totalFilesCount, incremental） |
| .next/types/ | directory | 自動生成された型定義ファイル群 |
| NextConfig | object | トランスパイルされた設定オブジェクト（next.config.ts使用時） |

### 出力先

- ファイルシステム（tsconfig.json、.next/types/）
- ビルドプロセス（型チェック結果）
- ランタイム設定（トランスパイル済み設定オブジェクト）

## 処理フロー

### 処理シーケンス

```
1. TypeScriptインテント検出
   └─ tsconfig.jsonの存在確認 or .ts/.tsxファイルの検出
2. 初回セットアップ（firstTimeSetup）
   └─ tsconfig.jsonが空または存在しない場合、デフォルト設定を書き込み
3. tsconfig.json設定の検証・更新
   └─ 必須設定（module, jsx, moduleResolution等）の強制
   └─ 推奨設定（target, lib, allowJs等）の提案
4. next.config.tsトランスパイル（該当時）
   └─ Node.jsネイティブTS対応の試行
   └─ SWCによるトランスパイルとCommonJS変換
5. ビルド時型チェック
   └─ TypeScript compiler APIで型チェック実行
   └─ エラー・警告のフォーマットと出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{tsconfig.json存在?}
    B -->|No| C{.ts/.tsxファイル存在?}
    C -->|No| D[TypeScript無効]
    C -->|Yes| E[firstTimeSetup: true]
    B -->|Yes| F{空または{}?}
    F -->|Yes| E
    F -->|No| G[firstTimeSetup: false]
    E --> H[tsconfig.jsonデフォルト書き込み]
    G --> I[tsconfig.json検証・更新]
    H --> I
    I --> J{next.config.ts?}
    J -->|Yes| K[SWCトランスパイル]
    J -->|No| L[next.config.js読み込み]
    K --> M[ビルド時型チェック]
    L --> M
    M --> N{ignoreBuildErrors?}
    N -->|Yes| O[型エラー無視]
    N -->|No| P[型エラー報告]
    O --> Q[終了]
    P --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-82-01 | 自動検出 | .ts/.tsxファイルが存在するだけでTypeScriptセットアップが開始される | 初回ビルド/dev時 |
| BR-82-02 | 必須設定の強制 | module, jsx, moduleResolution等は互換性のある値でなければならない | tsconfig.json読み込み時 |
| BR-82-03 | 型チェックスキップ | typescript.ignoreBuildErrors=trueで型エラーをビルドエラーとしない | ビルド時 |
| BR-82-04 | カスタムtsconfigPath | typescript.tsconfigPathで別のtsconfig.jsonを指定可能 | 設定ファイル指定時 |
| BR-82-05 | 推奨設定の提案 | target, lib, allowJs等はsuggestedとして提案され、未設定時に自動設定 | tsconfig.json更新時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベースに対する操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CompileError | 型チェックでエラー検出（ignoreBuildErrors=false） | TypeScriptエラーを修正する |
| - | MissingDependencyError | typescriptパッケージ未インストール | npm install typescript を実行 |
| - | Error | next.config.tsのトランスパイル失敗 | TypeScript構文エラーを修正する |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- tsconfig.json検証はミリ秒単位で完了する
- 型チェックはプロジェクト規模に依存し、大規模プロジェクトでは数十秒かかる場合がある
- incremental型チェックにより2回目以降は高速化される

## セキュリティ考慮事項

- next.config.tsのトランスパイル時にrequireフックが一時的に登録されるため、信頼できるコードのみを含めるべき

## 備考

- TypeScript 5.4.0以降では`module: "preserve"`がサポートされる
- Node.js v22.10.0以降ではネイティブTypeScriptストリップ機能が利用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config-shared.ts | `packages/next/src/server/config-shared.ts` | **50-55行目**: `TypeScriptConfig`インターフェース（ignoreBuildErrors, tsconfigPath） |
| 1-2 | runTypeCheck.ts | `packages/next/src/lib/typescript/runTypeCheck.ts` | **10-16行目**: `TypeCheckResult`インターフェース |
| 1-3 | getTypeScriptIntent.ts | `packages/next/src/lib/typescript/getTypeScriptIntent.ts` | **5行目**: `TypeScriptIntent`型 |

**読解のコツ**: TypeScript設定サポートは複数のファイルに分散しているが、`getTypeScriptIntent` -> `writeConfigurationDefaults` -> `runTypeCheck` の順で処理が流れる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | getTypeScriptIntent.ts | `packages/next/src/lib/typescript/getTypeScriptIntent.ts` | **7-42行目**: tsconfig.jsonの存在確認と.ts/.tsxファイルの検出ロジック |

**主要処理フロー**:
1. **16行目**: tsconfig.jsonの存在チェック
2. **22行目**: 空ファイル判定（firstTimeSetup）
3. **29-39行目**: .ts/.tsxファイルの再帰検索

#### Step 3: tsconfig.json自動設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | writeConfigurationDefaults.ts | `packages/next/src/lib/typescript/writeConfigurationDefaults.ts` | **21-75行目**: `getDesiredCompilerOptions`で必須/推奨設定を定義 |

**主要処理フロー**:
- **44-47行目**: target推奨値（ES2017）
- **51-56行目**: lib, allowJs, skipLibCheck等の推奨値
- **61-75行目**: module設定の必須値と許可値リスト

#### Step 4: TypeScript設定ファイルのトランスパイルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | transpile-config.ts | `packages/next/src/build/next-config-ts/transpile-config.ts` | **139-191行目**: `transpileConfig`関数でSWCトランスパイル |
| 4-2 | transpile-config.ts | `packages/next/src/build/next-config-ts/transpile-config.ts` | **14-43行目**: `resolveSWCOptions`でSWCオプション構築 |
| 4-3 | transpile-config.ts | `packages/next/src/build/next-config-ts/transpile-config.ts` | **80-122行目**: `loadTsConfigFile`でtsconfig.jsonの再帰的読み込み（extends対応） |

#### Step 5: 型チェック実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | runTypeCheck.ts | `packages/next/src/lib/typescript/runTypeCheck.ts` | **39-48行目**: `runTypeCheck`関数のシグネチャと型チェック設定 |

### プログラム呼び出し階層図

```
ビルドプロセス / 開発サーバー起動
    |
    +-- getTypeScriptIntent()            # TS使用意図の検出
    |       +-- existsSync(tsconfig.json)
    |       +-- recursiveReadDir(.ts/.tsx)
    |
    +-- writeConfigurationDefaults()      # tsconfig.json自動設定
    |       +-- getDesiredCompilerOptions()
    |       +-- CommentJson.parse/stringify
    |
    +-- transpileConfig()                 # next.config.tsトランスパイル
    |       +-- loadTsConfig()
    |       |       +-- loadTsConfigFile()  # extends再帰解決
    |       +-- resolveSWCOptions()
    |       +-- handleCJS()
    |           +-- loadBindings()
    |           +-- bindings.transform()
    |
    +-- runTypeCheck()                    # 型チェック実行
            +-- getTypeScriptConfiguration()
            +-- typescript.createProgram()
            +-- getFormattedDiagnostic()
```

### データフロー図

```
[入力]                    [処理]                          [出力]

tsconfig.json ────────▶ getTypeScriptIntent() ──▶ TypeScriptIntent
                         |
tsconfig.json ────────▶ writeConfigurationDefaults() ──▶ 更新されたtsconfig.json
                         |
next.config.ts ───────▶ transpileConfig() ──────▶ NextConfig オブジェクト
                         |
*.ts/*.tsx ────────────▶ runTypeCheck() ─────────▶ TypeCheckResult
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| getTypeScriptIntent.ts | `packages/next/src/lib/typescript/getTypeScriptIntent.ts` | ソース | TypeScript使用意図の検出 |
| writeConfigurationDefaults.ts | `packages/next/src/lib/typescript/writeConfigurationDefaults.ts` | ソース | tsconfig.jsonのデフォルト設定書き込み |
| runTypeCheck.ts | `packages/next/src/lib/typescript/runTypeCheck.ts` | ソース | ビルド時の型チェック実行 |
| getTypeScriptConfiguration.ts | `packages/next/src/lib/typescript/getTypeScriptConfiguration.ts` | ソース | TypeScript設定の解決 |
| diagnosticFormatter.ts | `packages/next/src/lib/typescript/diagnosticFormatter.ts` | ソース | 型チェックエラーのフォーマット |
| missingDependencyError.ts | `packages/next/src/lib/typescript/missingDependencyError.ts` | ソース | TypeScript未インストール時のエラー |
| writeAppTypeDeclarations.ts | `packages/next/src/lib/typescript/writeAppTypeDeclarations.ts` | ソース | App Router用型定義の自動生成 |
| type-paths.ts | `packages/next/src/lib/typescript/type-paths.ts` | ソース | 型定義ファイルパスの管理 |
| transpile-config.ts | `packages/next/src/build/next-config-ts/transpile-config.ts` | ソース | TypeScript設定ファイルのトランスパイル |
| config-shared.ts | `packages/next/src/server/config-shared.ts` | ソース | TypeScriptConfig型定義 |
