# 機能設計書 86-Webpack統合

## 概要

本ドキュメントは、Next.jsにおけるWebpackベースのビルドパイプラインに関する機能設計書である。Webpackの設定生成、カスタムローダー・プラグインの統合、クライアント/サーバー/エッジ向けのマルチコンパイル構成を提供する。

### 本機能の処理概要

**業務上の目的・背景**：Next.jsはWebpackをデフォルトのバンドラとして使用し、JavaScript/TypeScript/CSS/画像等のアセットを最適化されたバンドルに変換する。開発者はWebpackの設定をカスタマイズでき、独自のローダーやプラグインを追加してビルドパイプラインを拡張できる。

**機能の利用シーン**：`next build`や`next dev`（Webpack使用時）に呼び出される。内部的にクライアントコンパイル、サーバーコンパイル、エッジランタイムコンパイルの3つのWebpack設定を生成し、それぞれに最適化されたバンドルを出力する。

**主要な処理内容**：
1. `COMPILER_NAMES`（client, server, edge-server）別のWebpack設定生成
2. エントリーポイントの構築（ページ、API、App Routerルート）
3. モジュール解決ルール（resolve aliases、externals）の設定
4. SWCローダー/Babelローダーの設定
5. 各種Webpackプラグインの統合（BuildManifest、FlightManifest、MiddlewarePlugin等）
6. ユーザーのwebpackカスタム設定関数の適用
7. コード分割、ツリーシェイキング、ソースマップの設定

**関連システム・外部連携**：SWCコンパイラ（トランスパイル）、Babel（フォールバック）、PostCSS（CSS処理）、Turbopack（代替バンドラ）

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないビルドパイプライン機構である |

## 機能種別

ビルド処理 / コード変換 / アセット最適化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| dir | string | Yes | プロジェクトルートディレクトリ | - |
| config | NextConfigComplete | Yes | Next.js設定オブジェクト | - |
| compilerType | CompilerNameValues | Yes | コンパイル対象（client/server/edge-server） | COMPILER_NAMES定数値 |
| dev | boolean | Yes | 開発モードかどうか | - |
| entrypoints | object | Yes | エントリーポイント定義 | - |
| buildId | string | Yes | ビルド識別子 | - |

### 入力データソース

- Next.js設定オブジェクト（NextConfigComplete）
- ページファイル・App Routerルートファイル
- next.config.jsのwebpackカスタム関数
- jsconfig.json / tsconfig.json（パスエイリアス）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| webpack.Configuration | object | 完全なWebpack設定オブジェクト |
| バンドルファイル | files | .next/static/、.next/server/配下のバンドルされたJavaScriptファイル |
| マニフェストファイル | files | build-manifest.json、react-loadable-manifest.json等 |

### 出力先

- `.next/` ディレクトリ配下

## 処理フロー

### 処理シーケンス

```
1. ベース設定の構築
   └─ resolve aliases（React、Next.js内部モジュール）
   └─ externals設定（node_modules、サーバー外部パッケージ）
   └─ モジュールルール（SWC/Babel、CSS、画像等）
2. コンパイラタイプ別設定
   └─ client: React Refresh、コード分割、polyfills
   └─ server: Node.js externals、サーバーコンポーネント
   └─ edge-server: Edge Runtime polyfills、制限付きAPI
3. プラグインの追加
   └─ BuildManifestPlugin
   └─ ClientReferenceManifestPlugin（RSC）
   └─ NextFlightClientEntryPlugin
   └─ MiddlewarePlugin
   └─ WellKnownErrorsPlugin
4. ユーザーカスタム設定の適用
   └─ config.webpack(webpackConfig, context)
5. 最終検証
   └─ devtoolの検証（開発モード）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ベース設定構築]
    B --> C{コンパイラタイプ}
    C -->|client| D[クライアント固有設定]
    C -->|server| E[サーバー固有設定]
    C -->|edge-server| F[エッジ固有設定]
    D --> G[プラグイン追加]
    E --> G
    F --> G
    G --> H{webpack関数あり?}
    H -->|Yes| I[ユーザーカスタム設定適用]
    H -->|No| J[最終検証]
    I --> J
    J --> K[webpack.Configuration返却]
    K --> L[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-86-01 | マルチコンパイル | client、server、edge-serverの3コンパイル構成 | ビルド時 |
| BR-86-02 | SWC優先 | SWCローダーがデフォルト、Babel設定ファイル存在時のみBabelフォールバック | トランスパイル時 |
| BR-86-03 | React Refresh | 開発モードのクライアントコンパイルでReact Refreshを有効化 | dev=true, client |
| BR-86-04 | devtool制限 | 開発モードではdevtoolの変更は性能低下のため警告付きで復元 | dev=true |
| BR-86-05 | レイヤー分離 | WEBPACK_LAYERSでサーバー/クライアント/エッジのコード分離 | 全コンパイル |
| BR-86-06 | 外部パッケージ制御 | serverExternalPackagesとbundlePagesRouterDependenciesで制御 | サーバーコンパイル |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベースに対する操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | React 18未満の使用 | React 18.2.0以上をインストール |
| - | Warning | 開発モードでdevtoolの変更 | devtool設定を削除する |
| - | WellKnownError | 既知のWebpackエラー（モジュール未発見等） | WellKnownErrorsPluginでわかりやすいメッセージに変換 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- 開発モードでは`watchOptions.aggregateTimeout: 5`でファイル変更の集約を最小化
- `MemoryWithGcCachePlugin`でメモリキャッシュのGCを管理
- `webpackBuildWorker`で別プロセスでのビルド実行が可能
- `webpackMemoryOptimizations`でメモリ使用量の最適化が可能

## セキュリティ考慮事項

- SubresourceIntegrityPluginでスクリプトのSRIハッシュを生成可能
- サーバーサイドコードがクライアントバンドルに含まれないようレイヤー分離

## 備考

- Turbopackが有効な場合、本Webpack設定は使用されない
- Rspackモードではwebpack互換のRspack設定が生成される
- `getWebpackBundler`でWebpack/Rspackの切り替えが行われる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config-shared.ts | `packages/next/src/server/config-shared.ts` | **219-249行目**: `WebpackConfigContext`、`NextJsWebpackConfig`インターフェース |
| 1-2 | constants.ts | `packages/next/src/shared/lib/constants.ts` | `COMPILER_NAMES`定数（client, server, edge-server） |
| 1-3 | constants.ts | `packages/next/src/lib/constants.ts` | `WEBPACK_LAYERS`定数（レイヤー名定義） |

**読解のコツ**: Webpack設定はコンパイラタイプ（client/server/edge-server）とレイヤー（WEBPACK_LAYERS）の2軸で構造化されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | webpack-config.ts | `packages/next/src/build/webpack-config.ts` | メインのWebpack設定生成関数 |

**主要処理フロー**:
1. **1-99行目**: インポートと依存モジュール（多数のプラグイン、ユーティリティ）
2. **106-111行目**: EXTERNAL_PACKAGES、DEFAULT_TRANSPILED_PACKAGESの読み込み
3. **120-125行目**: babelIncludeRegexes（トランスパイル対象の正規表現）
4. **146-151行目**: watchOptionsの定義（開発モード用）
5. **186-199行目**: React Refresh設定

#### Step 3: プラグインの役割を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | webpack-config.ts | `packages/next/src/build/webpack-config.ts` | プラグイン群のインポート（38-68行目）で各プラグインの役割を把握 |

### プログラム呼び出し階層図

```
next build / next dev
    |
    +-- getBaseWebpackConfig(dir, config, compilerType)
    |       |
    |       +-- createWebpackAliases()         # resolve aliases
    |       +-- createVendoredReactAliases()    # React aliases
    |       +-- makeExternalHandler()           # externals設定
    |       +-- buildConfiguration()            # ルール設定
    |       +-- getDefineEnv()                  # 環境変数Define
    |       |
    |       +-- [Plugins]
    |       |   +-- BuildManifestPlugin
    |       |   +-- ClientReferenceManifestPlugin
    |       |   +-- NextFlightClientEntryPlugin
    |       |   +-- MiddlewarePlugin
    |       |   +-- PagesManifestPlugin
    |       |   +-- ReactLoadablePlugin
    |       |   +-- WellKnownErrorsPlugin
    |       |   +-- NextFontManifestPlugin
    |       |   +-- SubresourceIntegrityPlugin
    |       |
    |       +-- config.webpack(webpackConfig, context)  # ユーザーカスタム
    |
    +-- webpack.compile()                              # ビルド実行
```

### データフロー図

```
[入力]                    [処理]                          [出力]

ソースファイル ────────▶ SWC/Babelローダー ─────▶ トランスパイル済みJS
CSSファイル ──────────▶ PostCSS/cssローダー ───▶ 最適化CSS
画像・フォント ───────▶ アセットローダー ──────▶ 最適化アセット
                              |
NextConfigComplete ───▶ getBaseWebpackConfig() ▶ webpack.Configuration
                              |
                         webpack.compile() ────▶ .next/ディレクトリ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| webpack-config.ts | `packages/next/src/build/webpack-config.ts` | ソース | Webpack設定生成のメインモジュール |
| entries.ts | `packages/next/src/build/entries.ts` | ソース | エントリーポイントの構築 |
| create-compiler-aliases.ts | `packages/next/src/build/create-compiler-aliases.ts` | ソース | resolveエイリアスの構築 |
| handle-externals.ts | `packages/next/src/build/handle-externals.ts` | ソース | externals設定の構築 |
| define-env.ts | `packages/next/src/build/define-env.ts` | ソース | DefinePlugin用環境変数 |
| build-manifest-plugin.ts | `packages/next/src/build/webpack/plugins/build-manifest-plugin.ts` | ソース | ビルドマニフェスト生成 |
| flight-manifest-plugin.ts | `packages/next/src/build/webpack/plugins/flight-manifest-plugin.ts` | ソース | RSCクライアント参照マニフェスト |
| middleware-plugin.ts | `packages/next/src/build/webpack/plugins/middleware-plugin.ts` | ソース | ミドルウェアバンドル処理 |
| config/blocks/css.ts | `packages/next/src/build/webpack/config/blocks/css.ts` | ソース | CSS処理ルール |
| next-swc-loader.ts | `packages/next/src/build/webpack/loaders/next-swc-loader.ts` | ソース | SWCローダー |
