# 機能設計書 87-Turbopack統合

## 概要

本ドキュメントは、Next.jsにおけるRustベースの高速バンドラTurbopackとの統合に関する機能設計書である。開発時の高速ビルド・HMR、およびプロダクションビルドのTurbopackサポートを提供する。

### 本機能の処理概要

**業務上の目的・背景**：Webpackベースのビルドは大規模プロジェクトで遅延が発生することがある。Turbopackは Rustで実装された高速バンドラであり、特に開発時のHMR性能を大幅に改善する。Next.jsはTurbopackをネイティブに統合し、`next dev --turbopack`や`next build --turbopack`で利用可能にしている。

**機能の利用シーン**：`next dev --turbopack`（開発モード）または`next build`（Turbopackデフォルト有効時）に使用される。開発者はnext.config.jsの`turbopack`設定でカスタムローダー、resolveエイリアス、resolve拡張子を設定できる。

**主要な処理内容**：
1. SWCネイティブバインディングを通じたTurbopackプロジェクトの作成
2. TurbopackOptions設定の解決（resolveAlias、resolveExtensions、rules）
3. ファイルシステムキャッシュの管理（dev/build）
4. Turbopackエントリーポイントの設定とルート解決
5. HMRアップデートのストリーミング配信
6. Turbopack固有の実験的オプション（ツリーシェイキング、スコープホイスティング等）の制御

**関連システム・外部連携**：SWCネイティブバインディング（Rust実装）、next-swcパッケージ、Turbopackコア

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 14 | DevToolsメニュー (Panel Selector) | 補助機能 | Turbopack有効時のバンドラー情報表示 |

## 機能種別

ビルド処理 / コード変換 / 開発ツール

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| turbopack.resolveAlias | Record<string, string\|string[]> | No | モジュール解決エイリアス | - |
| turbopack.resolveExtensions | string[] | No | モジュール解決拡張子 | - |
| turbopack.rules | Record<string, TurbopackRuleConfigCollection> | No | カスタムローダールール | グロブパターン -> ルール設定 |
| turbopack.root | string | No | プロジェクトルートディレクトリ | - |
| experimental.turbopackFileSystemCacheForDev | boolean | No | 開発用ファイルシステムキャッシュ（デフォルト: true） | - |
| experimental.turbopackFileSystemCacheForBuild | boolean | No | ビルド用ファイルシステムキャッシュ（デフォルト: false） | - |

### 入力データソース

- `next.config.js`の`turbopack`設定
- `next.config.js`の`experimental.turbopack*`設定
- SWCネイティブバインディング

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TurbopackProject | object | Turbopackプロジェクトインスタンス |
| WrittenEndpoint | object | ビルドされたエンドポイント情報 |
| HMR Updates | stream | HMRアップデートストリーム |

### 出力先

- `.next/` ディレクトリ配下（ビルド成果物）
- 開発サーバーのWebSocket接続（HMRアップデート）

## 処理フロー

### 処理シーケンス

```
1. SWCバインディングの読み込み
   └─ loadBindings() でネイティブバインディングまたはWASMを読み込み
2. TurbopackProjectの作成
   └─ バインディングを通じてRust側のTurbopackプロジェクトを初期化
   └─ DefineEnv、ProjectOptions等の設定を渡す
3. エントリーポイントの設定
   └─ ページ・API・App Routerルートをエントリーポイントとして登録
4. ビルド/HMR実行
   └─ 開発モード: ファイル変更検知 -> インクリメンタルビルド -> HMR配信
   └─ ビルドモード: 全エントリーポイントのフルビルド
5. 成果物の書き込み
   └─ WrittenEndpoint情報に基づきファイルシステムに出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[SWCバインディング読み込み]
    B --> C[TurbopackProject作成]
    C --> D[エントリーポイント設定]
    D --> E{実行モード}
    E -->|dev| F[ファイル変更検知]
    F --> G[インクリメンタルビルド]
    G --> H[HMR配信]
    H --> F
    E -->|build| I[フルビルド実行]
    I --> J[成果物書き込み]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-87-01 | ネイティブバインディング優先 | ネイティブSWCバインディングを優先、失敗時WASMフォールバック | バインディング読み込み時 |
| BR-87-02 | Webpackローダー互換 | turbopack.rulesでWebpackローダーの使用が可能 | rules設定時 |
| BR-87-03 | モジュールタイプ | asset/ecmascript/typescript/css/css-module/wasm/raw/node/bytes | rules設定時 |
| BR-87-04 | ファイルシステムキャッシュ | 開発はデフォルト有効、ビルドはデフォルト無効 | キャッシュ設定時 |
| BR-87-05 | debugIds | バンドルとソースマップにデバッグIDを生成（TC39提案準拠） | debugIds設定時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベースに対する操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | SWCバインディングの読み込み失敗 | プラットフォーム対応のバインディングをインストール |
| - | Error | バインディングバージョン不一致 | Next.jsとSWCのバージョンを合わせる |
| - | TurbopackInternalError | Turbopack内部エラー | エラーメッセージに基づき対応 |

### リトライ仕様

バインディング読み込みにおいて、ネイティブ失敗時にWASMフォールバックが自動的に試行される。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- Turbopackは開発時のHMRを数十ミリ秒で処理することを目標としている
- ファイルシステムキャッシュにより2回目以降の起動が高速化
- turbopackMemoryLimitでメモリ使用量の上限を設定可能

## セキュリティ考慮事項

- バインディングの整合性チェック（バージョン一致確認）が行われる

## 備考

- Turbopackは継続的に開発中であり、実験的機能が多い
- `sassOptions.functions`はTurbopackではサポートされない
- `TURBOPACK`環境変数でTurbopack有効/無効が制御される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config-shared.ts | `packages/next/src/server/config-shared.ts` | **96-217行目**: `TurbopackOptions`、`TurbopackRuleConfigCollection`、`TurbopackModuleType`等の型定義 |
| 1-2 | types.ts | `packages/next/src/build/swc/types.ts` | Turbopack関連の内部型定義（ProjectOptions、Endpoint、Route等） |
| 1-3 | generated-native.d.ts | `packages/next/src/build/swc/generated-native.d.ts` | ネイティブバインディングの型定義 |

**読解のコツ**: `TurbopackRuleConfigCollection`は単一オブジェクトまたはローダーアイテム/設定オブジェクトの配列のunion型。`TurbopackRuleCondition`は再帰的な条件マッチング型。

#### Step 2: SWCバインディングとTurbopack統合を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.ts | `packages/next/src/build/swc/index.ts` | **197-269行目**: `loadBindings`関数でネイティブ/WASMバインディングの読み込みとフォールバック |
| 2-2 | index.ts | `packages/next/src/build/swc/index.ts` | **131-139行目**: バージョン不一致チェック |

**主要処理フロー**:
- **96-120行目**: プラットフォーム別のサポートトリプル判定
- **146-154行目**: WASM優先フォールバック対象プラットフォーム
- **208-214行目**: Rustスタックサイズの設定（デフォルト8MB）
- **228-269行目**: ネイティブバインディング試行 -> WASMフォールバック

#### Step 3: Turbopack設定オプションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | config-shared.ts | `packages/next/src/server/config-shared.ts` | **179-217行目**: `TurbopackOptions`（resolveAlias, resolveExtensions, rules, root, debugIds） |
| 3-2 | config-shared.ts | `packages/next/src/server/config-shared.ts` | **463-564行目**: Turbopack関連の実験的設定オプション群 |

### プログラム呼び出し階層図

```
next dev --turbopack / next build
    |
    +-- loadBindings()                    # SWCバインディング読み込み
    |       +-- loadNative()              # ネイティブバインディング試行
    |       +-- loadWasm()                # WASMフォールバック
    |
    +-- bindings.turbo.createProject()    # Turbopackプロジェクト作成
    |       +-- ProjectOptions設定
    |       +-- DefineEnv設定
    |
    +-- project.entrypointsSubscribe()    # エントリーポイント監視
    |
    +-- endpoint.writeToDisk()            # 成果物書き込み
    |
    +-- project.hmrEvents()              # HMRイベント配信（dev）
```

### データフロー図

```
[入力]                    [処理]                          [出力]

next.config.js ────────▶ TurbopackOptions解決 ──┐
turbopack設定              |                     |
                          ├──▶ Turbopackプロジェクト ──▶ ビルド成果物
ソースファイル ────────────┤                            (.next/)
                          └──▶ HMRストリーム ──────▶ WebSocket
                                                   (開発モード)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.ts | `packages/next/src/build/swc/index.ts` | ソース | SWCバインディング読み込み・Turbopack統合 |
| types.ts | `packages/next/src/build/swc/types.ts` | ソース | Turbopack関連型定義 |
| generated-native.d.ts | `packages/next/src/build/swc/generated-native.d.ts` | 型定義 | ネイティブバインディングの型 |
| config-shared.ts | `packages/next/src/server/config-shared.ts` | ソース | TurbopackOptions、実験的設定の型定義 |
| turbopack/ | `turbopack/` | ソース | Turbopackコア（Rust実装、git subtree） |
| hot-reloader-turbopack.ts | `packages/next/src/server/dev/hot-reloader-turbopack.ts` | ソース | Turbopack HMR統合 |
