# 機能設計書 88-Rspack統合

## 概要

本ドキュメントは、Next.jsにおけるRspackバンドラとの統合サポートに関する機能設計書である。`next-rspack`パッケージを通じて、WebpackのドロップインリプレースメントとしてRspackをNext.jsで使用可能にする。

### 本機能の処理概要

**業務上の目的・背景**：RspackはRustで実装されたWebpack互換の高速バンドラである。Webpackとの高い互換性を維持しつつ、Rustの性能によりビルド速度を大幅に改善する。Next.jsはRspackを代替バンドラとして統合し、`next-rspack`パッケージのラッパー関数を通じて有効化する仕組みを提供する。

**機能の利用シーン**：開発者が`next-rspack`パッケージをインストールし、`next.config.js`で`withRspack`関数をラップすることでRspackが有効化される。既存のWebpack設定との互換性を維持しつつ、ビルド速度の向上が期待できる。

**主要な処理内容**：
1. `withRspack`関数によるRspack有効化（環境変数`NEXT_RSPACK`の設定）
2. Turbopackフラグとの排他制御
3. Rspackバリデーション設定（`RSPACK_CONFIG_VALIDATE=loose-silent`）
4. Webpack互換のビルド設定生成（webpack-config.tsの`getWebpackBundler`で切り替え）
5. Rspack固有のプラグイン（`RspackFlightClientEntryPlugin`等）の使用

**関連システム・外部連携**：`@next/rspack-core`パッケージ、Rspackバンドラ本体

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は画面を持たないビルドパイプライン機構である |

## 機能種別

ビルド処理 / 設定管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| config | NextConfig | Yes | Next.js設定オブジェクト | - |

### 入力データソース

- `next.config.js`での`withRspack(config)`ラッパー適用
- `TURBOPACK`環境変数（`auto`であること）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| NextConfig | object | そのまま返却される設定オブジェクト（環境変数設定のみ副作用） |

### 出力先

- 環境変数（`NEXT_RSPACK=true`、`RSPACK_CONFIG_VALIDATE=loose-silent`）

## 処理フロー

### 処理シーケンス

```
1. withRspack関数の呼び出し
   └─ next.config.jsでconfigをラップ
2. 環境変数チェック
   └─ NEXT_RSPACKが既にセットされている場合はスキップ（二重呼び出し防止）
   └─ TURBOPACK=autoでない場合はエラー（--turbopackフラグとの排他）
3. 環境変数設定
   └─ TURBOPACK環境変数を削除
   └─ RSPACK_CONFIG_VALIDATE=loose-silentを設定
   └─ NEXT_RSPACK=trueを設定
4. 設定オブジェクトをそのまま返却
```

### フローチャート

```mermaid
flowchart TD
    A[withRspack呼び出し] --> B{NEXT_RSPACK設定済み?}
    B -->|Yes| C[configをそのまま返却]
    B -->|No| D{TURBOPACK=auto?}
    D -->|Yes| E[TURBOPACK削除]
    E --> F[RSPACK_CONFIG_VALIDATE設定]
    F --> G[NEXT_RSPACK=true設定]
    G --> C
    D -->|No| H[エラー: 複数バンドラ設定]
    H --> I[process.exit]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-88-01 | バンドラ排他制御 | Rspackと--turbopackフラグは同時に使用不可 | withRspack使用時 |
| BR-88-02 | 二重呼び出し防止 | ビルドワーカーで再呼び出しされた場合はスキップ | NEXT_RSPACK設定済み時 |
| BR-88-03 | バリデーション緩和 | Rspack使用時はloose-silentモードでバリデーション | Rspack有効時 |
| BR-88-04 | Webpack互換 | webpack-config.tsの設定をそのまま利用、一部プラグインをRspack版に差し替え | Rspack有効時 |

### 計算ロジック

特になし。

## データベース操作仕様

本機能はデータベースに対する操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | withRspackと--turbopackフラグの同時使用 | いずれかを削除する |
| - | Error | withRspackと--webpackフラグの同時使用 | いずれかを削除する |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

Rspackにより、Webpackと比較してビルド速度が大幅に改善される（Rust実装による）。

## セキュリティ考慮事項

特になし。

## 備考

- Rspack統合は比較的新しい機能であり、Webpackとの完全な互換性は保証されない場合がある
- `@next/rspack-core`パッケージ（バージョン1.0.2）が依存として必要
- `getWebpackBundler`関数でWebpack/Rspackの実行時切り替えが行われる
- Rspack固有のプラグイン（`RspackFlightClientEntryPlugin`、`RspackProfilingPlugin`）が存在する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.d.ts | `packages/next-rspack/index.d.ts` | **1-5行目**: `NextPluginRspack`型（NextConfig -> NextConfig関数） |
| 1-2 | package.json | `packages/next-rspack/package.json` | **9-11行目**: `@next/rspack-core`依存 |

**読解のコツ**: Rspack統合は非常にシンプルなラッパー関数であり、実質的な処理は環境変数の設定のみ。ビルド時のRspack切り替えはwebpack-config.ts内の`getWebpackBundler`で行われる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.js | `packages/next-rspack/index.js` | **1-20行目**: `withRspack`関数の全実装 |

**主要処理フロー**:
1. **3-5行目**: `NEXT_RSPACK`設定済みチェック（二重呼び出し防止）
2. **7-8行目**: `TURBOPACK=auto`チェック（バンドラ排他制御）
3. **8-10行目**: 環境変数設定（TURBOPACK削除、RSPACK設定、NEXT_RSPACK設定）
4. **12-18行目**: エラー処理（--turbopack/--webpackフラグとの排他エラー）

#### Step 3: Webpack設定内でのRspack切り替えを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | webpack-config.ts | `packages/next/src/build/webpack-config.ts` | **94行目**: `getWebpackBundler`のインポート |
| 3-2 | webpack-config.ts | `packages/next/src/build/webpack-config.ts` | **181-184行目**: `getReactRefreshLoader`でRspack対応ローダーの切り替え |
| 3-3 | get-rspack.ts | `packages/next/src/shared/lib/get-rspack.ts` | Rspackコアの取得関数 |

### プログラム呼び出し階層図

```
next.config.js
    |
    +-- withRspack(config)                # Rspack有効化ラッパー
    |       +-- 環境変数設定
    |           NEXT_RSPACK=true
    |           RSPACK_CONFIG_VALIDATE=loose-silent
    |
    +-- next build / next dev
            |
            +-- getWebpackBundler()       # Webpack/Rspack切り替え
            |       +-- getRspackCore()   # Rspackコア取得（NEXT_RSPACK時）
            |
            +-- webpack-config.ts
                    +-- RspackFlightClientEntryPlugin  # Rspack固有プラグイン
                    +-- RspackProfilingPlugin           # Rspack固有プラグイン
                    +-- getReactRefreshLoader()         # builtin:react-refresh-loader
```

### データフロー図

```
[入力]                    [処理]                          [出力]

next.config.js ────────▶ withRspack() ─────────────▶ NextConfig
                          |                             (環境変数設定)
                          |
NEXT_RSPACK=true ──────▶ getWebpackBundler() ──────▶ Rspackインスタンス
                          |
ソースファイル ────────▶ Rspackビルド ──────────────▶ .next/ディレクトリ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.js | `packages/next-rspack/index.js` | ソース | withRspack関数の実装 |
| index.d.ts | `packages/next-rspack/index.d.ts` | 型定義 | NextPluginRspack型定義 |
| rspack-core.js | `packages/next-rspack/rspack-core.js` | ソース | Rspackコアの再エクスポート |
| package.json | `packages/next-rspack/package.json` | 設定 | パッケージ定義・依存関係 |
| get-rspack.ts | `packages/next/src/shared/lib/get-rspack.ts` | ソース | Rspackコアの取得関数 |
| get-webpack-bundler.ts | `packages/next/src/shared/lib/get-webpack-bundler.ts` | ソース | Webpack/Rspack切り替え |
| rspack-flight-client-entry-plugin.ts | `packages/next/src/build/webpack/plugins/rspack-flight-client-entry-plugin.ts` | ソース | Rspack固有のFlight Client Entryプラグイン |
| rspack-profiling-plugin.ts | `packages/next/src/build/webpack/plugins/rspack-profiling-plugin.ts` | ソース | Rspack固有のプロファイリングプラグイン |
