# 機能設計書 94-DevTools（開発者ツール）

## 概要

本ドキュメントは、Next.jsのDevTools（開発者ツール）機能の設計について記述する。DevToolsは開発モード時にブラウザ上に表示される統合開発支援UIであり、エラー表示、ルート情報、コンパイル状態、設定パネルなどの機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：開発者がNext.jsアプリケーションを開発する際、コンパイルエラー・ランタイムエラー・ルート情報・パフォーマンス情報を即座に確認できる環境が必要である。DevToolsはこれらの情報をブラウザ上のオーバーレイUIとして統合的に提供し、開発効率を向上させる。

**機能の利用シーン**：
- `next dev` で開発サーバーを起動中にブラウザ上でDevToolsインジケーター（Next.jsロゴ）を操作する場合
- エラー発生時にオーバーレイでエラー詳細を確認する場合
- ルート情報パネルでStatic/Dynamicルートの判定結果を確認する場合
- セグメントエクスプローラーでApp Routerのセグメントツリーを視覚的に確認する場合
- ユーザー設定パネルでテーマ・表示位置・スケールなどをカスタマイズする場合

**主要な処理内容**：
1. DevToolsインジケーター（フローティングNext.jsロゴボタン）の表示・ドラッグ制御
2. パネルルーター（PanelRouter）によるメニュー・パネルの遷移管理
3. ErrorOverlayコンポーネントによるビルドエラー・ランタイムエラーの表示
4. ShadowPortalを使用したホストページスタイルからの隔離
5. サーバーミドルウェアによるDevTools設定API・フォントAPI・エディタ連携

**関連システム・外部連携**：HMR（Hot Module Replacement）インフラ、Webpackコンパイラ、エディタ連携（launch-editor）、開発サーバーWebSocket。

**権限による制御**：DevToolsは開発モード（`next dev`）でのみ有効化される。本番環境では一切のDevToolsコードが含まれない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | 開発オーバーレイ (Dev Overlay) | 主機能 | 開発モード時のエラー表示・DevToolsインジケーター・パネルルーターを含む統合開発支援UIの表示 |
| 13 | DevToolsインジケーター | 主機能 | 画面隅のフローティングNext.jsロゴボタンの表示・ドラッグ移動処理 |
| 14 | DevToolsメニュー (Panel Selector) | 主機能 | Issues数・ルート種別・バンドラー情報・Route Info・Preferencesへのリンクを表示するメニュー |
| 17 | ルート情報パネル (Route Type) | 主機能 | 現在のルートがStatic/Dynamicかの詳細表示 |
| 18 | セグメントエクスプローラー (Route Info) | 主機能 | App Routerセグメントツリーのビジュアル表示処理 |
| 19 | ユーザー設定パネル (Preferences) | 主機能 | DevToolsのテーマ・表示位置・スケール等の設定変更処理 |

## 機能種別

UI表示 / 状態管理 / サーバー連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| state | OverlayState | Yes | オーバーレイの現在状態（エラー情報、ビルドエラー、showIndicator等） | - |
| dispatch | Dispatch | Yes | 状態更新用ディスパッチャ | - |
| runtimeErrors | ReadyRuntimeError[] | Yes | ランタイムエラーの配列 | - |
| versionInfo | object | Yes | Next.jsバージョン情報 | - |

### 入力データソース

HMR WebSocketを通じたサーバーからのメッセージ、ブラウザのランタイムエラー捕捉、React Error Boundary。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| DevOverlay UI | React Component | Shadow DOM内にレンダリングされるDevTools UI |
| DevTools設定 | JSON | ユーザー設定（テーマ、位置、スケール等） |

### 出力先

ブラウザ上のShadow DOM（ホストページのスタイルから隔離）。

## 処理フロー

### 処理シーケンス

```
1. DevOverlayコンポーネントのマウント
   └─ ShadowPortal内にコンポーネントツリーを構築
2. 状態の初期化
   └─ パネル状態（null）、選択インデックス（-1）を初期化
3. RenderErrorコンポーネントによるエラー集計
   └─ stateからランタイムエラーとトータルエラー数を算出
4. UIコンポーネントのレンダリング
   └─ showIndicatorがtrueの場合のみ表示
5. ユーザー操作の処理
   └─ パネル遷移、エラーナビゲーション、設定変更
```

### フローチャート

```mermaid
flowchart TD
    A[DevOverlay マウント] --> B[ShadowPortal 作成]
    B --> C[ScaleUpdater + ComponentStyles]
    C --> D[RenderError でエラー集計]
    D --> E{showIndicator?}
    E -->|Yes| F[DevToolsIndicator 表示]
    E -->|No| G[非表示]
    F --> H[PanelRouter 有効化]
    H --> I{エラーあり?}
    I -->|Yes| J[ErrorOverlay 表示]
    I -->|No| K[通常表示]
    J --> L[ユーザー操作待ち]
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 開発モード限定 | DevToolsは `next dev` 実行時のみ有効 | 常時 |
| BR-02 | Shadow DOM隔離 | DevTools UIはShadowPortal内にレンダリングされ、ホストページのCSSから隔離される | 常時 |
| BR-03 | インジケーター表示制御 | showIndicator が false の場合、全てのDevTools UIが非表示になる | ユーザー設定に依存 |
| BR-04 | App Dirのみ対応 | DevOverlayは `isAppDir={true}` で固定 | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ビルドエラー | Webpack/Turbopackのコンパイルエラー | BuildErrorコンポーネントでターミナル風表示 |
| - | ランタイムエラー | ブラウザでの実行時エラー | RuntimeErrorコンポーネントでスタックトレース表示 |
| - | ハイドレーションエラー | SSRとCSRの出力不一致 | PseudoHtmlDiffで差分表示 |

### リトライ仕様

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- DevTools UIはShadow DOM内に隔離されているため、ホストページのパフォーマンスへの影響を最小化
- ScaleUpdaterによるCSSカスタムプロパティ制御でレスポンシブ対応

## セキュリティ考慮事項

- DevToolsは開発モードでのみ動作し、本番ビルドには含まれない
- エディタ連携（launch-editor）はローカル開発環境でのみ使用される
- DevTools設定APIは `/_next/` パス配下で提供され、開発サーバー内部通信として扱われる

## 備考

- DevToolsはReactコンポーネントベースで構築されており、Storybookによるコンポーネント開発もサポートされている
- `dev-overlay.shim.ts` により、DevToolsが無効な環境ではシムモジュールが使用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.ts | `packages/next/src/next-devtools/shared/types.ts` | DebugInfo型の構造を理解する |
| 1-2 | shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | OverlayState等の共有状態型を理解する |
| 1-3 | devtools-config-schema.ts | `packages/next/src/next-devtools/shared/devtools-config-schema.ts` | DevTools設定スキーマ |

**読解のコツ**: DevToolsのUIはReactのuseState/useContext/useRefを多用するReact SPA構造。PanelRouterContextが画面遷移の中核を担う。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | entrypoint.ts | `packages/next/src/next-devtools/entrypoint.ts` | DevToolsのエントリーポイント。CSS importとdev-overlay.browserのre-export |
| 2-2 | dev-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/dev-overlay.tsx` | DevOverlayコンポーネントのメイン構成 |

**主要処理フロー**:
1. **1-3行目** (entrypoint.ts): グローバルCSSの読み込みとブラウザモジュールのエクスポート
2. **20-71行目** (dev-overlay.tsx): DevOverlay関数コンポーネントの全体構成。ShadowPortal > ScaleUpdater > ComponentStyles > RenderError > ErrorOverlay + PanelRouter + DevToolsIndicator の階層

#### Step 3: サーバーミドルウェアを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | dev-indicator-middleware.ts | `packages/next/src/next-devtools/server/dev-indicator-middleware.ts` | DevToolsインジケーターの表示/非表示制御API |
| 3-2 | devtools-config-middleware.ts | `packages/next/src/next-devtools/server/devtools-config-middleware.ts` | DevTools設定の取得/保存API |
| 3-3 | launch-editor.ts | `packages/next/src/next-devtools/server/launch-editor.ts` | エディタ連携（ファイルをエディタで開く） |

### プログラム呼び出し階層図

```
entrypoint.ts
    └─ dev-overlay.browser.ts
           └─ DevOverlay (dev-overlay.tsx:20)
                  │
                  ├─ ShadowPortal (shadow-portal.tsx)
                  │      └─ Shadow DOM 作成
                  │
                  ├─ ScaleUpdater (scale-updater.tsx)
                  ├─ ComponentStyles (component-styles.tsx)
                  │
                  ├─ RenderError (render-error.tsx)
                  │      └─ エラー集計
                  │
                  ├─ ErrorOverlay (error-overlay.tsx)
                  │      ├─ BuildError (build-error.tsx)
                  │      └─ Errors (errors.tsx)
                  │
                  ├─ PanelRouter (panel-router.tsx)
                  │
                  └─ DevToolsIndicator (devtools-indicator.tsx)
                         └─ NextLogo (next-logo.tsx)
```

### データフロー図

```
[入力]                        [処理]                      [出力]

HMR WebSocket ──────▶ useDevOverlayContext ──▶ state (OverlayState)
(サーバーからの                                         │
 エラー/ステータス)                                     ▼
                            DevOverlay ──────▶ Shadow DOM UI
ブラウザエラー ──────▶ RenderError ──────────▶ runtimeErrors[]
                                                        │
ユーザー操作 ───────▶ PanelRouter ──────────▶ パネル遷移
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| entrypoint.ts | `packages/next/src/next-devtools/entrypoint.ts` | ソース | DevToolsエントリーポイント |
| dev-overlay.tsx | `packages/next/src/next-devtools/dev-overlay/dev-overlay.tsx` | ソース | DevOverlayメインコンポーネント |
| dev-overlay.shim.ts | `packages/next/src/next-devtools/dev-overlay.shim.ts` | ソース | 無効環境用シム |
| shared.ts | `packages/next/src/next-devtools/dev-overlay/shared.ts` | ソース | 共有状態型定義 |
| shadow-portal.tsx | `packages/next/src/next-devtools/dev-overlay/components/shadow-portal.tsx` | ソース | Shadow DOM ポータル |
| devtools-indicator.tsx | `packages/next/src/next-devtools/dev-overlay/components/devtools-indicator/devtools-indicator.tsx` | ソース | DevToolsインジケーター |
| dev-indicator-middleware.ts | `packages/next/src/next-devtools/server/dev-indicator-middleware.ts` | ソース | インジケーター表示制御API |
| devtools-config-middleware.ts | `packages/next/src/next-devtools/server/devtools-config-middleware.ts` | ソース | 設定API |
| launch-editor.ts | `packages/next/src/next-devtools/server/launch-editor.ts` | ソース | エディタ連携 |
| segment-explorer-trie.ts | `packages/next/src/next-devtools/dev-overlay/segment-explorer-trie.ts` | ソース | セグメントエクスプローラーのトライ構造 |
