# 機能設計書 96-TypeScriptサポート

## 概要

本ドキュメントは、Next.jsのTypeScriptサポート機能の設計について記述する。本機能はTypeScript型チェック、tsconfig.json自動設定、型定義ファイル（next-env.d.ts）の自動生成、およびNext.js固有の型安全性を提供する。

### 本機能の処理概要

**業務上の目的・背景**：Next.jsプロジェクトでTypeScriptを使用する際、手動でのTypeScript設定は複雑でエラーを起こしやすい。本機能は、tsconfig.jsonの自動設定、必要な型定義ファイルの自動生成、およびビルド時の型チェックを統合することで、TypeScript開発の敷居を下げ、型安全性を保証する。

**機能の利用シーン**：
- TypeScriptファイル（.ts/.tsx）がプロジェクトに存在する場合の自動セットアップ
- `next build` 時の型チェック実行
- tsconfig.jsonへのNext.js推奨設定の自動書き込み
- next-env.d.tsの自動生成・更新
- App Router/Pages Routerの型安全なルーティング型定義の生成

**主要な処理内容**：
1. TypeScriptインテントの検出（tsconfig.json存在確認、.ts/.tsxファイル検索）
2. tsconfig.jsonへの推奨/必須コンパイラオプションの書き込み
3. next-env.d.tsの自動生成（triple-slash directives）
4. TypeScript型チェックの実行（インクリメンタルビルド対応）
5. 診断メッセージのフォーマットと出力
6. TypeScript依存パッケージの不足検出

**関連システム・外部連携**：TypeScriptコンパイラ（typescript パッケージ）、tsconfig.json。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | TypeScriptサポートは画面を持たないビルド時処理 |

## 機能種別

バリデーション / 設定生成 / コード解析

## 入力仕様

### 入力パラメータ

#### runTypeCheck

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| typescript | typeof import('typescript') | Yes | TypeScriptモジュール | - |
| baseDir | string | Yes | プロジェクトルートディレクトリ | 有効なパス |
| distDir | string | Yes | ビルド出力ディレクトリ | 有効なパス |
| tsConfigPath | string | Yes | tsconfig.jsonのパス | 有効なパス |
| cacheDir | string | No | インクリメンタルビルド用キャッシュディレクトリ | 有効なパス |
| isAppDirEnabled | boolean | No | App Directoryの有効フラグ | - |
| dirs | TypeCheckDirs | No | アプリケーションディレクトリパス（app, pages） | - |
| debugBuildPaths | DebugBuildPaths | No | デバッグビルド用パスフィルタ | - |

#### writeAppTypeDeclarations

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| baseDir | string | Yes | プロジェクトルート | 有効なパス |
| distDir | string | Yes | ビルド出力ディレクトリ | 有効なパス |
| imageImportsEnabled | boolean | Yes | 画像インポート型有効フラグ | - |
| hasPagesDir | boolean | Yes | pagesディレクトリ存在フラグ | - |
| hasAppDir | boolean | Yes | appディレクトリ存在フラグ | - |

### 入力データソース

tsconfig.json、プロジェクトのTypeScriptファイル群、Next.js設定。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TypeCheckResult | object | 型チェック結果（hasWarnings, warnings, inputFilesCount, totalFilesCount, incremental） |
| next-env.d.ts | ファイル | TypeScript型定義参照ファイル |
| tsconfig.json更新 | ファイル | 推奨設定が書き込まれたtsconfig.json |

### 出力先

プロジェクトルートディレクトリ（next-env.d.ts、tsconfig.json）。

## 処理フロー

### 処理シーケンス

```
1. TypeScriptインテント検出
   └─ tsconfig.jsonの存在確認、.ts/.tsxファイルの検索
2. tsconfig.json設定の書き込み
   └─ 推奨設定（suggested）と必須設定（required）をマージ
3. next-env.d.ts生成
   └─ triple-slash directives とルート型参照を生成
4. 型チェック実行
   └─ TypeScript Programの作成と診断の取得
5. 結果のフォーマット
   └─ エラー・警告メッセージの整形と出力
```

### フローチャート

```mermaid
flowchart TD
    A[TypeScriptファイル検出] --> B{tsconfig.json存在?}
    B -->|Yes| C[設定内容確認]
    B -->|No| D{.ts/.tsxファイル存在?}
    D -->|Yes| E[firstTimeSetup = true]
    D -->|No| F[TypeScript無効]
    C --> G[推奨/必須設定の書き込み]
    E --> G
    G --> H[next-env.d.ts生成]
    H --> I{インクリメンタル?}
    I -->|Yes| J[createIncrementalProgram]
    I -->|No| K[createProgram]
    J --> L[emit + getDiagnostics]
    K --> L
    L --> M{エラーあり?}
    M -->|Yes| N[CompileError送出]
    M -->|No| O[結果返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 必須コンパイラオプション | module, esModuleInterop, resolveJsonModule, isolatedModules, jsx は変更不可 | 常時 |
| BR-02 | 推奨コンパイラオプション | target, lib, allowJs, skipLibCheck, strict, noEmit, incremental は推奨値が設定される | 未設定時 |
| BR-03 | テストファイル除外 | __tests__, __mocks__, *.spec.*, *.test.* パターンに一致するファイルは型チェック対象外 | 型チェック時 |
| BR-04 | 開発用型定義フィルタ | .next/dev/types/ 配下のファイルはビルド時の型チェックから除外 | ビルド時 |
| BR-05 | 空tsconfig対応 | tsconfig.jsonが空または`{}`の場合、firstTimeSetupとして扱う | 初回セットアップ時 |
| BR-06 | TypeScript 5.4以上でPreserveモジュール | TS 5.4以上でmodule: 'preserve'が使用可能 | TS 5.4以上 |

### 計算ロジック

特になし。

## データベース操作仕様

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CompileError | TypeScript型チェックでエラーが検出された場合 | getFormattedDiagnosticでフォーマットしてビルドエラーとして送出 |
| - | MissingDependencyError | typescript パッケージが未インストール | インストール手順を含むエラーメッセージ表示 |
| - | Warning | TypeScript警告（DiagnosticCategory.Warning） | 警告メッセージとして出力、ビルドは継続 |

### リトライ仕様

リトライ不要。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- インクリメンタルビルド対応により、2回目以降の型チェックが高速化される
- .tsbuildinfo ファイルをcacheDirに保存してインクリメンタルコンパイルを実現

## セキュリティ考慮事項

- tsconfig.jsonの書き込みは推奨設定のみであり、ユーザー設定を上書きしない（必須設定は除く）
- next-env.d.tsの内容は安全なtriple-slash directivesのみ

## 備考

- next-env.d.tsには「このファイルを編集しないでください」という注意文が含まれる
- App RouterとPages Routerの両方が存在する場合、ナビゲーション互換型参照が追加される
- TypeScriptのcomposite projectは完全にはサポートされていない（警告表示あり）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | runTypeCheck.ts | `packages/next/src/lib/typescript/runTypeCheck.ts` | TypeCheckResult型（10-16行目）、TypeCheckDirs型（18-21行目）を理解する |
| 1-2 | getTypeScriptIntent.ts | `packages/next/src/lib/typescript/getTypeScriptIntent.ts` | TypeScriptIntent型（5行目）を理解する |

**読解のコツ**: TypeScriptのcreateProgram/createIncrementalProgramの違いを理解しておくと、インクリメンタルビルドのロジックが分かりやすい。

#### Step 2: TypeScriptインテント検出を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | getTypeScriptIntent.ts | `packages/next/src/lib/typescript/getTypeScriptIntent.ts` | tsconfig.json検出と.ts/.tsxファイル検索（7-42行目） |

**主要処理フロー**:
1. **12-23行目**: tsconfig.jsonの存在確認、空ファイル検出
2. **29-39行目**: intentDirs内での.ts/.tsxファイルの再帰検索

#### Step 3: 設定書き込みを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | writeConfigurationDefaults.ts | `packages/next/src/lib/typescript/writeConfigurationDefaults.ts` | getDesiredCompilerOptions関数（21行目〜）で推奨/必須設定を定義 |

**主要処理フロー**:
- **21-75行目**: getDesiredCompilerOptionsで全コンパイラオプションの推奨値・必須値を定義
- suggested: ユーザーが未設定の場合のみ適用
- parsedValue/value: 必須値として強制適用

#### Step 4: 型定義生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | writeAppTypeDeclarations.ts | `packages/next/src/lib/typescript/writeAppTypeDeclarations.ts` | next-env.d.tsの生成ロジック（5-89行目） |

**主要処理フロー**:
- **50-73行目**: triple-slash directives とルート型参照の組み立て
- **85-88行目**: 既存内容と同一なら書き込みスキップ（read-only FS対応）

#### Step 5: 型チェック実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | runTypeCheck.ts | `packages/next/src/lib/typescript/runTypeCheck.ts` | 型チェックのメインロジック（39-230行目） |

**主要処理フロー**:
1. **49-52行目**: getTypeScriptConfigurationでtsconfig解析
2. **61-66行目**: devTypesDir配下のファイルをフィルタ除外
3. **131-149行目**: インクリメンタル/通常のProgram作成分岐
4. **163-175行目**: 診断結果からエラー/警告を抽出
5. **205-215行目**: 最初のエラーをCompileErrorとして送出

### プログラム呼び出し階層図

```
next build (build/index.ts)
    │
    ├─ getTypeScriptIntent (getTypeScriptIntent.ts:7)
    │      └─ recursiveReadDir (.ts/.tsx検索)
    │
    ├─ writeConfigurationDefaults (writeConfigurationDefaults.ts)
    │      └─ getDesiredCompilerOptions
    │
    ├─ writeAppTypeDeclarations (writeAppTypeDeclarations.ts:5)
    │
    └─ runTypeCheck (runTypeCheck.ts:39)
           ├─ getTypeScriptConfiguration
           ├─ getRequiredConfiguration
           ├─ typescript.createProgram / createIncrementalProgram
           ├─ program.emit()
           ├─ getPreEmitDiagnostics
           └─ getFormattedDiagnostic (diagnosticFormatter.ts)
```

### データフロー図

```
[入力]                          [処理]                          [出力]

tsconfig.json ──────────▶ getTypeScriptIntent ──────▶ TypeScriptIntent
                                                            │
TypeScriptIntent ───────▶ writeConfigurationDefaults ▶ tsconfig.json更新
                                                            │
Next.js設定 ────────────▶ writeAppTypeDeclarations ──▶ next-env.d.ts
                                                            │
.ts/.tsxファイル群 ─────▶ runTypeCheck ──────────────▶ TypeCheckResult
                                │                          │
                                └─ diagnostics ───▶ CompileError / Warnings
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| runTypeCheck.ts | `packages/next/src/lib/typescript/runTypeCheck.ts` | ソース | TypeScript型チェック実行 |
| getTypeScriptIntent.ts | `packages/next/src/lib/typescript/getTypeScriptIntent.ts` | ソース | TypeScript利用意図の検出 |
| writeConfigurationDefaults.ts | `packages/next/src/lib/typescript/writeConfigurationDefaults.ts` | ソース | tsconfig.json推奨設定書き込み |
| writeAppTypeDeclarations.ts | `packages/next/src/lib/typescript/writeAppTypeDeclarations.ts` | ソース | next-env.d.ts生成 |
| getTypeScriptConfiguration.ts | `packages/next/src/lib/typescript/getTypeScriptConfiguration.ts` | ソース | tsconfig.json解析 |
| diagnosticFormatter.ts | `packages/next/src/lib/typescript/diagnosticFormatter.ts` | ソース | 診断メッセージフォーマット |
| missingDependencyError.ts | `packages/next/src/lib/typescript/missingDependencyError.ts` | ソース | 依存パッケージ不足エラー |
| type-paths.ts | `packages/next/src/lib/typescript/type-paths.ts` | ソース | 型定義パスユーティリティ |
