# 機能設計書 99-Codemods

## 概要

本ドキュメントは、Next.jsのCodemods機能の設計について記述する。Codemodsは、Next.jsのバージョンアップグレード時にコードの自動変換を行うツール群であり、APIの変更、非推奨機能の移行、新規推奨パターンへの書き換えを自動的に実行する。

### 本機能の処理概要

**業務上の目的・背景**：Next.jsのメジャーバージョンアップグレードでは、破壊的変更（breaking changes）が含まれることがある。大規模プロジェクトでこれらの変更を手動で適用するのは時間がかかりエラーの原因となる。Codemodsは、jscodeshiftを使用したAST（抽象構文木）ベースのコード変換により、安全かつ自動的にコードを移行する。

**機能の利用シーン**：
- Next.jsのメジャーバージョンアップグレード時（`@next/codemod upgrade`）
- 特定のコード変換を手動で適用する場合（`@next/codemod <transform-name> <path>`）
- AI向けドキュメントインデックスの生成（`@next/codemod agents-md`）

**主要な処理内容**：
1. `upgrade` コマンド - Next.jsバージョンのアップグレードと関連codemodの自動適用
2. `transform` コマンド - 特定のcodemod変換の手動適用
3. `agents-md` コマンド - AI向けNext.jsドキュメントインデックスの生成
4. jscodeshiftを使用したASTベースのコード変換実行
5. Git安全チェック（未コミットの変更の検出）

**関連システム・外部連携**：jscodeshift（ASTベースのコード変換ツール）、npm/pnpm/yarn（パッケージ管理）。

**権限による制御**：`--force` フラグによるGit安全チェックのバイパスが可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CodemodsはCLIツールであり画面を持たない |

## 機能種別

コード変換 / CLI操作

## 入力仕様

### 入力パラメータ

#### メインコマンド（transform）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| codemod | string | No | 適用するcodemod名 | TRANSFORMER_INQUIRER_CHOICESに含まれること |
| source | string | No | 対象ファイル/ディレクトリパス（glob対応） | 有効なパスまたはglob |
| --force, -f | boolean | No | Git安全チェックのバイパス | - |
| --dry, -d | boolean | No | ドライラン（変更なし） | - |
| --print, -p | boolean | No | 変換結果を標準出力に表示 | - |
| --verbose | boolean | No | 詳細ログ出力 | - |
| --jscodeshift, -j | string | No | jscodeshiftへの直接オプション | - |

#### upgradeサブコマンド

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| revision | string | No | アップグレード種別 | 'patch' \| 'minor' \| 'major' \| npm dist-tag \| 正確なバージョン |
| --verbose | boolean | No | 詳細ログ出力 | - |

#### agents-mdサブコマンド

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --version | string | No | Next.jsバージョン指定 | セマンティックバージョン |
| --output | string | No | 出力ファイルパス | 有効なパス |

### 入力データソース

プロジェクトのソースファイル（JavaScript/TypeScript）、package.json。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 変換済みソースファイル | file | codemod適用後のソースファイル |
| コンソール出力 | text | 変換結果のサマリー |
| CLAUDE.md / AGENTS.md | file | agents-mdコマンドの出力 |

### 出力先

プロジェクトのソースファイル（in-place変更）、標準出力。

## 処理フロー

### 処理シーケンス

```
1. CLIコマンド解析
   └─ Commander.jsによるコマンド・サブコマンド・オプション解析
2. Git安全チェック
   └─ 未コミットの変更がある場合はエラー（--forceでバイパス可能）
3. codemod選択
   └─ 引数指定またはインタラクティブプロンプトで選択
4. 対象ファイルパスの展開
   └─ globパターンの展開
5. jscodeshift実行
   └─ 選択されたtransformモジュールを使用してASTベースの変換を実行
6. 結果の表示
   └─ 変換件数・エラーのサマリー出力
```

### フローチャート

```mermaid
flowchart TD
    A[CLI起動] --> B{サブコマンド?}
    B -->|upgrade| C[runUpgrade]
    B -->|agents-md| D[runAgentsMd]
    B -->|transform/直接| E[runTransform]
    E --> F{--dry?}
    F -->|No| G[checkGitStatus]
    F -->|Yes| H[スキップ]
    G --> I{codemod指定?}
    H --> I
    I -->|Yes| J[transform検証]
    I -->|No| K[インタラクティブ選択]
    J --> L[jscodeshiftExec]
    K --> L
    L --> M[結果表示]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | Git安全チェック | 未コミットの変更がある場合、変換を中止 | --force未指定時 |
| BR-02 | ドライランモード | --dry指定時はファイルを変更せずに結果のみ表示 | --dry指定時 |
| BR-03 | codemod名検証 | 指定されたcodemod名がTRANSFORMER_INQUIRER_CHOICESに存在すること | transform実行時 |
| BR-04 | glob展開 | ファイルパスにワイルドカードが含まれる場合、globbyで展開 | パスに*を含む場合 |
| BR-05 | upgradeデフォルト | revision未指定時はminorアップグレードをデフォルトとする | upgradeコマンド |

### 計算ロジック

特になし。

## データベース操作仕様

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | BadInput | 不正な入力値 | エラーメッセージ表示、process.exit(1) |
| - | GitCheckError | 未コミットの変更あり | --forceオプションの使用を提案 |
| - | InvalidTransform | 存在しないcodemod名の指定 | 利用可能なcodemod一覧を表示 |

### リトライ仕様

リトライ不要。

## トランザクション仕様

該当なし（ファイルシステムへの直接書き込み。ロールバックはGitによる）。

## パフォーマンス要件

ファイル数に比例した処理時間。jscodeshiftはファイル単位で変換を行うため、大規模プロジェクトでも安定して動作する。

## セキュリティ考慮事項

- codemodsはソースファイルを直接変更するため、Git安全チェックにより未コミットの変更を保護
- --forceオプションは安全チェックをバイパスするため、使用時は注意が必要

## 備考

- codemodsはバージョン間の移行パスを提供するもので、全ての変更を自動化するわけではない
- agents-mdコマンドはAIコーディングエージェント（Claude、Cursor等）向けのドキュメントインデックス生成機能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | next-codemod.ts | `packages/next-codemod/bin/next-codemod.ts` | CLIのエントリーポイント。Commander.jsによるコマンド定義（12-104行目） |

**読解のコツ**: Commander.jsのcommand/argument/option/actionパターンを理解しておくとCLI構造が分かりやすい。`enablePositionalOptions()`によりサブコマンドのオプション位置が正しく処理される。

**主要処理フロー**:
1. **19-56行目**: メインコマンド（transform）の定義
2. **57-79行目**: upgradeサブコマンドの定義
3. **81-102行目**: agents-mdサブコマンドの定義
4. **104行目**: CLIの起動

#### Step 2: transform処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | transform.ts | `packages/next-codemod/bin/transform.ts` | runTransform関数の実装 |

**主要処理フロー**:
1. **25-31行目**: codemod名とパスの取得
2. **33-35行目**: Git安全チェック（--dry時はスキップ）
3. **37-46行目**: codemod名の検証
4. **48-80行目**: インタラクティブプロンプトによる選択

#### Step 3: upgrade処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | upgrade.ts | `packages/next-codemod/bin/upgrade.ts` | runUpgrade関数の実装 |

#### Step 4: 個別transformの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | transforms/ | `packages/next-codemod/transforms/` | 各codemod変換モジュールの実装 |

### プログラム呼び出し階層図

```
next-codemod.ts
    │
    ├─ runTransform (transform.ts:25)
    │      ├─ checkGitStatus (lib/utils.ts)
    │      ├─ prompts (インタラクティブ選択)
    │      ├─ expandFilePathsIfNeeded (globby)
    │      └─ execa (jscodeshift実行)
    │             └─ transforms/{name}.ts
    │
    ├─ runUpgrade (upgrade.ts)
    │      ├─ バージョン判定
    │      ├─ パッケージ更新 (installPackages)
    │      └─ 関連codemod適用
    │
    └─ runAgentsMd (agents-md.ts)
           └─ ドキュメントインデックス生成
```

### データフロー図

```
[入力]                          [処理]                          [出力]

CLI引数 ────────────────▶ Commander.js 解析 ────▶ コマンド分岐
                                │
ソースファイル ─────────▶ jscodeshift ──────────▶ 変換済みファイル
                                │
                                └─ transforms/*.ts ─▶ ASTベース変換

package.json ───────────▶ runUpgrade ──────────▶ 更新済みpackage.json
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| next-codemod.ts | `packages/next-codemod/bin/next-codemod.ts` | ソース | CLIエントリーポイント |
| transform.ts | `packages/next-codemod/bin/transform.ts` | ソース | transform実行ロジック |
| upgrade.ts | `packages/next-codemod/bin/upgrade.ts` | ソース | upgradeコマンド実行ロジック |
| agents-md.ts | `packages/next-codemod/bin/agents-md.ts` | ソース | agents-mdコマンド |
| shared.ts | `packages/next-codemod/bin/shared.ts` | ソース | 共有ユーティリティ（BadInput等） |
| transforms/ | `packages/next-codemod/transforms/` | ソース | 各codemod変換モジュール群 |
| lib/utils.ts | `packages/next-codemod/transforms/lib/utils.ts` | ソース | 変換ユーティリティ |
