---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：101-デバッグ・ログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **DEBUG=next:*の詳細なログ内容**：デバッグログの具体的な出力フォーマットの根拠が不足

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/dev/log-requests.ts` - リクエストログ出力のメイン実装
- E-02: `packages/next/src/server/dev/server-action-logger.ts` - Server Actionログフォーマット
- E-03: `packages/next/src/server/config-shared.ts` - LoggingConfig型定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | logRequests関数がエントリーポイントである | E-01 (43行目) | ○ |
| C-02 | ignoreLoggingIncomingRequestsがフィルタリングを行う | E-01 (22-41行目) | ○ |
| C-03 | ステータスコードが5段階で色分けされる | E-01 (97-106行目) | ○ |
| C-04 | RSCリクエストのURLからクエリが除去される | E-01 (94-95行目) | ○ |
| C-05 | compile/middleware/render時間の内訳が計算される | E-01 (112-138行目) | ○ |
| C-06 | Server Actionログがリクエストメタデータから取得される | E-01 (67-74行目) | ○ |
| C-07 | Server Action引数はsafe-stable-stringifyで制限付きシリアライズ | E-02 (4-7行目) | ○ |
| C-08 | シリアライズ失敗時に[unserializable]を返す | E-02 (21-23行目) | ○ |
| C-09 | fetchメトリクスはcacheStatus別にログ出力される | E-01 (145-195行目) | ○ |
| C-10 | HMRキャッシュはデフォルトで非表示 | E-01 (160-164行目) | ○ |
| C-11 | URLは48文字を超えると切り詰められる | E-01 (167-169行目) | ○ |
| C-12 | truncateUrlはprotocol/host/pathname/searchに分解して切り詰め | E-01 (207-216行目) | ○ |
| C-13 | formatCacheStatusはhmr/hit/miss/skipの4値を処理 | E-01 (219-231行目) | ○ |
| C-14 | LoggingConfigのignoreは正規表現配列 | E-01 (40行目) | ○ |
| C-15 | maximumDepth:2, maximumBreadth:3の設定 | E-02 (5-6行目) | ○ |
| C-16 | writeLine関数がインデント付き出力を行う | E-01 (197-199行目) | ○ |
| C-17 | 開発モードでのみ有効 | E-04 | ○ |
| C-18 | DEBUG=next:*で詳細なデバッグログが出力される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DEBUG=next:*の具体的な実装箇所と出力内容の詳細は、コードベース全体に分散しており完全な特定が困難
  - 候補：`packages/next/src/server/lib/router-server.ts` / `packages/next/src/server/base-server.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ログ出力機能であり、アプリケーション動作への影響は限定的

## 6) レビュアーチェックリスト（最小）
- [ ] logRequests関数の呼び出し元（Router Server）の確認
- [ ] LoggingConfig型の最新定義とドキュメントの整合性確認
- [ ] DEBUG=next:*の具体的な出力内容の確認
