---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：102-next/og（ImageResponse）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **@vercel/ogの内部処理（Satori/Resvg）**：コンパイル済みライブラリの内部は直接検証不可

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/og/image-response.ts` - ImageResponseクラスの実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧での定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ImageResponseはResponseを継承している | E-01 (19行目: extends Response) | ○ |
| C-02 | Edge/Node.js両方で動作する | E-01 (8-9行目: ランタイム判定) | ○ |
| C-03 | displayNameが'ImageResponse'に設定 | E-01 (20行目) | ○ |
| C-04 | ReadableStreamでストリーミング配信 | E-01 (22-43行目) | ○ |
| C-05 | Content-Typeはimage/png | E-01 (48行目) | ○ |
| C-06 | 開発時はno-cache, no-store | E-01 (50-51行目) | ○ |
| C-07 | 本番時はpublic, max-age=0, must-revalidate | E-01 (52行目) | ○ |
| C-08 | カスタムヘッダーがデフォルトを上書き | E-01 (54-57行目) | ○ |
| C-09 | bodyがない場合controller.close | E-01 (30-31行目) | ○ |
| C-10 | reader.readループでデータ転送 | E-01 (35-41行目) | ○ |
| C-11 | options.statusがResponseに渡される | E-01 (60行目) | ○ |
| C-12 | options.statusTextがResponseに渡される | E-01 (61行目) | ○ |
| C-13 | importModuleがランタイムに応じたモジュールを選択 | E-01 (3-11行目) | ○ |
| C-14 | 内部でSatori(JSX->SVG)とResvg(SVG->PNG)が使用される | **根拠なし**（@vercel/ogの内部実装） | △ |

## 4) 不足情報（Unknown / Missing）
- @vercel/ogの内部画像生成パイプライン（Satori/Resvg）の詳細はコンパイル済みライブラリ内に含まれ、直接検証不可
  - 候補：@vercel/ogのGitHubリポジトリ / ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Web標準のResponse APIを適切に使用しており、実装は簡潔

## 6) レビュアーチェックリスト（最小）
- [ ] @vercel/ogのバージョンと機能の対応確認
- [ ] Edge Runtime/Node.jsでの動作差異の確認
- [ ] Cache-Control設定がCDN運用に適しているかの確認
