---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：103-CSRF保護

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にソースコード根拠がある。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/app-render/csrf-protection.ts` - CSRF保護の実装
- E-02: `packages/next/src/server/lib/router-utils/block-cross-site.ts` - isCsrfOriginAllowedの再利用箇所

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isCsrfOriginAllowedがメイン関数 | E-01 (72行目) | ○ |
| C-02 | matchWildcardDomainがワイルドカードマッチを実行 | E-01 (6行目) | ○ |
| C-03 | DNS名がASCII小文字に正規化される | E-01 (9-10行目, 78-79行目) | ○ |
| C-04 | replace(/[A-Z]/g)でUnicode問題を回避 | E-01 (9行目コメント) | ○ |
| C-05 | `*`単独でのマッチは不許可 | E-01 (27-32行目) | ○ |
| C-06 | `**`が先頭以外に配置された場合は無効 | E-01 (53-55行目) | ○ |
| C-07 | `**`は1つ以上のセグメントにマッチ | E-01 (57行目) | ○ |
| C-08 | `*`は非空の1セグメントにマッチ | E-01 (44-49行目) | ○ |
| C-09 | 末尾からpopで比較する | E-01 (35-36行目) | ○ |
| C-10 | ドメインセグメント全消費で一致判定 | E-01 (69行目) | ○ |
| C-11 | 完全一致チェックが先に行われる | E-01 (89-90行目) | ○ |
| C-12 | block-cross-siteで再利用される | E-02 (5行目import, 94行目呼び出し) | ○ |
| C-13 | パターンが空の場合は不一致 | E-01 (15-18行目) | ○ |
| C-14 | 空文字列パターンセグメントは不一致 | E-01 (40-41行目) | ○ |
| C-15 | Edge Runtimeで動作可能 | E-01 (1-5行目コメント) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 純粋関数としての実装であり、ロジックが明快

## 6) レビュアーチェックリスト（最小）
- [ ] ワイルドカードパターンの安全性（意図しないマッチがないか）の確認
- [ ] action-handler.tsでのisCsrfOriginAllowed呼び出しコンテキストの確認
