---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：106-クロスサイトアクセスブロック

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にソースコード根拠がある。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/lib/router-utils/block-cross-site.ts` - クロスサイトブロック実装
- E-02: `packages/next/src/server/app-render/csrf-protection.ts` - isCsrfOriginAllowed関数

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | allowedDevOriginsがundefinedで警告モード | E-01 (61行目) | ○ |
| C-02 | デフォルトで*.localhostとlocalhostを許可 | E-01 (64-65行目) | ○ |
| C-03 | hostnameが許可リストに追加される | E-01 (68-70行目) | ○ |
| C-04 | /_next/*を内部エンドポイントとして検出 | E-01 (40行目) | ○ |
| C-05 | /__nextjsをミドルウェアリクエストとして検出 | E-01 (39行目) | ○ |
| C-06 | /_next/imageを除外 | E-01 (44行目) | ○ |
| C-07 | /_next/static/mediaを除外 | E-01 (45行目) | ○ |
| C-08 | sec-fetch-mode: no-cors + sec-fetch-site: cross-siteを検出 | E-01 (79-80行目) | ○ |
| C-09 | isCsrfOriginAllowedでOrigin検証 | E-01 (94行目), E-02 | ○ |
| C-10 | 警告モードでwarnOnceを使用 | E-01 (14-16行目) | ○ |
| C-11 | ブロックモードで403を返す | E-01 (25-26行目) | ○ |
| C-12 | レスポンスボディが"Unauthorized" | E-01 (29行目) | ○ |
| C-13 | Origin null文字列を許容 | E-01 (88行目) | ○ |
| C-14 | statusCodeチェックでHTTP/Duplexを判別 | E-01 (25行目) | ○ |
| C-15 | 将来のメジャーバージョンでブロックデフォルト化の予告 | E-01 (14-16行目コメント) | ○ |
| C-16 | CSSからのロード対応で静的メディアを除外 | E-01 (42-43行目コメント) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 開発モード専用の機能であり、本番環境への影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] router-server.tsでのblockCrossSite呼び出し箇所の確認
- [ ] WebSocketアップグレード時のDuplexハンドリングの確認
