---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：11-next analyze

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **bundle-analyzerディレクトリの構造**：UIファイルの詳細内容は未確認
  2. **turbopackAnalyzeの内部動作**：turbopack-analyze.tsの内部実装は詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-analyze.ts`（全62行）
- E-02: `packages/next/src/build/analyze/index.ts`（全255行）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.11行）
- E-04: `packages/next/src/shared/lib/constants.ts`（PHASE_ANALYZE定数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CLIエントリーポイントはsrc/cli/next-analyze.ts | E-01, E-03 | ○ |
| C-02 | NextAnalyzeOptions型に6つのオプションがある | E-01（12-19行目） | ○ |
| C-03 | SIGTERM/SIGINTでCPUプロファイルを保存 | E-01（22-29行目） | ○ |
| C-04 | マングリング無効時に警告を出力 | E-01（33-37行目） | ○ |
| C-05 | プロファイリング有効時に警告を出力 | E-01（39-43行目） | ○ |
| C-06 | プロジェクトディレクトリの存在確認 | E-01（47-49行目） | ○ |
| C-07 | analyze関数でPHASE_ANALYZEフェーズを使用 | E-02（8行目, 60行目） | ○ |
| C-08 | turbopackAnalyzeでバンドル分析を実行 | E-02（74-75行目） | ○ |
| C-09 | collectRoutesForAnalyzeでルート情報を収集 | E-02（82行目, 128-208行目） | ○ |
| C-10 | 分析結果を.next/diagnostics/analyzeに出力 | E-02（78行目, 84-91行目） | ○ |
| C-11 | outputモードでない場合HTTPサーバーを起動 | E-02（107-109行目） | ○ |
| C-12 | HTTPサーバーはデフォルトポート4000 | E-02（48行目, 210-254行目） | ○ |
| C-13 | テレメトリにanalysis完了イベントを記録 | E-02（99-105行目） | ○ |
| C-14 | サーバーはlocalhostのみでリッスン | E-02（226行目） | ○ |
| C-15 | routes.jsonにルート情報をJSON形式で出力 | E-02（88-91行目） | ○ |
| C-16 | エラー時テレメトリにfailure記録 | E-02（111-118行目） | ○ |
| C-17 | bundle-analyzerUIファイルをコピー | E-02（84-86行目） | △ |
| C-18 | turbopackAnalyzeの内部でバンドルサイズ分析 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- turbopack-analyze.tsの内部実装の詳細を未確認
  - 候補：`packages/next/src/build/turbopack-analyze.ts` の詳細読解
- bundle-analyzerディレクトリの構造・内容の詳細
  - 候補：`packages/next/src/bundle-analyzer/` ディレクトリの内容確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CLIオプションと処理フローは明確にソースコードから確認済み
- 1: 中リスク - turbopackAnalyzeの内部動作はインターフェースのみ確認

## 6) レビュアーチェックリスト（最小）
- [ ] turbopackAnalyzeの返値（duration, shutdownPromise）が正しく記載されているか
- [ ] bundle-analyzerのUI構成が最新のソースと一致しているか
- [ ] AnalyzeOptionsのデフォルト値が正しいか
