---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：110-Instrumentation

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。すべての主張にソースコード根拠がある。

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/instrumentation/types.ts` - 型定義
- E-02: `packages/next/src/server/instrumentation/utils.ts` - ユーティリティ
- E-03: `packages/next/src/server/lib/router-utils/instrumentation-globals.external.ts` - メイン実装

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InstrumentationModuleはregisterとonRequestErrorを持つ | E-01 (23-26行目) | ○ |
| C-02 | RequestErrorContextにrouterKind/routePath/routeTypeが含まれる | E-01 (1-11行目) | ○ |
| C-03 | onRequestErrorはvoid \| Promise\<void\>を返す | E-01 (13-21行目) | ○ |
| C-04 | getRevalidateReasonがon-demand/stale/undefinedを返す | E-02 (1-12行目) | ○ |
| C-05 | getInstrumentationModuleはキャッシュ付き | E-03 (11行目, 17-19行目) | ○ |
| C-06 | require()でserver/instrumentation.jsを読み込み | E-03 (23-29行目) | ○ |
| C-07 | ENOENT/MODULE_NOT_FOUNDエラーを無視 | E-03 (34-41行目) | ○ |
| C-08 | registerInstrumentationはビルドフェーズでスキップ | E-03 (49-51行目) | ○ |
| C-09 | register()をawaitで実行 | E-03 (57行目) | ○ |
| C-10 | register後にextendInstrumentationAfterRegistration | E-03 (58行目) | ○ |
| C-11 | registerエラーにプレフィックスメッセージを追加 | E-03 (61行目) | ○ |
| C-12 | instrumentationOnRequestErrorでonRequestErrorを呼び出し | E-03 (74行目) | ○ |
| C-13 | onRequestErrorのエラーはconsole.errorでログ | E-03 (77行目) | ○ |
| C-14 | ensureInstrumentationRegisteredでPromiseキャッシュ | E-03 (81-93行目) | ○ |
| C-15 | interopDefaultでCJS/ESM互換 | E-03 (8行目, 22行目) | ○ |
| C-16 | instrumentationModulePromiseで1回のみ読み込み | E-03 (45-54行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 明確な型定義と安全なエラーハンドリング

## 6) レビュアーチェックリスト（最小）
- [ ] next-server.tsでのensureInstrumentationRegistered呼び出しタイミングの確認
- [ ] extendInstrumentationAfterRegistrationの具体的な処理内容の確認
- [ ] Edge Runtimeでの同等機能（web/globals.ts）の確認
