---
generated_at: 2026-02-03 15:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：111-OpenTelemetryトレース

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **OpenTelemetry準拠の度合い**：根拠不足（コード上はカスタムトレーシング実装であり、OpenTelemetry SDKを直接使用していない）
  2. **外部トレースサーバーのAPI仕様**：根拠不足（アップロード先のAPI仕様は外部依存）

## 2) 参照した情報（Evidence一覧）
- E-01: `packages/next/src/trace/trace.ts`（Spanクラス実装）
- E-02: `packages/next/src/trace/types.ts`（型定義）
- E-03: `packages/next/src/trace/shared.ts`（グローバル状態管理）
- E-04: `packages/next/src/trace/index.ts`（エントリーポイント）
- E-05: `packages/next/src/trace/report/index.ts`（MultiReporter）
- E-06: `packages/next/src/trace/report/to-json.ts`（JSONレポーター）
- E-07: `packages/next/src/trace/report/to-json-build.ts`（ビルドレポーター）
- E-08: `packages/next/src/trace/report/to-telemetry.ts`（テレメトリレポーター）
- E-09: `packages/next/src/trace/report/types.ts`（Reporterインターフェース）
- E-10: `packages/next/src/trace/upload-trace.ts`（アップロード起動）
- E-11: `packages/next/src/trace/trace-uploader.ts`（アップロード実行）
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Spanクラスが親子関係を持つトレーススパンを管理する | E-01 (29-147行目) | ○ |
| C-02 | 期間はナノ秒からマイクロ秒に変換される | E-01 (4行目, 77行目) | ○ |
| C-03 | NEXT_TRACE_SPAN_THRESHOLD_MSで閾値制御 | E-01 (15-17行目) | ○ |
| C-04 | SpanStatus.Stoppedのスパンは再停止されない | E-01 (71-75行目) | ○ |
| C-05 | MultiReporterが3つのレポーターを統合 | E-05 (24-28行目) | ○ |
| C-06 | バッチサイズ100件でファイル書き出し | E-06 (23行目) | ○ |
| C-07 | 開発モードで50MBファイルサイズ上限 | E-06 (115行目) | ○ |
| C-08 | RotatingWriteStreamによるファイルローテーション | E-06 (41-98行目) | ○ |
| C-09 | ビルドトレースは許可リストでフィルタ | E-07 (77-90行目) | ○ |
| C-10 | テレメトリへの転送はwebpack-invalidatedイベントのみ | E-08 (5-9行目) | ○ |
| C-11 | トレースIDはcrypto.randomBytesで生成 | E-03 (15-18行目) | ○ |
| C-12 | TRACE_ID環境変数でトレースIDを外部指定可能 | E-03 (16行目) | ○ |
| C-13 | アップロードは子プロセスでdetachedモード実行 | E-10 (34-57行目) | ○ |
| C-14 | trace-uploaderがファイルを読み込みHTTP POSTで送信 | E-11 (111-198行目) | ○ |
| C-15 | DEV_ALLOWED_EVENTSでdev時のイベントフィルタ | E-11 (15-26行目) | ○ |
| C-16 | BUILD_ALLOWED_EVENTSでビルド時のイベントフィルタ | E-11 (28-55行目) | ○ |
| C-17 | セッション分離（traceIdによるフィルタ） | E-11 (145-148行目) | ○ |
| C-18 | ワーカープロセス間のトレース状態共有 | E-01 (163-188行目) | ○ |
| C-19 | traceFn/traceAsyncFnで自動スパン停止 | E-01 (132-146行目) | ○ |
| C-20 | traceChild()で子スパン生成 | E-01 (100-102行目) | ○ |
| C-21 | manualTraceChildで手動時刻指定可能 | E-01 (104-122行目) | ○ |
| C-22 | flushAllTracesで全レポーターをフラッシュ | E-01 (157-158行目), E-05 (14-16行目) | ○ |
| C-23 | Duration overflow時にErrorをスロー | E-01 (79-81行目) | ○ |
| C-24 | OpenTelemetry準拠のトレーシングサポート | **根拠不足** | △ |
| C-25 | 外部トレースサーバーのAPI仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24: コード上はOpenTelemetry SDKを直接使用しておらず、カスタム実装となっている。「OpenTelemetry準拠」の度合いについてはドキュメント上の記載に基づくものであり、実際のプロトコル互換性は要確認。
  - 候補：OpenTelemetry仕様書 / Next.js公式ドキュメント / RFC
- C-25: トレースアップロード先のAPIは`traceUploadUrl`パラメータで外部指定されるため、API仕様は外部依存。
  - 候補：Vercelトレースサーバー仕様 / 環境変数ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイル書き出し・テレメトリ連携は安定した実装
- 1: 中リスク - 「OpenTelemetry準拠」の表現が実装と乖離する可能性がある
- 0: 低リスク - トレースアップロードはオプション機能であり、失敗しても本体に影響しない

## 6) レビュアーチェックリスト（最小）
- [ ] OpenTelemetry準拠の記述が実装と整合しているか確認
- [ ] ビルドトレース許可リストが最新のコードと一致しているか確認
- [ ] テレメトリ転送対象イベントリストが最新か確認
- [ ] 外部トレースサーバーへの送信フォーマットが正確か確認
