---
generated_at: 2026-02-03 15:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：112-Google Analytics

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **next/scriptのデフォルト戦略**：afterInteractiveがデフォルトかはscript.tsxの実装に依存

## 2) 参照した情報（Evidence一覧）
- E-01: `packages/third-parties/src/google/ga.tsx`（GAコンポーネント実装）
- E-02: `packages/third-parties/src/types/google.ts`（型定義）
- E-03: `packages/third-parties/src/google/index.tsx`（エクスポート）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GAParamsにgaId, dataLayerName, debugMode, nonceが定義されている | E-02 (35-40行目) | ○ |
| C-02 | GoogleAnalyticsは'use client'ディレクティブを持つ | E-01 (1行目) | ○ |
| C-03 | dataLayerNameのデフォルト値は'dataLayer' | E-01 (17行目) | ○ |
| C-04 | currDataLayerNameは初回設定後固定される | E-01 (19-21行目) | ○ |
| C-05 | gtag.jsはGoogleTagManagerのURLから読み込まれる | E-01 (52行目) | ○ |
| C-06 | performance.markで機能利用シグナルを送信 | E-01 (29-33行目) | ○ |
| C-07 | debugMode有効時にdebug_mode: trueがconfigに追加される | E-01 (46行目) | ○ |
| C-08 | sendGAEventはwindow[dataLayerName].pushを呼ぶ | E-01 (65-66行目) | ○ |
| C-09 | GA未初期化時にconsole.warnを出力 | E-01 (61行目) | ○ |
| C-10 | dataLayer不存在時にconsole.warnを出力 | E-01 (68-70行目) | ○ |
| C-11 | nonce属性がscript要素に適用される | E-01 (48行目, 53行目) | ○ |
| C-12 | 2つのscript要素が生成される | E-01 (38-54行目) | ○ |
| C-13 | dangerouslySetInnerHTMLで初期化スクリプトを挿入 | E-01 (39-47行目) | ○ |
| C-14 | sendGAEventはargumentsオブジェクトをpushする | E-01 (66行目) | ○ |
| C-15 | next/scriptのデフォルト読み込み戦略はafterInteractive | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: next/scriptのデフォルト戦略についてはscript.tsxの実装を直接確認する必要がある。ga.tsx内ではstrategyプロパティが明示的に指定されていない。
  - 候補：packages/next/src/client/script.tsx / Next.js公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンポーネント構造はシンプルで明確
- 1: 中リスク - dangerouslySetInnerHTMLを使用しているが、propsからの信頼された入力のみ
- 0: 低リスク - sendGAEventのエラーハンドリングは警告のみで安全

## 6) レビュアーチェックリスト（最小）
- [ ] gaIdのサニタイズがXSSリスクに対して適切か確認
- [ ] next/scriptのデフォルト戦略を確認
- [ ] dataLayerName変数のモジュールレベル管理がSSR時に問題ないか確認
