---
generated_at: 2026-02-03 15:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：113-Google Tag Manager

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重大なリスクなし。

## 2) 参照した情報（Evidence一覧）
- E-01: `packages/third-parties/src/google/gtm.tsx`（GTMコンポーネント実装）
- E-02: `packages/third-parties/src/types/google.ts`（型定義）
- E-03: `packages/third-parties/src/google/index.tsx`（エクスポート）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GTMParamsはUnion型（GTMParamsWithId | GTMParamsWithScriptUrl） | E-02 (23-33行目) | ○ |
| C-02 | 'use client'ディレクティブを持つ | E-01 (1行目) | ○ |
| C-03 | currDataLayerNameのデフォルトは'dataLayer' | E-01 (8行目) | ○ |
| C-04 | currDataLayerNameは毎回レンダリング時に更新される | E-01 (21行目) | ○ |
| C-05 | デフォルトGTMスクリプトURLは'https://www.googletagmanager.com/gtm.js' | E-01 (24行目) | ○ |
| C-06 | gtmId指定時にURLにidパラメータが追加される | E-01 (27行目) | ○ |
| C-07 | dataLayerName変更時にURLにlパラメータが追加される | E-01 (29-31行目) | ○ |
| C-08 | auth指定時にgtm_authパラメータが追加される | E-01 (33行目) | ○ |
| C-09 | preview指定時にgtm_previewとgtm_cookies_winが追加される | E-01 (36-38行目) | ○ |
| C-10 | 初期化スクリプトでgtm.startイベントがpushされる | E-01 (61行目) | ○ |
| C-11 | 初期dataLayerがJSON.stringifyでシリアライズされる | E-01 (62行目) | ○ |
| C-12 | data-ntpc="GTM"属性がgtm.jsスクリプトに付与される | E-01 (69行目) | ○ |
| C-13 | performance.markで機能利用シグナルを送信 | E-01 (46-50行目) | ○ |
| C-14 | nonce属性がscript要素に適用される | E-01 (65行目, 71行目) | ○ |
| C-15 | sendGTMEventはwindow[dataLayer]を自動作成する | E-01 (81行目) | ○ |
| C-16 | sendGTMEventはdataLayerNameパラメータを受け取れる | E-01 (77行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張がソースコードの根拠により裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンポーネント構造はGA同様にシンプル
- 0: 低リスク - sendGTMEventの自動dataLayer作成は安全な動作

## 6) レビュアーチェックリスト（最小）
- [ ] Union型のgtmId/gtmScriptUrl排他制御が型レベルで正しいか確認
- [ ] カスタムGTMスクリプトURLのバリデーションが十分か確認
- [ ] dataLayerの初期データに対するサニタイズが適切か確認
