---
generated_at: 2026-02-03 15:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：114-Google Maps

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **third-party-capitalのHTML生成仕様**：外部ライブラリ依存のため内部実装未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `packages/third-parties/src/google/google-maps-embed.tsx`（コンポーネント実装）
- E-02: `packages/third-parties/src/types/google.ts`（型定義）
- E-03: `packages/third-parties/src/ThirdPartyScriptEmbed.tsx`（共通埋め込み）
- E-04: `packages/third-parties/src/google/index.tsx`（エクスポート）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GoogleMapsEmbed型にmode, apiKey等のプロパティがある | E-02 (42-57行目) | ○ |
| C-02 | apiKeyはkeyプロパティに変換される | E-01 (7-8行目) | ○ |
| C-03 | TPCGoogleMapEmbed関数でHTML生成 | E-01 (9行目) | ○ |
| C-04 | ThirdPartyScriptEmbedでDOM挿入 | E-01 (12-18行目) | ○ |
| C-05 | height/widthがnullの場合autoスタイルが適用される | E-03 (41-42行目) | ○ |
| C-06 | dataNtpc="GoogleMapsEmbed"が設定される | E-01 (16行目) | ○ |
| C-07 | performance.markで機能利用シグナルが送信される | E-03 (25-29行目) | ○ |
| C-08 | Server Componentとして動作可能 | E-01 (全体: 'use client'なし) | ○ |
| C-09 | dangerouslySetInnerHTMLでHTML挿入 | E-03 (45行目) | ○ |
| C-10 | modeは5つのリテラル型Union | E-02 (45行目) | ○ |
| C-11 | default exportとしてエクスポート | E-01 (6行目), E-04 (1行目) | ○ |
| C-12 | third-party-capitalがiframe HTMLを生成 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12: third-party-capitalの内部実装は外部パッケージであり、生成されるHTML形式の詳細は本プロジェクトのコードからは確認不可。
  - 候補：third-party-capital パッケージのソースコード / ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンポーネントは薄いラッパーで構造がシンプル
- 1: 中リスク - third-party-capitalの生成HTMLがdangerouslySetInnerHTMLで挿入される

## 6) レビュアーチェックリスト（最小）
- [ ] third-party-capitalが生成するHTMLが安全か確認
- [ ] apiKeyのクライアントサイド公開が適切か確認（API制限設定推奨）
- [ ] Server Component動作時の制約がないか確認
