---
generated_at: 2026-02-03 15:20:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：115-YouTube Embed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **lite-youtube-embedパターンの詳細**：third-party-capitalの内部実装に依存

## 2) 参照した情報（Evidence一覧）
- E-01: `packages/third-parties/src/google/youtube-embed.tsx`（コンポーネント実装）
- E-02: `packages/third-parties/src/types/google.ts`（型定義）
- E-03: `packages/third-parties/src/ThirdPartyScriptEmbed.tsx`（共通埋め込み）
- E-04: `packages/third-parties/src/google/index.tsx`（エクスポート）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | YouTubeEmbed型にvideoid, height, width, playlabel, params, styleが定義 | E-02 (59-66行目) | ○ |
| C-02 | TPCYouTubeEmbed関数でhtml, scripts, stylesheetsを取得 | E-01 (17行目) | ○ |
| C-03 | scriptStrategyマッピングが4つの変換を定義 | E-01 (9-14行目) | ○ |
| C-04 | scripts配列をmapしてnext/Scriptコンポーネント生成 | E-01 (26-33行目) | ○ |
| C-05 | script.urlがkeyとsrcに使用される | E-01 (28-29行目) | ○ |
| C-06 | stylesheets propsがScriptコンポーネントに渡される | E-01 (31行目) | ○ |
| C-07 | ThirdPartyScriptEmbedにchildren（Script要素）が渡される | E-01 (25-34行目) | ○ |
| C-08 | dataNtpc="YouTubeEmbed"が設定される | E-01 (24行目) | ○ |
| C-09 | height/widthがpropsから取得され、nullデフォルト | E-01 (21-22行目) | ○ |
| C-10 | performance.markで機能利用シグナルが送信される | E-03 (25-29行目) | ○ |
| C-11 | default exportとしてエクスポート | E-01 (16行目), E-04 (2行目) | ○ |
| C-12 | videoidは小文字で定義されている | E-02 (63行目) | ○ |
| C-13 | lite-youtube-embedパターンによるサムネイル先行表示 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: lite-youtube-embedパターンの詳細はthird-party-capitalパッケージの内部実装に依存する。本プロジェクトのコードからは直接確認できない。
  - 候補：third-party-capital パッケージのソースコード / lite-youtube-embed仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンポーネント構造はシンプルなラッパー
- 1: 中リスク - third-party-capitalの出力HTML/スクリプトの安全性

## 6) レビュアーチェックリスト（最小）
- [ ] third-party-capitalが生成するHTML/スクリプト/スタイルシートの安全性を確認
- [ ] scriptStrategy変換マッピングが正しいか確認
- [ ] stylesheets propsの動作がnext/scriptで正しく処理されるか確認
