---
generated_at: 2026-02-03 15:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 13
  claims_without_evidence: 3
confidence_derived: 0.81
---

# 根拠レポート：116-スタンドアロン出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.81**
  - 根拠あり：13 / 16、根拠なし：3
- 優先レビュー（高）
  1. **copyTracedFiles関数の詳細実装**：build/index.tsの全行を読み込んでいないため詳細未確認
  2. **server.jsの生成内容**：具体的な出力テンプレートの確認が必要
  3. **static ファイルの手動コピー要件**：公式ドキュメントに基づく記述

## 2) 参照した情報（Evidence一覧）
- E-01: `packages/next/src/build/index.ts`（ビルドメイン処理、部分的に読み込み）
- E-02: `packages/next/src/build/collect-build-traces.ts`（トレース収集、冒頭50行）
- E-03: `packages/next/src/server/config-shared.ts`（設定型定義、部分的に読み込み）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）
- E-05: `packages/next/src/trace/report/to-json-build.ts`（output-standaloneトレースイベント）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | output: 'standalone'設定でスタンドアロン出力が有効化される | E-01 (4259行目) | ○ |
| C-02 | STANDALONE_DIRECTORY定数は'standalone' | E-01 (687行目) | ○ |
| C-03 | writeStandaloneDirectory関数が定義されている | E-01 (688行目) | ○ |
| C-04 | output-standaloneトレーススパンが記録される | E-01 (4261行目), E-05 (88行目) | ○ |
| C-05 | @vercel/nftでファイル依存解析を行う | E-02 (19行目) | ○ |
| C-06 | makeIgnoreFnでトレース除外パターンを定義 | E-02 (28-42行目) | ○ |
| C-07 | picomatchで除外パターンをプリコンパイル | E-02 (30-31行目) | ○ |
| C-08 | アダプタ処理の後にstandalone出力が実行される | E-01 (4224-4259行目) | ○ |
| C-09 | copyTracedFilesが呼び出される | E-01 (705行目付近) | ○ |
| C-10 | config-shared.tsにoutput設定が定義されている | E-03 (basePath周辺のコード構造) | ○ |
| C-11 | nodeFileTrace関数が@vercel/nftからインポートされる | E-02 (19行目) | ○ |
| C-12 | shouldIgnore関数でファイルごとの除外判定 | E-02 (44-50行目) | ○ |
| C-13 | Spanインポートでトレーシング連携 | E-02 (3行目) | ○ |
| C-14 | standalone出力にはserver.jsが含まれる | **根拠不足** | △ |
| C-15 | staticファイルは手動コピーが必要 | **根拠なし** | △ |
| C-16 | copyTracedFilesの詳細な出力構造 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: server.jsの生成テンプレートはbuild/index.tsの全体を読み込んでいないため、具体的な内容を確認できていない。
  - 候補：packages/next/src/build/index.ts の全行 / standalone関連のテスト
- C-15: publicディレクトリやstaticファイルの手動コピー要件はNext.js公式ドキュメントに基づく一般的な知識。
  - 候補：Next.js公式ドキュメント / ビルドプロセスの詳細コード
- C-16: copyTracedFilesの詳細な実装（出力ディレクトリ構造、ファイル選択ロジック）は未確認。
  - 候補：packages/next/src/build/index.ts の全行

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - copyTracedFilesの実装詳細が未確認のため、出力構造の記述に誤りがある可能性
- 1: 中リスク - server.jsの生成内容が未確認
- 0: 低リスク - ビルドトレースとの連携は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] copyTracedFilesの詳細な実装と出力構造を確認
- [ ] server.jsの生成テンプレートを確認
- [ ] staticファイルの手動コピー要件が最新のNext.jsバージョンで正しいか確認
- [ ] モノレポ対応（outputFileTracingRoot）の動作を確認
