---
generated_at: 2026-02-03 15:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：117-静的エクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Image Optimization制限の最新状況**：バージョンによって制限が変わる可能性

## 2) 参照した情報（Evidence一覧）
- E-01: `packages/next/src/export/index.ts`（エクスポートメイン処理）
- E-02: `packages/next/src/export/types.ts`（型定義）
- E-03: `packages/next/src/export/worker.ts`（ワーカー処理）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BUILD_ID_FILE存在確認を行う | E-01 (236-242行目) | ○ |
| C-02 | API Routesはエクスポート対象外 | E-01 (294-297行目) | ○ |
| C-03 | _document, _app, _errorは除外 | E-01 (299-301行目) | ○ |
| C-04 | SSGフォールバックtrueページはエラー | E-01 (607-613行目) | ○ |
| C-05 | i18n設定は非互換 | E-01 (402-405行目) | ○ |
| C-06 | Server Actionsは禁止 | E-01 (461-469行目) | ○ |
| C-07 | インターセプトルートは禁止 | E-01 (446-454行目) | ○ |
| C-08 | PPRはexportモード非対応 | E-01 (864-867行目) | ○ |
| C-09 | outDirがpublicの場合エラー | E-01 (335-338行目) | ○ |
| C-10 | outDirがstaticの場合エラー | E-01 (341-344行目) | ○ |
| C-11 | EXPORT_DETAILにsuccess: false/trueを書き込み | E-01 (350-358行目, 1015-1023行目) | ○ |
| C-12 | 404パスが未定義の場合/_errorから生成 | E-01 (557-558行目) | ○ |
| C-13 | 404.htmlの互換出力 | E-01 (565-568行目) | ○ |
| C-14 | ワーカープロセスでバッチレンダリング | E-01 (678-734行目) | ○ |
| C-15 | 最小バッチサイズ25ページ | E-01 (688-689行目) | ○ |
| C-16 | staticGenerationMinPagesPerWorkerで制御可能 | E-01 (688行目) | ○ |
| C-17 | カスタムルートの警告出力 | E-01 (248-254行目) | ○ |
| C-18 | RDCキャッシュの2段階レンダリング | E-01 (736-793行目) | ○ |
| C-19 | ExportErrorクラスのcode='NEXT_EXPORT_ERROR' | E-01 (77-79行目) | ○ |
| C-20 | NEXT_IS_EXPORT_WORKER環境変数設定 | E-03 (15行目) | ○ |
| C-21 | ExportAppResultにbyPath, byPage, ssgNotFoundPathsが含まれる | E-02 (126-172行目) | ○ |
| C-22 | Image Optimizationの制限 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-22: Image Optimizationの制限はエクスポート処理コード内で確認できるが（E-01 408-431行目）、最新バージョンでの制限詳細は公式ドキュメントの確認が推奨される。
  - 候補：Next.js公式ドキュメント / packages/next/src/export/index.ts 408-431行目

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - エクスポートのバリデーションは堅牢に実装されている
- 0: 低リスク - 2段階レンダリング（RDCキャッシュ）の実装は確認済み
- 0: 低リスク - ワーカーによるバッチ処理の実装は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Image Optimization制限の最新状況を確認
- [ ] セグメントデータファイルの出力形式を確認
- [ ] RDCキャッシュの2段階レンダリングの動作を確認
