---
generated_at: 2026-02-03 15:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 10
  claims_without_evidence: 4
confidence_derived: 0.71
---

# 根拠レポート：118-マルチゾーン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.71**
  - 根拠あり：10 / 14、根拠なし：4
- 優先レビュー（高）
  1. **ゾーン間ナビゲーションのハードナビゲーション制約**：公式ドキュメントに基づく記述
  2. **リバースプロキシ構成の詳細**：外部システム依存
  3. **Cookie共有のセキュリティ考慮**：一般的なWeb知識に基づく記述
  4. **Vercelネイティブサポートの詳細**：外部プラットフォーム依存

## 2) 参照した情報（Evidence一覧）
- E-01: `packages/next/src/server/config-shared.ts`（basePath設定）
- E-02: `packages/next/src/server/config.ts`（設定バリデーション）
- E-03: `packages/next/src/lib/load-custom-routes.ts`（リライトルール）
- E-04: `packages/next/src/server/lib/router-server.ts`（ルーティング）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | basePathのデフォルト値は空文字列 | E-01 (1499行目) | ○ |
| C-02 | basePath設定の型はstring | E-01 (1196行目) | ○ |
| C-03 | basePath設定は'/'で始まること | E-02 (config.ts内のバリデーション) | ○ |
| C-04 | rewritesルールでゾーン間転送を実現 | E-03 (load-custom-routes.ts) | ○ |
| C-05 | router-server.tsでbasePath処理 | E-04 (router-server.ts) | ○ |
| C-06 | filesystem.tsでbasePath考慮 | E-04付近のファイル | ○ |
| C-07 | マルチゾーンはbasePath + rewritesの組み合わせで実現 | E-01, E-03, E-05 | ○ |
| C-08 | 各ゾーンは独立してビルド可能 | E-05 (機能一覧の記述) | ○ |
| C-09 | assetPrefixで静的アセットの配信元を変更可能 | E-01 (config-shared.ts内のassetPrefix設定) | ○ |
| C-10 | 専用APIは存在しない（設定の組み合わせ） | E-01, E-03 | ○ |
| C-11 | ゾーン間ナビゲーションはハードナビゲーション | **根拠なし** | △ |
| C-12 | Cookie共有に関するセキュリティ考慮 | **根拠なし** | △ |
| C-13 | Vercelネイティブサポート | **根拠なし** | △ |
| C-14 | リバースプロキシ構成の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-11: ゾーン間ナビゲーションのハードナビゲーション制約はNext.jsのクライアントサイドルーティングがbasePath間で動作しないことに基づく一般的な知識。コード上での直接確認は困難。
  - 候補：Next.js公式ドキュメント / client/link.tsxの実装
- C-12: Cookie共有はHTTPの仕様に基づく一般的なWeb知識であり、Next.js固有のコードではない。
  - 候補：HTTP Cookie仕様 / ブラウザセキュリティモデル
- C-13: Vercelのマルチゾーンサポートはプラットフォーム側の機能であり、Next.jsのコードベースには含まれない。
  - 候補：Vercel公式ドキュメント
- C-14: リバースプロキシの構成は外部システム依存であり、Next.jsの実装外。
  - 候補：Nginx/Vercel/Cloudflare等の設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - マルチゾーンは「機能」というより「構成パターン」であり、専用コードが存在しないため設計書の記述範囲が曖昧
- 1: 中リスク - 外部システム（リバースプロキシ）依存の記述が多い
- 0: 低リスク - basePath設定とrewritesの仕組みはコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] マルチゾーンが「構成パターン」であることの記述が適切か確認
- [ ] ゾーン間ナビゲーション制約の記述が正確か確認
- [ ] セキュリティ考慮事項（Cookie共有等）の記述が適切か確認
- [ ] Vercelプラットフォームへの言及が適切か確認
