---
generated_at: 2026-02-03 15:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：119-Testing API

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重大なリスクなし。

## 2) 参照した情報（Evidence一覧）
- E-01: `packages/next/src/experimental/testing/server/index.ts`（エントリーポイント）
- E-02: `packages/next/src/experimental/testing/server/config-testing-utils.ts`（カスタムルートテスト）
- E-03: `packages/next/src/experimental/testing/server/middleware-testing-utils.ts`（ミドルウェアテスト）
- E-04: `packages/next/src/experimental/testing/server/utils.ts`（ヘルパー関数）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | index.tsが3つのモジュールからre-exportする | E-01 (1-3行目) | ○ |
| C-02 | unstable_getResponseFromNextConfigはNextResponseを返す | E-02 (87行目) | ○ |
| C-03 | headers -> redirects -> rewritesの評価順序 | E-02 (105-158行目) | ○ |
| C-04 | ヘッダーは累積される | E-02 (105-112行目) | ○ |
| C-05 | リダイレクトは最初の一致で返却 | E-02 (138-148行目) | ○ |
| C-06 | リライトは最初の一致で返却 | E-02 (149-157行目) | ○ |
| C-07 | rewritesはbeforeFiles + afterFiles + fallbackの順 | E-02 (98-102行目) | ○ |
| C-08 | デフォルト200レスポンスを返す | E-02 (158行目) | ○ |
| C-09 | matchRoute関数がhas/missing条件をチェック | E-02 (46-50行目) | ○ |
| C-10 | matchRoute関数がregex + path-to-regexpでマッチング | E-02 (37-51行目) | ○ |
| C-11 | unstable_doesMiddlewareMatchはbooleanを返す | E-03 (19行目) | ○ |
| C-12 | matcher未定義時はtrueを返す | E-03 (32-34行目) | ○ |
| C-13 | getMiddlewareMatchersでmatcher設定を変換 | E-03 (35行目) | ○ |
| C-14 | getMiddlewareRouteMatcherでマッチング関数を生成 | E-03 (36行目) | ○ |
| C-15 | constructRequestがMockedRequest + NodeNextRequestを使用 | E-04 (31行目) | ○ |
| C-16 | getRedirectUrlがlocationヘッダーを取得 | E-04 (39行目) | ○ |
| C-17 | isRewriteがgetRewrittenUrlの結果に基づく | E-04 (47行目) | ○ |
| C-18 | getRewrittenUrlがx-middleware-rewriteヘッダーを取得 | E-04 (55行目) | ○ |
| C-19 | constructRequestがhostヘッダーをURLから自動設定 | E-04 (20-22行目) | ○ |
| C-20 | cookiesがcookieヘッダーに変換される | E-04 (23-29行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張がソースコードの根拠により裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストAPIとして明確な入出力を持つ
- 0: 低リスク - unstable_プレフィックスにより実験的であることが明示されている
- 0: 低リスク - ユニットテストファイルが存在し、実装の検証が可能

## 6) レビュアーチェックリスト（最小）
- [ ] rewritesのbeforeFiles/afterFiles/fallbackの評価順序が正しいか確認
- [ ] matchHas関数のhas/missing条件処理が正確に記述されているか確認
- [ ] unstable_プレフィックスの今後の安定化方針を確認
