---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：12-create-next-app

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **テンプレートファイルの詳細構造**：templates/ディレクトリの完全な内容は未確認
  2. **runTypegen関数の動作**：typegen.tsの詳細実装は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/create-next-app/index.ts`（全715行）
- E-02: `packages/create-next-app/create-app.ts`（冒頭80行確認）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.12行）
- E-04: `packages/create-next-app/package.json`（暗黙参照）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エントリーポイントはpackages/create-next-app/index.ts | E-01, E-03 | ○ |
| C-02 | Commanderで18種類以上のCLIオプションを定義 | E-01（50-111行目） | ○ |
| C-03 | パッケージマネージャは4種類（npm/pnpm/yarn/bun） | E-01（126-134行目） | ○ |
| C-04 | Confライブラリでユーザー設定を永続化 | E-01（137行目, 656行目） | ○ |
| C-05 | CI環境ではプロンプトスキップ | E-01（230行目） | ○ |
| C-06 | 推奨デフォルト/設定再利用/カスタマイズの3択 | E-01（298-346行目） | ○ |
| C-07 | TypeScriptがデフォルト | E-01（235行目） | ○ |
| C-08 | Tailwind CSSがデフォルト | E-01（240行目） | ○ |
| C-09 | App Routerがデフォルト | E-01（239行目） | ○ |
| C-10 | バンドラデフォルトはTurbopack | E-01（593-599行目） | ○ |
| C-11 | インポートエイリアスのバリデーションパターン | E-01（548行目） | ○ |
| C-12 | プロジェクト名のnpm命名規則バリデーション | E-01（195-207行目） | ○ |
| C-13 | 既存ディレクトリの空チェック | E-01（216-218行目） | ○ |
| C-14 | GitHubダウンロード失敗時にデフォルトテンプレート提案 | E-01（621-655行目） | ○ |
| C-15 | createApp関数でテンプレート生成 | E-02（27-63行目） | ○ |
| C-16 | exampleはGitHub URLまたはexample名 | E-01（93-99行目）, E-02（68-72行目） | ○ |
| C-17 | prerelease版のdist-tag対応 | E-01（663-666行目） | ○ |
| C-18 | プロンプト中断時にカーソル復元 | E-01（32-38行目） | ○ |
| C-19 | テンプレートディレクトリの詳細構造 | **根拠不足** | △ |
| C-20 | runTypegenの型定義生成動作 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- テンプレートディレクトリの完全な構造とファイル一覧
  - 候補：`packages/create-next-app/templates/` ディレクトリの詳細確認
- runTypegen関数の動作詳細
  - 候補：`packages/create-next-app/helpers/typegen.ts` の読解

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CLIオプション、プロンプトフロー、エラーハンドリングはソースから明確に確認済み
- 1: 中リスク - テンプレートの具体的内容は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] テンプレート種別（app/default + tw + empty）の組み合わせが正しいか
- [ ] デフォルト設定値が最新のソースと一致しているか
- [ ] async-retryのリトライ設定が正確か
