---
generated_at: 2026-02-03 15:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：120-Test Mode

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **プロキシサーバーの詳細実装**：proxy/server.tsの内容未読み込み

## 2) 参照した情報（Evidence一覧）
- E-01: `packages/next/src/experimental/testmode/context.ts`（テストコンテキスト）
- E-02: `packages/next/src/experimental/testmode/server.ts`（サーバーインターセプト）
- E-03: `packages/next/src/experimental/testmode/fetch.ts`（fetchインターセプト）
- E-04: `packages/next/src/experimental/testmode/playwright/index.ts`（Playwright統合エントリー）
- E-05: `packages/next/src/experimental/testmode/playwright/next-fixture.ts`（NextFixture実装）
- E-06: `packages/next/src/experimental/testmode/proxy/index.ts`（プロキシエクスポート）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TestReqInfoはurl, proxyPort, testDataの3フィールド | E-01 (3-7行目) | ○ |
| C-02 | AsyncLocalStorageでテストコンテキスト管理 | E-01 (14行目) | ○ |
| C-03 | next-test-proxy-portヘッダーでテストモード判定 | E-01 (20-21行目) | ○ |
| C-04 | withRequest関数でtestStorage.run実行 | E-01 (30-40行目) | ○ |
| C-05 | interceptTestApisがfetchとhttp.getをインターセプト | E-02 (24-34行目) | ○ |
| C-06 | wrapRequestHandlerWorkerがwithRequestでラップ | E-02 (36-40行目) | ○ |
| C-07 | wrapRequestHandlerNodeがwithRequestでラップ | E-02 (42-47行目) | ○ |
| C-08 | interceptFetchがglobal.fetchを置換 | E-03 (127-142行目) | ○ |
| C-09 | internal flagのfetchはインターセプトを透過 | E-03 (133-135行目) | ○ |
| C-10 | getTestStackがフレームワーク行を除外 | E-03 (31行目) | ○ |
| C-11 | スタックトレースは最大5行 | E-03 (33行目) | ○ |
| C-12 | buildProxyRequestがfetch情報をJSON化 | E-03 (39-75行目) | ○ |
| C-13 | プロキシ応答がcontinue/fetch/abort/unhandledの4種類 | E-03 (112-124行目) | ○ |
| C-14 | プロキシ通信はlocalhost上 | E-03 (98行目) | ○ |
| C-15 | body はBase64エンコード | E-03 (64行目, 79行目) | ○ |
| C-16 | defineConfigがwebServer設定をマージ | E-04 (14-31行目) | ○ |
| C-17 | testフィクスチャにnextとnextOptionsが拡張される | E-04 (36-58行目) | ○ |
| C-18 | fetchLoopbackのデフォルトはfalse | E-04 (40行目) | ○ |
| C-19 | NextFixtureImplがfetchHandlersを逆順で評価 | E-05 (49行目) | ○ |
| C-20 | setup時にpage.context().routeでテストヘッダー注入 | E-05 (32-36行目) | ○ |
| C-21 | teardown時にcleanupTestを呼ぶ | E-05 (39-41行目) | ○ |
| C-22 | プロキシサーバーの詳細実装（createProxyServer） | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-22: proxy/server.tsの詳細実装は読み込んでいないため、プロキシサーバーの内部動作の詳細が不明。
  - 候補：packages/next/src/experimental/testmode/proxy/server.ts

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストコンテキストの伝搬メカニズムは確認済み
- 0: 低リスク - fetchインターセプトの動作は詳細に確認済み
- 1: 中リスク - プロキシサーバーの詳細実装は未確認
- 1: 中リスク - プロダクション環境でテストヘッダーが意図せず処理されるリスク

## 6) レビュアーチェックリスト（最小）
- [ ] proxy/server.tsの詳細実装を確認
- [ ] プロダクション環境でテストヘッダーが処理されない保証を確認
- [ ] Edge Runtime（server-edge.ts）でのインターセプト動作を確認
- [ ] MSW統合（playwright/msw.ts）の動作を確認
- [ ] fetchHandlersの逆順評価の意図を確認（後から登録したハンドラーが優先）
