---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 19
  claims_without_evidence: 3
confidence_derived: 0.86
---

# 根拠レポート：13-App Router

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：19 / 22、根拠なし：3
- 優先レビュー（高）
  1. **app-router.tsxのクライアントサイド詳細**：クライアントサイドルーターの完全な実装は大規模で部分的確認
  2. **プリフェッチ機構の詳細**：プリフェッチの具体的な挙動は要確認
  3. **ハイブリッドモードの共存詳細**：Pages RouterとApp Routerの共存メカニズム

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/app-render/app-render.tsx`（2349行目付近確認）
- E-02: `packages/next/src/server/app-render/create-component-tree.tsx`（全体確認）
- E-03: `packages/next/src/client/components/layout-router.tsx`（冒頭80行+380-500行目確認）
- E-04: `packages/next/src/client/components/error-boundary.tsx`（全体確認）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.13行）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能No.13関連行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | renderToHTMLOrFlightが2349行目にある | E-01 | ○ |
| C-02 | createComponentTreeでコンポーネントツリーを構築 | E-02（49-69行目） | ○ |
| C-03 | parseLoaderTreeでセグメント情報を抽出 | E-02（136-137行目） | ○ |
| C-04 | layout/template/error/loading/not-foundモジュールを取得 | E-02（139-147行目） | ○ |
| C-05 | parallelRoutesの再帰的処理 | E-02（458行目以降） | ○ |
| C-06 | OuterLayoutRouterでクライアントルート切り替え | E-03（492行目） | ○ |
| C-07 | LoadingBoundaryProviderでローディング状態管理 | E-03（402-445行目） | ○ |
| C-08 | ErrorBoundaryHandlerでエラーキャッチ | E-04（37-118行目） | ○ |
| C-09 | not-found/forbidden/unauthorizedのHTTPエラー処理 | E-02（218-254行目）, E-01 | ○ |
| C-10 | Server ComponentがデフォルトでServer | E-05 | ○ |
| C-11 | RSCヘッダーによるリクエスト種別判定 | E-01（2367-2373行目） | ○ |
| C-12 | FlightRouterStateがクライアントステート | E-01（import文） | ○ |
| C-13 | 関連画面マッピングが正しい | E-06 | ○ |
| C-14 | ストリーミングレンダリング対応 | E-01（import文: renderToInitialFizzStream等） | ○ |
| C-15 | PPR対応（postponedState解析） | E-01（2380-2398行目） | ○ |
| C-16 | 動的セグメント・ルートグループの規約 | E-05 | ○ |
| C-17 | ファイル規約（page/layout/loading/error等） | E-02（139-147行目） | ○ |
| C-18 | ハードナビゲーションフォールバック | E-04（66-74行目） | ○ |
| C-19 | redirectエラーハンドリング | E-01（import: isRedirectError, getURLFromRedirectError） | ○ |
| C-20 | クライアントサイドApp Routerの完全な挙動 | **根拠不足** | △ |
| C-21 | プリフェッチの具体的挙動 | **根拠不足** | △ |
| C-22 | Pages Routerとの共存メカニズム | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- app-router.tsxのクライアントサイドルーターReducerの完全な動作
  - 候補：`packages/next/src/client/components/app-router.tsx` の全体読解
- プリフェッチキャッシュの具体的な管理方法
  - 候補：`packages/next/src/client/components/router-reducer/` ディレクトリの読解
- Pages RouterとApp Routerのルーティング優先度
  - 候補：`packages/next/src/server/lib/router-server.ts` の読解

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - app-render.tsxは2400行超の大規模ファイルで、全行の確認はできていない
- 1: 中リスク - クライアントサイドルーターReducerの複雑な状態管理は部分的にのみ確認

## 6) レビュアーチェックリスト（最小）
- [ ] renderToHTMLOrFlightのレンダリング分岐パターンが網羅されているか
- [ ] FlightRouterStateの構造が正確に記述されているか
- [ ] プリフェッチ時の挙動が正しいか
- [ ] エラーバウンダリの階層構造が正しいか
