---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：14-レイアウト（Layouts）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **ナビゲーション時の状態保持メカニズム**：クライアントサイドキャッシュの詳細
  2. **デフォルトレイアウト提供の正確なトリガー条件**

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/app-render/create-component-tree.tsx`（全体確認）
- E-02: `packages/next/src/client/components/layout-router.tsx`（部分確認）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.14行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能No.14関連行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | layout.tsxファイルによる定義 | E-03 | ○ |
| C-02 | parseLoaderTreeでlayoutモジュール抽出 | E-01（136-147行目） | ○ |
| C-03 | getLayoutOrPageModuleでモジュール取得 | E-01（194-206行目） | ○ |
| C-04 | rootLayoutAtThisLevel判定 | E-01（211-216行目） | ○ |
| C-05 | errorMissingDefaultExportでエラー | E-01（71-78行目） | ○ |
| C-06 | CSS/JSアセット解決 | E-01（155-162行目） | ○ |
| C-07 | template.tsx存在時のテンプレートラップ | E-01（164-172行目） | ○ |
| C-08 | error/loading/not-foundのコンポーネント解決 | E-01（174-226行目） | ○ |
| C-09 | parallelRoutesの再帰処理 | E-01（458行目以降） | ○ |
| C-10 | OuterLayoutRouterでクライアント管理 | E-02（492行目） | ○ |
| C-11 | LayoutRouterContextでコンテキスト提供 | E-02（370-397行目） | ○ |
| C-12 | ルートレイアウトにhtml/body必須 | E-03 | ○ |
| C-13 | 関連画面マッピング | E-04 | ○ |
| C-14 | デフォルトレイアウト提供 | E-04（画面No.10） | ○ |
| C-15 | ナビゲーション時の状態保持メカニズム詳細 | **根拠不足** | △ |
| C-16 | template.tsxとの差異の技術的詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- クライアントサイドでのレイアウトキャッシュと再レンダリング回避の実装詳細
  - 候補：`packages/next/src/client/components/router-reducer/` の読解
- template.tsxの新インスタンス生成メカニズムの具体的な実装
  - 候補：layout-router.tsx内のtemplate処理コードの詳細読解

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サーバーサイドのレイアウト処理はcreate-component-tree.tsxから明確に確認
- 1: 中リスク - クライアントサイドの状態保持は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] ルートレイアウト判定（rootLayoutIncluded）のロジックが正しいか
- [ ] ネストされたレイアウトのCSS/JSアセットの重複排除が正しく記述されているか
- [ ] デフォルトレイアウトの挙動が最新の実装と一致しているか
