---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：15-ローディングUI

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **ストリーミング時のフォールバック差し替えメカニズム**：Fizzストリーミングの内部動作は要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/app-render/create-component-tree.tsx`（184-192行目確認）
- E-02: `packages/next/src/client/components/layout-router.tsx`（402-486行目確認）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.15行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | loading.tsxによるローディング定義 | E-03 | ○ |
| C-02 | modules.loadingの抽出 | E-01（139-147行目） | ○ |
| C-03 | createComponentStylesAndScriptsでLoading解決 | E-01（184-192行目） | ○ |
| C-04 | LoadingModuleDataは3要素タプル | E-02（466-468行目） | ○ |
| C-05 | LoadingBoundaryProviderでコンテキスト提供 | E-02（402-445行目） | ○ |
| C-06 | parentLoadingDataとしてLoading設定 | E-02（436行目） | ○ |
| C-07 | LoadingBoundaryでSuspenseバウンダリ構築 | E-02（451-486行目） | ○ |
| C-08 | loading !== nullの条件チェック | E-02（465行目） | ○ |
| C-09 | SuspenseのfallbackにloadingRsc等を設定 | E-02（470-478行目） | ○ |
| C-10 | loading.tsx非存在時はSuspenseなし | E-02（485行目） | ○ |
| C-11 | 並列ルート対応のコメント | E-02（411-414行目のコメント） | ○ |
| C-12 | hasLoadingComponentInTreeの存在 | E-01（18行目import文） | ○ |
| C-13 | Suspenseバウンダリのname属性 | E-02（471行目） | ○ |
| C-14 | ストリーミング時のフォールバック差し替え詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Fizzストリーミングのフォールバック差し替えメカニズムの内部動作
  - 候補：`packages/next/src/server/stream-utils/` ディレクトリの読解

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サーバー・クライアント両方のloading処理がソースから明確に確認

## 6) レビュアーチェックリスト（最小）
- [ ] LoadingModuleDataの型定義が最新か
- [ ] LoadingBoundaryのSuspense props（name等）が正確か
- [ ] 並列ルート時のloading挙動が正しいか
