---
generated_at: 2026-02-03 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：16-エラーハンドリング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **global-error.tsxのhtml/body要件**：global-errorの具体的な実装要件
  2. **HTTPAccessFallbackBoundaryの詳細動作**

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/components/error-boundary.tsx`（全157行確認）
- E-02: `packages/next/src/server/app-render/create-component-tree.tsx`（174-182行目確認）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.16行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能No.16関連行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | error.tsxによるエラーバウンダリ定義 | E-03 | ○ |
| C-02 | ErrorBoundaryHandlerがクラスコンポーネント | E-01（37-118行目） | ○ |
| C-03 | getDerivedStateFromErrorでエラーキャプチャ | E-01（46-54行目） | ○ |
| C-04 | Next.jsルーターエラーの再throw | E-01（47-51行目） | ○ |
| C-05 | getDerivedStateFromPropsでパス変更リセット | E-01（56-92行目） | ○ |
| C-06 | ハードナビゲーションフォールバック | E-01（66-74行目） | ○ |
| C-07 | ボットリクエスト時のバイパス | E-01（10-11行目, 102行目） | ○ |
| C-08 | HandleISRError連携 | E-01（7行目import, 105行目） | ○ |
| C-09 | reset関数によるステートクリア | E-01（94-96行目） | ○ |
| C-10 | ErrorBoundary関数コンポーネントのラップ判定 | E-01（129-156行目） | ○ |
| C-11 | errorComponent未定義時はchildren直接表示 | E-01（155行目） | ○ |
| C-12 | ErrorComponent型にerrorとオプショナルreset | E-01（13-18行目） | ○ |
| C-13 | サーバーサイドのerror解決 | E-02（174-182行目） | ○ |
| C-14 | 関連画面マッピング（6画面） | E-04 | ○ |
| C-15 | error.tsxはClient Component必須 | E-01（1行目 'use client'） | ○ |
| C-16 | forbidden/unauthorized対応 | E-02（234-254行目） | ○ |
| C-17 | errorStyles/errorScriptsの提供 | E-01（106-107行目） | ○ |
| C-18 | pathname追跡にuseUntrackedPathname | E-01（141行目） | ○ |
| C-19 | global-error.tsxのhtml/body定義要件 | **根拠不足** | △ |
| C-20 | HTTPAccessFallbackBoundaryの詳細動作 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- global-error.tsxの具体的な実装要件とルートレイアウト代替の仕組み
  - 候補：`packages/next/src/server/app-render/` 内のglobal-error処理コードの確認
- HTTPAccessFallbackBoundaryの詳細実装
  - 候補：`packages/next/src/client/components/http-access-fallback/error-boundary.tsx` の読解

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ErrorBoundaryHandlerの動作はソースから完全に確認済み
- 1: 中リスク - global-errorとHTTPAccessFallbackの連携は部分的確認

## 6) レビュアーチェックリスト（最小）
- [ ] ルーターエラーの判定ロジック（isNextRouterError）が正しいか
- [ ] ボットUA判定の実装が正確か
- [ ] HandleISRErrorの再検証トリガー条件が正しいか
- [ ] forbidden/unauthorizedのエラーコードが正しいか
