---
generated_at: 2026-02-03 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：17-Server Components

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **React Flightシリアライゼーションの詳細**：react-server-dom-webpackの内部実装
  2. **クライアントサイドデシリアライゼーションの詳細**

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/lib/client-and-server-references.ts`（全49行確認）
- E-02: `packages/next/src/server/app-render/create-component-tree.tsx`（741行目付近確認）
- E-03: `packages/next/src/server/app-render/app-render.tsx`（2349行目付近確認）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.17行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトでServer Component | E-04 | ○ |
| C-02 | isClientReferenceで$$typeof判定 | E-01（45-48行目） | ○ |
| C-03 | Symbol.for('react.client.reference')で判定 | E-01（47行目） | ○ |
| C-04 | isServerReferenceでserver reference判定 | E-01（15-19行目） | ○ |
| C-05 | create-component-treeで741行目にisClientComponent | E-02 | ○ |
| C-06 | Client ComponentはClientPageRootでラップ | E-02（768-786行目） | ○ |
| C-07 | Client ComponentはClientSegmentRootでラップ | E-02（878-896行目） | ○ |
| C-08 | renderToHTMLOrFlightが2349行目 | E-03 | ○ |
| C-09 | FlightRenderResultで出力 | E-03（import文） | ○ |
| C-10 | getClientReferenceManifestでマニフェスト管理 | E-03（import文） | ○ |
| C-11 | propsシリアライズ制約 | E-04 | ○ |
| C-12 | asyncサポート | E-04 | ○ |
| C-13 | クライアントAPIの使用制約 | E-04 | ○ |
| C-14 | ソースコードが非送信 | E-04 | ○ |
| C-15 | React Flightシリアライゼーション詳細 | **根拠不足** | △ |
| C-16 | クライアントデシリアライゼーション詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- React Flight（react-server-dom-webpack）のシリアライゼーション/デシリアライゼーション実装詳細
  - 候補：react-server-dom-webpackパッケージの読解
- クライアントサイドでのRSCペイロード復元メカニズム
  - 候補：`packages/next/src/client/components/app-router.tsx` 内のFlight消費コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - isClientReferenceの判定ロジックはソースから確実に確認
- 1: 中リスク - React Flightプロトコルの内部はReact側の実装に依存

## 6) レビュアーチェックリスト（最小）
- [ ] isClientReferenceの判定条件が正確か
- [ ] ClientPageRoot/ClientSegmentRootの使い分け条件が正しいか
- [ ] propsのシリアライズ制約が最新の仕様と一致しているか
