---
generated_at: 2026-02-03 11:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：18-Client Components

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **バンドラのClient Reference変換の詳細**：Webpack/Turbopackの内部変換処理
  2. **ハイドレーションの具体的な実装**

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/lib/client-and-server-references.ts`（全49行確認）
- E-02: `packages/next/src/server/app-render/create-component-tree.tsx`（741行目付近確認）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.18行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 'use client'ディレクティブで指定 | E-03 | ○ |
| C-02 | isClientReferenceで$$typeof判定 | E-01（45-48行目） | ○ |
| C-03 | mod.defaultまたはmodで判定 | E-01（46行目） | ○ |
| C-04 | isClientComponent = isClientReference(layoutOrPageMod) | E-02（741行目） | ○ |
| C-05 | ClientPageRootでページをラップ | E-02（768行目） | ○ |
| C-06 | ClientSegmentRootでセグメントをラップ | E-02（878行目） | ○ |
| C-07 | propsのシリアライズ制約 | E-03 | ○ |
| C-08 | クライアントバンドルに含まれる | E-03 | ○ |
| C-09 | SSRサポート | E-03 | ○ |
| C-10 | 境界伝搬（インポート先もCC） | E-03 | ○ |
| C-11 | Compositionパターン（SCをchildren渡し） | E-03 | ○ |
| C-12 | ハイドレーションミスマッチの警告 | E-03 | ○ |
| C-13 | Client Reference Manifest管理 | E-02（import文） | ○ |
| C-14 | バンドラによるClient Reference変換詳細 | **根拠不足** | △ |
| C-15 | ハイドレーション実装詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Webpack/TurbopackでのClient Reference変換プロセスの詳細
  - 候補：`packages/next/src/build/webpack/` 内のplugin実装
- クライアントサイドのハイドレーション実装
  - 候補：`packages/next/src/client/app-index.tsx` などの読解

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - isClientReferenceとcreate-component-treeの処理は確認済み
- 1: 中リスク - ビルド時変換とハイドレーションの詳細は部分的確認

## 6) レビュアーチェックリスト（最小）
- [ ] 'use client'ディレクティブの検出タイミング（ビルド時）が正しいか
- [ ] ClientPageRoot/ClientSegmentRootの使い分け条件が正確か
- [ ] SSR時のClient Component処理が正確に記述されているか
