---
generated_at: 2026-02-03 11:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：19-Server Actions

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **暗号化処理の詳細**：encryption.tsの実装詳細
  2. **decodeReplyの処理詳細**：react-server-dom-webpackのdecodeReply実装

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/app-render/action-handler.ts`（冒頭100行+531-610行目確認）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.19行）
- E-03: `packages/next/src/client/components/app-router-headers.ts`（ヘッダー定数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 'use server'ディレクティブで定義 | E-02 | ○ |
| C-02 | handleAction関数が531行目 | E-01（531行目） | ○ |
| C-03 | getServerActionRequestMetadataでメタデータ抽出 | E-01（556-562行目） | ○ |
| C-04 | isPossibleServerActionチェック | E-01（585行目） | ○ |
| C-05 | hasServerActions()で存在チェック | E-01（603行目） | ○ |
| C-06 | 静的生成中のエラー | E-01（607-609行目） | ○ |
| C-07 | CSRF保護（isCsrfOriginAllowed） | E-01（48行目import） | ○ |
| C-08 | URL Encoded Actions非サポート | E-01（591-600行目） | ○ |
| C-09 | INLINE_ACTION_PREFIX定義 | E-01（76行目） | ○ |
| C-10 | hasServerActionsでnode/edge確認 | E-01（81-88行目） | ○ |
| C-11 | nodeHeadersToRecord変換 | E-01（90-100行目） | ○ |
| C-12 | getForwardedHeadersの構築 | E-01（102-142行目） | ○ |
| C-13 | addRevalidationHeaderの設定 | E-01（144-198行目） | ○ |
| C-14 | createForwardedActionResponseでワーカー転送 | E-01（203行目） | ○ |
| C-15 | NEXT_ACTION_NOT_FOUND_HEADERの設定 | E-01（573行目） | ○ |
| C-16 | 404ステータスでアクション未発見 | E-01（575行目） | ○ |
| C-17 | ACTION_HEADER等のヘッダー定数 | E-03 | ○ |
| C-18 | selectWorkerForForwardingでワーカー選択 | E-01（54行目import） | ○ |
| C-19 | executeRevalidatesで再検証実行 | E-01（68行目import） | ○ |
| C-20 | synchronizeMutableCookiesでCookie同期 | E-01（64行目import） | ○ |
| C-21 | encryption.tsの暗号化詳細 | **根拠不足** | △ |
| C-22 | decodeReplyの処理詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- Server Actionsの暗号化処理（encryption.ts）の詳細実装
  - 候補：`packages/next/src/server/app-render/encryption.ts` の読解
- react-server-dom-webpackのdecodeReply実装詳細
  - 候補：react-server-dom-webpackパッケージの読解

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - handleAction関数の処理フローはソースから詳細に確認済み
- 0: 低リスク - CSRF保護とヘッダー処理は明確
- 1: 中リスク - 暗号化とdecodeReplyの内部は外部依存

## 6) レビュアーチェックリスト（最小）
- [ ] handleActionの全分岐パターンが網羅されているか
- [ ] CSRF保護のオリジン検証ルールが正確か
- [ ] ワーカー転送の条件とメカニズムが正しいか
- [ ] 再検証ヘッダーの設定条件が正しいか
