---
generated_at: 2026-02-03 11:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：20-並列ルート（Parallel Routes）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **ソフトナビゲーション時の非アクティブスロット保持**：React Activityの動作詳細
  2. **FlightRouterStateでのスロット別ステート管理**

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/app-render/create-component-tree.tsx`（136行目、458行目、525行目、869-870行目確認）
- E-02: `packages/next/src/client/components/builtin/default.tsx`（全9行確認）
- E-03: `packages/next/src/client/components/layout-router.tsx`（492行目確認）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（No.20行）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能No.20関連行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @folder規約でスロット定義 | E-04 | ○ |
| C-02 | parseLoaderTreeでparallelRoutes取得 | E-01（136行目） | ○ |
| C-03 | Object.keys(parallelRoutes).map()で各スロット処理 | E-01（458行目） | ○ |
| C-04 | parallelRoute = parallelRoutes[parallelRouteKey] | E-01（463行目） | ○ |
| C-05 | PARALLEL_ROUTE_DEFAULT_PATHでデフォルト判定 | E-01（525行目） | ○ |
| C-06 | 並列ルート存在判定（length > 1） | E-01（869-870行目） | ○ |
| C-07 | ParallelRouteDefaultがnotFound()呼び出し | E-02（6-8行目） | ○ |
| C-08 | PARALLEL_ROUTE_DEFAULT_PATH定数 | E-02（3行目） | ○ |
| C-09 | OuterLayoutRouterにparallelRouterKey | E-03（492行目） | ○ |
| C-10 | "children"がデフォルトスロット | E-01（869行目） | ○ |
| C-11 | 各スロットに独立したloading/errorが可能 | E-01（コンポーネント構造から推論） | ○ |
| C-12 | default.tsx未定義時のビルトインフォールバック | E-02 | ○ |
| C-13 | 関連画面マッピング（画面No.11） | E-05 | ○ |
| C-14 | LoadingBoundaryProviderでスロット別ローディング | E-03（402-445行目） | ○ |
| C-15 | createComponentTreeInternalの再帰呼び出し | E-01（458行目以降） | ○ |
| C-16 | レイアウトがスロット別propsを受け取る | E-01（構造から推論） | ○ |
| C-17 | ソフトナビゲーション時の非アクティブスロット保持 | **根拠不足** | △ |
| C-18 | FlightRouterStateのスロット別ステート管理 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ソフトナビゲーション時の非アクティブスロットの状態保持メカニズム
  - 候補：`packages/next/src/client/components/layout-router.tsx` のActivity/Offscreen処理
- FlightRouterStateでのスロット別ステート管理の詳細
  - 候補：`packages/next/src/client/components/router-reducer/` の読解

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サーバーサイドのparallelRoutes処理は明確に確認済み
- 0: 低リスク - ビルトインデフォルトの動作は完全に確認済み
- 1: 中リスク - クライアントサイドのスロット状態保持は部分的確認

## 6) レビュアーチェックリスト（最小）
- [ ] parallelRoutesのキー列挙と再帰処理が正しく記述されているか
- [ ] default.tsxのフォールバック階層が正確か
- [ ] "children"スロットの特殊扱いが正しいか
- [ ] React Activityの非アクティブスロット管理が正しいか
