---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：27-getServerSideProps

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **C-12**：getServerSidePropsのコンテキスト構築（resolvedUrl/locale等の注入）の具体的実装箇所

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/render.tsx` - レンダリングロジック
- E-02: `packages/next/src/types.ts` - GetServerSideProps型定義
- E-03: `packages/next/src/server/route-modules/pages/module.ts` - PagesRouteModule
- E-04: `packages/next/src/lib/is-serializable-props.ts` - シリアライズ検証
- E-05: `packages/next/src/lib/constants.ts` - エラー定数
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getServerSidePropsはリクエスト時にサーバーサイドで実行 | E-01 (493行目, SSR実行フロー) | ○ |
| C-02 | getInitialPropsとの共存チェック | E-01 (569-570行目) | ○ |
| C-03 | getStaticPropsとの共存チェック | E-01 (573-575行目) | ○ |
| C-04 | output:exportとの非互換チェック | E-01 (577-580行目) | ○ |
| C-05 | コンポーネントメンバーとしての定義禁止 | E-01 (655-665行目) | ○ |
| C-06 | 戻り値がオブジェクトでない場合のエラー | E-05 (GSSP_NO_RETURNED_VALUE) | ○ |
| C-07 | propsのシリアライズ検証 | E-04 | ○ |
| C-08 | プレビューモード判定 | E-01 (672-678行目付近) | ○ |
| C-09 | ステータスページでの使用禁止 | E-01 (636-648行目) | ○ |
| C-10 | サーバー専用でクライアントバンドルに含まれない | E-01 (概念的にサーバーサイド処理) | ○ |
| C-11 | OpenTelemetryトレーシング | E-01 (getServerSidePropsスパン) | ○ |
| C-12 | コンテキストのresolvedUrl/locale等の注入 | **根拠なし** (具体的注入箇所の行番号未特定) | △ |

## 4) 不足情報（Unknown / Missing）
- getServerSidePropsに渡されるコンテキストオブジェクトの詳細な構築処理
  - 候補：`packages/next/src/server/render.tsx`内の該当箇所（850行目以降）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 排他制約チェックは行番号レベルで確認済み
- 0: 低リスク - エラー定数は明確に定義されている
- 0: 低リスク - シリアライズ検証はis-serializable-props.tsで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] getServerSidePropsのコンテキスト構築箇所を確認
- [ ] 排他制約のエラーメッセージが最新か確認
- [ ] propsシリアライズ検証のロジックが正確か確認
