---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：28-getStaticProps

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **C-12**：ISR再検証失敗時のstale-while-revalidate戦略の具体的実装根拠

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/render.tsx` - レンダリングロジック
- E-02: `packages/next/src/types.ts` - GetStaticProps型定義
- E-03: `packages/next/src/server/route-modules/pages/module.ts` - PagesRouteModule
- E-04: `packages/next/src/lib/is-serializable-props.ts` - シリアライズ検証
- E-05: `packages/next/src/lib/constants.ts` - エラー定数
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isSSG = !!getStaticPropsで判定 | E-01 (519行目) | ○ |
| C-02 | getInitialPropsとの共存チェック | E-01 (565-566行目) | ○ |
| C-03 | getServerSidePropsとの共存チェック | E-01 (573-575行目) | ○ |
| C-04 | 動的ルートでgetStaticPathsが必須 | E-01 (596-601行目) | ○ |
| C-05 | コンポーネントメンバーとしての定義禁止 | E-01 (655-665行目) | ○ |
| C-06 | 戻り値がオブジェクトでない場合のエラー | E-05 (GSP_NO_RETURNED_VALUE) | ○ |
| C-07 | propsのシリアライズ検証 | E-04 | ○ |
| C-08 | UNSTABLE_REVALIDATE_RENAME_ERROR | E-05 | ○ |
| C-09 | PagesUserlandModuleでgetStaticPropsを定義 | E-03 (52-53行目) | ○ |
| C-10 | ビルド時に事前生成されCDN配信に最適化 | E-01 (概念的にSSG処理) | ○ |
| C-11 | プレビューモードでのDraft Mode対応 | E-01 (672-678行目付近) | ○ |
| C-12 | ISR再検証失敗時のstale-while-revalidate | **根拠なし** (incremental-cacheの実装未確認) | △ |

## 4) 不足情報（Unknown / Missing）
- ISR再検証失敗時のstale-while-revalidate戦略の具体的実装
  - 候補：`packages/next/src/server/lib/incremental-cache/` / `packages/next/src/server/response-cache/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - SSG判定と排他制約は行番号レベルで確認済み
- 0: 低リスク - エラー定数とシリアライズ検証は確認可能
- 1: 中リスク - ISR stale-while-revalidate戦略の実装詳細は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] getStaticPropsの実行フローがrender.tsxで正しく記述されているか確認
- [ ] revalidateオプションの型チェックロジックを確認
- [ ] ISR再検証失敗時の挙動をincremental-cacheで確認
